/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.utils;

import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class ItemStackSerializer {
    private static final List<String> ARMOR_MATERIALS = Arrays.asList("LEATHER", "CHAINMAIL", "IRON", "GOLDEN", "DIAMOND", "NETHERITE");
    private static final List<String> ARMOR_PIECES = Arrays.asList("_HELMET", "_CHESTPLATE", "_LEGGINGS", "_BOOTS");
    private static final List<String> TOOL_TYPES = Arrays.asList("_SWORD", "_PICKAXE", "_AXE", "_SHOVEL", "_HOE");

    public static List<String> serializeInventory(Map<VirtualInventory.ItemSignature, Long> items) {
        HashMap<Material, ItemGroup> groupedItems = new HashMap<Material, ItemGroup>();
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : items.entrySet()) {
            ItemStack template = entry.getKey().getTemplate();
            Material material = template.getType();
            ItemGroup group = groupedItems.computeIfAbsent(material, ItemGroup::new);
            if (material == Material.TIPPED_ARROW) {
                PotionMeta meta = (PotionMeta)template.getItemMeta();
                if (meta != null && meta.getBasePotionType() != null) {
                    group.addPotionArrow(meta.getBasePotionType(), entry.getValue().intValue());
                    continue;
                }
                group.addPotionArrow(PotionType.WATER, entry.getValue().intValue());
                continue;
            }
            if (ItemStackSerializer.isDestructibleItem(material)) {
                int damage = ItemStackSerializer.getDamageValue(template);
                group.addItem(damage, entry.getValue().intValue());
                continue;
            }
            group.addItem(0, entry.getValue().intValue());
        }
        ArrayList<String> serializedItems = new ArrayList<String>();
        for (ItemGroup group : groupedItems.values()) {
            boolean first;
            if (group.getMaterial() == Material.TIPPED_ARROW) {
                StringBuilder sb = new StringBuilder("TIPPED_ARROW#");
                first = true;
                for (Map.Entry<String, Integer> entry : group.getPotionTypeCount().entrySet()) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(entry.getKey()).append(':').append(entry.getValue());
                    first = false;
                }
                serializedItems.add(sb.toString());
                continue;
            }
            if (ItemStackSerializer.isDestructibleItem(group.getMaterial())) {
                StringBuilder sb = new StringBuilder(group.getMaterial().name());
                sb.append(';');
                first = true;
                for (Map.Entry<Object, Integer> entry : group.getDamageCount().entrySet()) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(entry.getKey()).append(':').append(entry.getValue());
                    first = false;
                }
                serializedItems.add(sb.toString());
                continue;
            }
            int totalCount = group.getDamageCount().values().stream().mapToInt(Integer::intValue).sum();
            serializedItems.add(group.getMaterial().name() + ":" + totalCount);
        }
        return serializedItems;
    }

    public static Map<ItemStack, Integer> deserializeInventory(List<String> data) {
        HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
        for (String entry : data) {
            Material material;
            String[] parts;
            if (entry.startsWith("TIPPED_ARROW#")) {
                String[] potionEntries;
                for (String potionEntry : potionEntries = entry.substring("TIPPED_ARROW#".length()).split(",")) {
                    String[] parts2 = potionEntry.split(":");
                    String potionTypeName = parts2[0];
                    int count = Integer.parseInt(parts2[1]);
                    ItemStack arrow = new ItemStack(Material.TIPPED_ARROW);
                    PotionMeta meta = (PotionMeta)arrow.getItemMeta();
                    if (meta != null) {
                        try {
                            PotionType potionType = PotionType.valueOf((String)potionTypeName);
                            meta.setBasePotionType(potionType);
                            arrow.setItemMeta((ItemMeta)meta);
                        }
                        catch (IllegalArgumentException e) {
                            meta.setBasePotionType(PotionType.WATER);
                            arrow.setItemMeta((ItemMeta)meta);
                        }
                    }
                    result.put(arrow, count);
                }
                continue;
            }
            if (entry.contains(";")) {
                parts = entry.split(";");
                material = Material.valueOf((String)parts[0]);
                for (String damageCount : parts[1].split(",")) {
                    String[] dc = damageCount.split(":");
                    int damage = Integer.parseInt(dc[0]);
                    int count = Integer.parseInt(dc[1]);
                    ItemStack item = new ItemStack(material);
                    ItemStackSerializer.setDamageValue(item, damage);
                    result.put(item, count);
                }
                continue;
            }
            parts = entry.split(":");
            material = Material.valueOf((String)parts[0]);
            int count = Integer.parseInt(parts[1]);
            ItemStack item = new ItemStack(material);
            result.put(item, count);
        }
        return result;
    }

    private static int getDamageValue(ItemStack item) {
        if (item.getItemMeta() instanceof Damageable) {
            return ((Damageable)item.getItemMeta()).getDamage();
        }
        return 0;
    }

    private static void setDamageValue(ItemStack item, int damage) {
        if (item.getItemMeta() instanceof Damageable) {
            Damageable meta = (Damageable)item.getItemMeta();
            meta.setDamage(damage);
            item.setItemMeta((ItemMeta)meta);
        }
    }

    public static boolean isDestructibleItem(Material material) {
        String name = material.name();
        for (String type : TOOL_TYPES) {
            if (!name.endsWith(type)) continue;
            return true;
        }
        for (String armorMaterial : ARMOR_MATERIALS) {
            for (String armorPiece : ARMOR_PIECES) {
                if (!name.equals(armorMaterial + armorPiece)) continue;
                return true;
            }
        }
        return name.equals("BOW") || name.equals("FISHING_ROD") || name.equals("FLINT_AND_STEEL") || name.equals("SHEARS") || name.equals("SHIELD") || name.equals("ELYTRA") || name.equals("TRIDENT") || name.equals("CROSSBOW") || name.equals("CARROT_ON_A_STICK") || name.equals("WARPED_FUNGUS_ON_A_STICK") || name.equals("MACE");
    }

    public static class ItemGroup {
        private final Material material;
        private final Map<Integer, Integer> damageCount;
        private final Map<String, Integer> potionTypeCount;

        public ItemGroup(Material material) {
            this.material = material;
            this.damageCount = new HashMap<Integer, Integer>();
            this.potionTypeCount = new HashMap<String, Integer>();
        }

        public void addItem(int damage, int count) {
            this.damageCount.merge(damage, count, Integer::sum);
        }

        public void addPotionArrow(PotionType potionType, int count) {
            String potionKey = potionType.name();
            this.potionTypeCount.merge(potionKey, count, Integer::sum);
        }

        @Generated
        public Material getMaterial() {
            return this.material;
        }

        @Generated
        public Map<Integer, Integer> getDamageCount() {
            return this.damageCount;
        }

        @Generated
        public Map<String, Integer> getPotionTypeCount() {
            return this.potionTypeCount;
        }
    }
}

