/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.updates;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.updates.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageUpdater {
    private final String currentVersion;
    private final SmartSpawner plugin;
    private static final String LANGUAGE_VERSION_KEY = "language_version";
    private static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("en_US", "vi_VN", "de_DE");
    private final Set<LanguageFileType> activeFileTypes = new HashSet<LanguageFileType>();

    public LanguageUpdater(SmartSpawner plugin) {
        this(plugin, LanguageFileType.values());
    }

    public LanguageUpdater(SmartSpawner plugin, LanguageFileType ... fileTypes) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        this.activeFileTypes.addAll(Arrays.asList(fileTypes));
        this.checkAndUpdateLanguageFiles();
    }

    public void checkAndUpdateLanguageFiles() {
        for (String language : SUPPORTED_LANGUAGES) {
            File langDir = new File(this.plugin.getDataFolder(), "language/" + language);
            if (!langDir.exists()) {
                langDir.mkdirs();
            }
            for (LanguageFileType fileType : this.activeFileTypes) {
                File languageFile = new File(langDir, fileType.getFileName());
                this.updateLanguageFile(language, languageFile, fileType);
            }
        }
    }

    private void updateLanguageFile(String language, File languageFile, LanguageFileType fileType) {
        try {
            Version pluginVersion;
            if (!languageFile.getParentFile().exists()) {
                languageFile.getParentFile().mkdirs();
            }
            if (!languageFile.exists()) {
                this.createDefaultLanguageFileWithHeader(language, languageFile, fileType);
                this.plugin.getLogger().info("Created new " + fileType.getFileName() + " for " + language);
                return;
            }
            YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)languageFile);
            String configVersionStr = currentConfig.getString(LANGUAGE_VERSION_KEY, "0.0.0");
            Version configVersion = new Version(configVersionStr);
            if (configVersion.compareTo(pluginVersion = new Version(this.currentVersion)) >= 0) {
                return;
            }
            if (!configVersionStr.equals("0.0.0")) {
                this.plugin.debug("Updating " + language + " " + fileType.getFileName() + " from version " + configVersionStr + " to " + this.currentVersion);
            }
            Map<String, Object> userValues = this.flattenConfig((ConfigurationSection)currentConfig);
            File tempFile = new File(this.plugin.getDataFolder(), "language/" + language + "/" + fileType.getFileName().replace(".yml", "_new.yml"));
            this.createDefaultLanguageFileWithHeader(language, tempFile, fileType);
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)tempFile);
            newConfig.set(LANGUAGE_VERSION_KEY, (Object)this.currentVersion);
            boolean configDiffers = this.hasConfigDifferences(userValues, (FileConfiguration)newConfig);
            if (configDiffers) {
                File backupFile = new File(this.plugin.getDataFolder(), "language/" + language + "/" + fileType.getFileName().replace(".yml", "_backup_" + configVersionStr + ".yml"));
                Files.copy(languageFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.debug(language + " " + fileType.getFileName() + " backup created at " + backupFile.getName());
            } else if (!configVersionStr.equals("0.0.0")) {
                this.plugin.debug("No significant changes detected in " + language + " " + fileType.getFileName() + ", skipping backup creation");
            }
            this.applyUserValues((FileConfiguration)newConfig, userValues);
            newConfig.save(languageFile);
            tempFile.delete();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to update " + language + " " + fileType.getFileName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createDefaultLanguageFileWithHeader(String language, File destinationFile, LanguageFileType fileType) {
        try (InputStream in = this.plugin.getResource("language/" + language + "/" + fileType.getFileName());){
            if (in != null) {
                List<String> defaultLines = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().toList();
                ArrayList<Object> newLines = new ArrayList<Object>();
                newLines.add("# Language file version - Do not modify this value");
                newLines.add("language_version: " + this.currentVersion);
                newLines.add("");
                newLines.addAll(defaultLines);
                destinationFile.getParentFile().mkdirs();
                Files.write(destinationFile.toPath(), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
            } else {
                this.plugin.getLogger().warning("Default " + fileType.getFileName() + " for " + language + " not found in the plugin's resources.");
                destinationFile.getParentFile().mkdirs();
                YamlConfiguration emptyConfig = new YamlConfiguration();
                emptyConfig.set(LANGUAGE_VERSION_KEY, (Object)this.currentVersion);
                emptyConfig.set("_note", (Object)("This is an empty " + fileType.getFileName() + " created because no default was found in the plugin resources."));
                emptyConfig.save(destinationFile);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create default language file " + fileType.getFileName() + " for " + language + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean hasConfigDifferences(Map<String, Object> userValues, FileConfiguration newConfig) {
        Map<String, Object> newConfigMap = this.flattenConfig((ConfigurationSection)newConfig);
        for (Map.Entry<String, Object> entry : userValues.entrySet()) {
            String path = entry.getKey();
            Object oldValue = entry.getValue();
            if (path.equals(LANGUAGE_VERSION_KEY)) continue;
            if (!newConfig.contains(path)) {
                return true;
            }
            Object newDefaultValue = newConfig.get(path);
            if (newDefaultValue == null || newDefaultValue.equals(oldValue)) continue;
            return true;
        }
        for (String path : newConfigMap.keySet()) {
            if (path.equals(LANGUAGE_VERSION_KEY) || userValues.containsKey(path)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> flattenConfig(ConfigurationSection config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : config.getKeys(true)) {
            if (config.isConfigurationSection(key)) continue;
            result.put(key, config.get(key));
        }
        return result;
    }

    private void applyUserValues(FileConfiguration newConfig, Map<String, Object> userValues) {
        for (Map.Entry<String, Object> entry : userValues.entrySet()) {
            String path = entry.getKey();
            Object value = entry.getValue();
            if (path.equals(LANGUAGE_VERSION_KEY)) continue;
            if (newConfig.contains(path)) {
                newConfig.set(path, value);
                continue;
            }
            this.plugin.getLogger().fine("Config path '" + path + "' from old config no longer exists in new config");
        }
    }

    public static enum LanguageFileType {
        MESSAGES("messages.yml"),
        GUI("gui.yml"),
        FORMATTING("formatting.yml"),
        ITEMS("items.yml");

        private final String fileName;

        private LanguageFileType(String fileName) {
            this.fileName = fileName;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }
    }
}

