package me.basiqueevangelist.multicam.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import me.basiqueevangelist.multicam.mixin.client.KeyBindingAccessor;
import me.basiqueevangelist.windowapi.WindowIcon;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.NativeResource;

import java.util.ArrayList;
import java.util.List;

public class CameraWindow extends OwoWindow<FlowLayout> {
    public final WorldViewComponent worldView = new WorldViewComponent();

    public static final List<CameraWindow> CAMERAS = new ArrayList<>();

    public static float PREV_FRAME_DURATION = 0;

    private NativeResource focusCb;
    private final int cameraIndex;

    private long prevDrawNanos = 0;
    private long prevFrameDurationNanos = 0;

    private @Nullable class_243 orbitPoint = null;
    private float orbitY = 0;
    private float orbitRadius = 0;
    private float orbitPeriod = 0;
    private float orbitAngle = 0;

    public CameraWindow() {
        size(640, 480);

        int i = 0;
        boolean found = false;
        for (i = 0; i < CAMERAS.size(); i++) {
            if (CAMERAS.get(i) == null) {
                found = true;
                CAMERAS.set(i, this);
                break;
            }
        }

        if (!found) {
            CAMERAS.add(this);
        }

        this.cameraIndex = i;

        title("Camera #" + (i + 1));

        icon(WindowIcon.fromResources(class_2960.method_60655("multicam", "icon.png")));
    }

    @Override
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.createWithoutScreen(0, 0, scaledWidth(), scaledHeight(), Containers::verticalFlow);
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        rootComponent.child(worldView
            .sizing(Sizing.fill(100), Sizing.fill(100)));

        rootComponent.mouseUp().subscribe((mouseX, mouseY, button) -> {
            if (!cursorLocked()) {
                lockCursor();

                orbitPoint = null;
            }

            return true;
        });

        rootComponent.keyPress().subscribe((keyCode, scanCode, modifiers) -> {
            if (keyCode == GLFW.GLFW_KEY_ESCAPE && cursorLocked()) {
                unlockCursor();
            }

            return true;
        });

        rootComponent.mouseScroll().subscribe((mouseX, mouseY, amount) -> {
            worldView.fov(worldView.fov() + -(float)amount * 5);
            return true;
        });

        focusCb = GLFW.glfwSetWindowFocusCallback(handle(), (window, focused) -> {
            if (!focused) {
                unlockCursor();
            }
        });
    }

    @Override
    public void lockedMouseMoved(double xDelta, double yDelta) {
        worldView.yaw((float) (worldView.yaw() + xDelta*0.3f));
        worldView.pitch(class_3532.method_15363((float) (worldView.pitch() + yDelta*0.3f), -90.0F, 90.0F));
    }

    private boolean hasKeyDown(class_304 key) {
        return class_3675.method_15987(handle(), ((KeyBindingAccessor) key).getBoundKey().method_1444());
    }

    @Override
    public void draw() {
        float prevFrameDuration = class_310.method_1551().method_60646().method_60636();

        if (cursorLocked()) {
            float multiplier = 1;

            if (hasKeyDown(class_310.method_1551().field_1690.field_1867)) {
                multiplier = 2;
            }

            if (hasKeyDown(class_310.method_1551().field_1690.field_1894)) {
                worldView.moveBy(multiplier * 0.5f * prevFrameDuration, 0, 0, true);
            }

            if (hasKeyDown(class_310.method_1551().field_1690.field_1881)) {
                worldView.moveBy(multiplier * -0.5f * prevFrameDuration, 0, 0, true);
            }

            if (hasKeyDown(class_310.method_1551().field_1690.field_1913)) {
                worldView.moveBy(0, 0, multiplier * -0.5f * prevFrameDuration, true);
            }

            if (hasKeyDown(class_310.method_1551().field_1690.field_1849)) {
                worldView.moveBy(0, 0, multiplier * 0.5f * prevFrameDuration, true);
            }

            if (hasKeyDown(class_310.method_1551().field_1690.field_1903)) {
                worldView.moveBy(0, multiplier * 0.5f * prevFrameDuration, 0, false);
            }

            if (hasKeyDown(class_310.method_1551().field_1690.field_1832)) {
                worldView.moveBy(0, multiplier * -0.5f * prevFrameDuration, 0, false);
            }
        }

        if (orbitPoint != null) {
            orbitAngle += (float) (Math.PI * 2 * (prevFrameDuration / 20 / orbitPeriod));

            float x = (float) (orbitPoint.field_1352 + Math.cos(orbitAngle) * orbitRadius);
            float z = (float) (orbitPoint.field_1350 + Math.sin(orbitAngle) * orbitRadius);

            worldView.position(new class_243(x, orbitY, z));
            worldView.lookAt(orbitPoint);
        }

        if (prevDrawNanos + 1_000_000_000 / MultiCam.FPS_TARGET - prevFrameDurationNanos > System.nanoTime()) return;

        long start = System.nanoTime();
        super.draw();
        this.prevFrameDurationNanos = System.nanoTime() - start;

        prevDrawNanos = System.nanoTime();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        float prevFrameDuration = ((float) System.nanoTime() - prevDrawNanos) / 1_000_000_000f * 20;

        PREV_FRAME_DURATION = prevFrameDuration;
        RenderSystem.disableScissor();
        super.method_25394(context, mouseX, mouseY, prevFrameDuration);
        PREV_FRAME_DURATION = 0;
    }

    @Override
    public void close() {
        super.close();

        CAMERAS.set(cameraIndex, null);

        if (focusCb != null) {
            focusCb.close();
            focusCb = null;
        }
    }

    public void beginOrbit(class_243 pos, float period, float y, float radius) {
        this.orbitPoint = pos;
        this.orbitPeriod = period;
        this.orbitY = y;
        this.orbitRadius = radius;
        this.orbitAngle = 0;
    }
}
