package me.basiqueevangelist.multicam.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.jetbrains.annotations.Nullable;

public class DelegatingFramebuffer extends class_276 {
    private final class_276 original;
    private final LoadingCache<WorldViewComponent, class_276> subFramebuffers;
    private class_276 tracking;


    public DelegatingFramebuffer(class_276 tracking) {
        super(tracking.field_1478);

        switchTo(tracking);
        this.original = tracking;

        this.subFramebuffers = CacheBuilder.newBuilder()
            .<WorldViewComponent, class_276>removalListener(r -> {
                if (r.getValue() == null) return;

                r.getValue().method_1238();
            })
            .weakKeys()
            .build(CacheLoader.from(ctx -> {
                class_6367 sub = new class_6367(ctx.framebuffer.field_1482, ctx.framebuffer.field_1481, original.field_1478, class_310.field_1703);
                sub.method_1236(0.0F, 0.0F, 0.0F, 0.0F);

                ctx.whenResized((newWidth, newHeight) -> sub.method_1234(newWidth, newHeight, class_310.field_1703));

                return sub;
            }));
    }

    public void switchTo(@Nullable WorldViewComponent component) {
        if (component == null) {
            switchTo(this.original);
        } else {
            switchTo(subFramebuffers.getUnchecked(component));
        }
    }

    public void switchTo(class_276 tracking) {
        this.tracking = tracking;
        this.field_1476 = tracking.field_1476;
        this.field_1475 = tracking.method_30277();
        this.field_1474 = tracking.method_30278();
        this.field_1481 = tracking.field_1481;
        this.field_1482 = tracking.field_1482;
        this.field_1477 = tracking.field_1477;
        this.field_1480 = tracking.field_1480;
        this.field_1483 = tracking.field_1483;
    }

    @Override
    public void method_1234(int width, int height, boolean getError) {
        tracking.method_1234(width, height, getError);
    }

    @Override
    public void method_1238() {
        tracking.method_1238();
    }

    @Override
    public void method_29329(class_276 framebuffer) {
        tracking.method_29329(framebuffer);
    }

    @Override
    public void method_1231(int width, int height, boolean getError) {
        tracking.method_1231(width, height, getError);
    }

    @Override
    public void method_58226(int texFilter) {
        tracking.method_58226(texFilter);
    }

    @Override
    public void method_1239() {
        tracking.method_1239();
    }

    @Override
    public void method_35610() {
        tracking.method_35610();
    }

    @Override
    public void method_1242() {
        tracking.method_1242();
    }

    @Override
    public void method_1235(boolean setViewport) {
        tracking.method_1235(setViewport);
    }

    @Override
    public void method_1240() {
        tracking.method_1240();
    }

    @Override
    public void method_1236(float r, float g, float b, float a) {
        tracking.method_1236(r, g, b, a);
    }

    @Override
    public void method_1237(int width, int height) {
        tracking.method_1237(width, height);
    }

    @Override
    public void method_22594(int width, int height, boolean disableBlend) {
        tracking.method_22594(width, height, disableBlend);
    }

    @Override
    public void method_1230(boolean getError) {
        tracking.method_1230(getError);
    }

    @Override
    public int method_30277() {
        return tracking.method_30277();
    }

    @Override
    public int method_30278() {
        return tracking.method_30278();
    }
}
