package me.basiqueevangelist.multicam.client;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import io.wispforest.owo.shader.GlProgram;
import me.basiqueevangelist.multicam.client.command.ConfigCameraCommand;
import me.basiqueevangelist.multicam.client.command.MoveCameraCommand;
import me.basiqueevangelist.multicam.client.command.OrbitCameraCommand;
import me.basiqueevangelist.multicam.client.command.ZoomCameraCommand;
import me.basiqueevangelist.windowapi.OpenWindows;
import net.fabricmc.api.ClientModInitializer;

import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.argument;
import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public class MultiCam implements ClientModInitializer {
	public static final GlProgram WORLD_VIEW_PROGRAM = new GlProgram(class_2960.method_60655("multicam", "world_view"), class_290.field_1576);

	public static int FPS_TARGET = 60;

	@Override
	public void onInitializeClient() {
		ServerData.init();

		ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
			dispatcher.register(
				literal("multicam")
					.requires(x -> ServerData.canUse(x.method_9259(2)))
					.executes(context -> {
						new CameraWindow().open();
						return 1;
					})
					.then(literal("fps_target")
						.then(argument("target", IntegerArgumentType.integer(1))
							.executes(ctx -> {
								FPS_TARGET = IntegerArgumentType.getInteger(ctx, "target");
								return 0;
							})))
					.then(MoveCameraCommand.build())
					.then(ZoomCameraCommand.build())
					.then(OrbitCameraCommand.build())
					.then(ConfigCameraCommand.build())
			);
		});

		ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
			closeAllWindows();
		});
	}

	public static void closeAllWindows() {
		OpenWindows.windows().forEach(x -> {
			if (x instanceof CameraWindow) {
				class_310.method_1551().method_18858(x::close);
			}
		});
	}
}