package me.basiqueevangelist.multicam.client;

import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import me.basiqueevangelist.windowapi.AltWindow;
import net.minecraft.class_332;

public abstract class OwoWindow<R extends ParentComponent> extends AltWindow {
    protected OwoUIAdapter<R> uiAdapter = null;

    protected abstract OwoUIAdapter<R> createAdapter();

    protected abstract void build(R rootComponent);

    @Override
    protected void build() {
        this.uiAdapter = createAdapter();
        build(this.uiAdapter.rootComponent);
        this.uiAdapter.inflateAndMount();
    }

    @Override
    protected void resize(int newWidth, int newHeight) {
        uiAdapter.moveAndResize(0, 0, newWidth, newHeight);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        uiAdapter.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        this.uiAdapter.method_16014(mouseX, mouseY);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.uiAdapter.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.uiAdapter.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.uiAdapter.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.uiAdapter.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.uiAdapter.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.uiAdapter.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        return this.uiAdapter.method_25400(chr, modifiers);
    }

    @Override
    public void close() {
        this.uiAdapter.dispose();
        super.close();
    }

    @Override
    public void method_25365(boolean focused) {

    }

    @Override
    public boolean method_25370() {
        return false;
    }
}
