package me.basiqueevangelist.multicam.client;

import me.basiqueevangelist.multicam.mixin.client.PostEffectProcessorAccessor;
import me.basiqueevangelist.multicam.mixin.client.WorldRendererAccessor;
import net.minecraft.class_279;
import net.minecraft.class_283;
import net.minecraft.class_310;
import net.minecraft.class_757;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class ResizeHacks {
    private ResizeHacks() {

    }

    public static void resize(class_757 renderer, @Nullable WorldViewComponent ctx) {
        if (renderer.method_3183() != null) {
            resize(renderer.method_3183(), ctx);
        }

        resize(renderer.method_35772().field_1769, ctx);
    }

    public static void resize(class_761 renderer, @Nullable WorldViewComponent ctx) {
        // this.scheduleTerrainUpdate();

        var entityOutlineProcessor = ((WorldRendererAccessor) renderer).getEntityOutlinePostProcessor();
        if (entityOutlineProcessor != null) {
            resize(entityOutlineProcessor, ctx);
        }

        var transparencyProcessor = ((WorldRendererAccessor) renderer).getTransparencyPostProcessor();
        if (transparencyProcessor != null) {
            resize(transparencyProcessor, ctx);
        }
    }

    public static void resize(class_279 processor, @Nullable WorldViewComponent ctx) {
        PostEffectProcessorAccessor duck = (PostEffectProcessorAccessor) processor;

        duck.setWidth(width(ctx));
        duck.setHeight(height(ctx));

        var projectionMatrix = new Matrix4f()
            .setOrtho(
                0.0F,
                width(ctx),
                0.0F,
                height(ctx),
                0.1F,
                1000.0F
            );
        duck.setProjectionMatrix(projectionMatrix);

        if (duck.getMainTarget() instanceof DelegatingFramebuffer deleg)
            deleg.switchTo(ctx);

        for (class_283 pass : duck.getPasses()) {
            pass.method_1291(projectionMatrix);
        }

        for (var target : duck.getDefaultSizedTargets()) {
            if (target instanceof DelegatingFramebuffer deleg)
                deleg.switchTo(ctx);
        }
    }

    private static int width(@Nullable WorldViewComponent ctx) {
        return ctx == null ? class_310.method_1551().method_22683().method_4489() : ctx.framebuffer.field_1482;
    }

    private static int height(@Nullable WorldViewComponent ctx) {
        return ctx == null ? class_310.method_1551().method_22683().method_4506() : ctx.framebuffer.field_1481;
    }
}
