package me.basiqueevangelist.multicam.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import me.basiqueevangelist.windowapi.context.CurrentWindowContext;
import me.basiqueevangelist.windowapi.util.GlUtil;
import me.basiqueevangelist.multicam.mixin.client.CameraAccessor;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_6367;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import net.minecraft.client.render.*;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL32;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class WorldViewComponent extends BaseComponent {
    @ApiStatus.Internal
    public static class_276 CURRENT_BUFFER = null;

    @ApiStatus.Internal
    public static WorldViewComponent CURRENT = null;

    private final class_310 client = class_310.method_1551();
    class_276 framebuffer = null;
    private final List<BiConsumer<Integer, Integer>> resizeListeners = new ArrayList<>();

    public final AnimatableProperty<AnimatableVec3d> position = AnimatableProperty.of(new AnimatableVec3d(client.field_1773.method_19418().method_19326()));
    public final AnimatableProperty<AnimatableFloat> yaw = AnimatableProperty.of(new AnimatableFloat(client.field_1773.method_19418().method_19330()));
    public final AnimatableProperty<AnimatableFloat> pitch = AnimatableProperty.of(new AnimatableFloat(client.field_1773.method_19418().method_19329()));

    public final AnimatableProperty<AnimatableFloat> fov = AnimatableProperty.of(new AnimatableFloat(client.field_1690.method_41808().method_41753()));

    private boolean disableEntities = false;
    private boolean disableBlockEntities = false;
    private boolean disableParticles = false;

    public class_243 position() {
        return position.get().inner();
    }

    public float yaw() {
        return yaw.get().inner();
    }

    public float pitch() {
        return pitch.get().inner();
    }

    public float fov() {
        return fov.get().inner();
    }

    public boolean disableEntities() {
        return disableEntities;
    }

    public boolean disableBlockEntities() {
        return disableBlockEntities;
    }

    public boolean disableParticles() {
        return disableParticles;
    }

    public WorldViewComponent position(class_243 position) {
        this.position.set(new AnimatableVec3d(position));
        return this;
    }

    public WorldViewComponent yaw(float yaw) {
        this.yaw.set(new AnimatableFloat(yaw));
        return this;
    }

    public WorldViewComponent pitch(float pitch) {
        this.pitch.set(new AnimatableFloat(pitch));
        return this;
    }

    public WorldViewComponent fov(float fov) {
        this.fov.set(new AnimatableFloat(fov));
        return this;
    }

    public WorldViewComponent disableEntities(boolean disableEntities) {
        this.disableEntities = disableEntities;
        return this;
    }

    public WorldViewComponent disableBlockEntities(boolean disableBlockEntities) {
        this.disableBlockEntities = disableBlockEntities;
        return this;
    }

    public WorldViewComponent disableParticles(boolean disableParticles) {
        this.disableParticles = disableParticles;
        return this;
    }

    protected void moveBy(float f, float g, float h, boolean rotate) {
        Vector3f vector3f = new Vector3f(h, g, -f);

        if (rotate) {
            var rotation = new Quaternionf();
            rotation.rotationYXZ((float) Math.PI - yaw() * (float) (Math.PI / 180.0), -pitch() * (float) (Math.PI / 180.0), 0.0F);
            vector3f.rotate(rotation);
        }

        position(new class_243(position().field_1352 + vector3f.x, position().field_1351 + vector3f.y, position().field_1350 + vector3f.z));
    }

    public void lookAt(class_243 target) {
        class_243 rad = target.method_1020(position());

        yaw((float) (Math.atan2(rad.field_1350, rad.field_1352) * 180 / Math.PI - 90));
        pitch((float) (-Math.atan2(rad.field_1351, new class_243(rad.field_1352, 0, rad.field_1350).method_1033()) * 180 / Math.PI));

    }

    @Override
    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);

        this.position.update(delta);
        this.yaw.update(delta);
        this.pitch.update(delta);
        this.fov.update(delta);
    }

    @Override
    public void inflate(Size space) {
        if (this.framebuffer != null)
            this.framebuffer.method_1238();

        super.inflate(space);

        int realWidth = (int) (CurrentWindowContext.current().scaleFactor() * width);
        int realHeight = (int) (CurrentWindowContext.current().scaleFactor() * height);

        this.framebuffer = new class_6367(realWidth, realHeight, true, class_310.field_1703);
        resizeListeners.forEach(x -> x.accept(realWidth, realHeight));
        GlDebugUtils.labelObject(GL32.GL_FRAMEBUFFER, this.framebuffer.field_1476, "Framebuffer for " + this);
    }

    @Override
    public void dismount(DismountReason reason) {
        if (this.framebuffer != null)
            this.framebuffer.method_1238();
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        try (var ignored = GlDebugUtils.pushGroup("Drawing world into FB for " + this)) {
            int oldFb = GL32.glGetInteger(GL32.GL_DRAW_FRAMEBUFFER_BINDING);

            int viewportX = GlStateManager.class_1040.method_35330();
            int viewportY = GlStateManager.class_1040.method_35331();
            int viewportW = GlStateManager.class_1040.method_35332();
            int viewportH = GlStateManager.class_1040.method_35333();

            framebuffer.method_1235(true);

            CURRENT_BUFFER = framebuffer;
            CURRENT = this;
            ResizeHacks.resize(client.field_1773, this);

            GlStateManager._disableScissorTest();

            RenderSystem.getModelViewStack().pushMatrix();
            RenderSystem.getModelViewStack().identity();
            RenderSystem.applyModelViewMatrix();

            class_4184 camera = client.field_1773.method_19418();
            class_4587 matrixStack = new class_4587();
            matrixStack.method_34425(client.field_1773.method_22973(fov()));

            Matrix4f matrix4f = matrixStack.method_23760().method_23761();
            try (var ignored1 = GlUtil.setProjectionMatrix(matrix4f, class_8251.field_43360)) {
//                camera.update(
//                    this.client.world,
//                    (Entity)(this.client.getCameraEntity() == null ? this.client.player : this.client.getCameraEntity()),
//                    !this.client.options.getPerspective().isFirstPerson(),
//                    this.client.options.getPerspective().isFrontView(),
//                    partialTicks
//                );

                class_243 oldPos = camera.method_19326();
                float oldYaw = camera.method_19330();
                float oldPitch = camera.method_19329();
                ((CameraAccessor) camera).invokeSetPos(this.position());
                ((CameraAccessor) camera).invokeSetRotation(this.yaw(), this.pitch());

                class_4587 matrices = new class_4587();
                matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0F));

                Matrix4f cameraRotation = new Matrix4f().rotation(camera.method_23767().conjugate(new Quaternionf()));

//                Matrix3f matrix3f = new Matrix3f(matrices.peek().getNormalMatrix()).invert();
//                RenderSystem.setInverseViewRotationMatrix(matrix3f);
                this.client
                    .field_1769
                    .method_32133(camera.method_19326(), cameraRotation, client.field_1773.method_22973(fov()));
                client.field_1769.method_22710(client.method_60646(), false, camera, client.field_1773, client.field_1773.method_22974(), cameraRotation, client.field_1773.method_22973(fov()));
                ((CameraAccessor) camera).invokeSetPos(oldPos);
                ((CameraAccessor) camera).invokeSetRotation(oldYaw, oldPitch);
            }

            RenderSystem.getModelViewStack().popMatrix();
            RenderSystem.applyModelViewMatrix();
            GlStateManager._glBindFramebuffer(GL32.GL_DRAW_FRAMEBUFFER, oldFb);
            GlStateManager._viewport(viewportX, viewportY, viewportW, viewportH);
            GlStateManager._enableScissorTest();
            CURRENT_BUFFER = null;
            CURRENT = null;
            ResizeHacks.resize(client.field_1773, null);
        }

        MultiCam.WORLD_VIEW_PROGRAM.use();
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture(0, framebuffer.method_30277());
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, x, y, 0).method_22913(0, 1);
        bufferBuilder.method_22918(matrix4f, x, y + height, 0).method_22913(0, 0);
        bufferBuilder.method_22918(matrix4f, x + width, y + height, 0).method_22913(1, 0);
        bufferBuilder.method_22918(matrix4f, x + width, y, 0).method_22913(1, 1);
        class_286.method_43433(bufferBuilder.method_60800());
    }

    void whenResized(BiConsumer<Integer, Integer> onResized) {
        resizeListeners.add(onResized);
    }
}
