package me.basiqueevangelist.multicam.client.command;

import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Easing;
import me.basiqueevangelist.multicam.client.CameraWindow;
import me.basiqueevangelist.multicam.client.command.argument.MsTimeArgumentType;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.argument;
import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public class CommandUtil {
    // TODO: translate.
    public static final SimpleCommandExceptionType NO_SUCH_CAMERA = new SimpleCommandExceptionType(class_2561.method_43470("No such camera"));

    public static ArgumentBuilder<FabricClientCommandSource, ?> cameraNode() {
        return argument("camera", IntegerArgumentType.integer(1))
            .suggests((ctx, suggestionsBuilder) -> {
                for (int i = 0; i < CameraWindow.CAMERAS.size(); i++) {
                    if (CameraWindow.CAMERAS.get(i) != null) {
                        suggestionsBuilder.suggest(i + 1);
                    }
                }

                return suggestionsBuilder.buildFuture();
            });
    }

    public static CameraWindow getCamera(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        int cameraId = IntegerArgumentType.getInteger(ctx, "camera");

        cameraId -= 1;

        if (cameraId >= CameraWindow.CAMERAS.size()) throw NO_SUCH_CAMERA.create();

        CameraWindow camera = CameraWindow.CAMERAS.get(cameraId);

        if (camera == null) throw NO_SUCH_CAMERA.create();

        return camera;
    }

    public static void addInAt(ArgumentBuilder<FabricClientCommandSource, ?> builder, Function<AnimationConfigurer, ArgumentBuilder<FabricClientCommandSource, ?>> next) {
        // TODO: custom easings.
        builder
            .then(next.apply(new AnimationConfigurer() {
                @Override
                public <A extends Animatable<A>> void configureAnimation(CommandContext<FabricClientCommandSource> ctx, AnimatableProperty<A> property, A target, float distance) {
                    property.set(target);
                }
            }))
            .then(literal("in")
                .then(argument("duration", MsTimeArgumentType.time())
                    .then(next.apply(new AnimationConfigurer() {
                        @Override
                        public <A extends Animatable<A>> void configureAnimation(CommandContext<FabricClientCommandSource> ctx, AnimatableProperty<A> property, A target, float distance) {
                            property.animate(
                                IntegerArgumentType.getInteger(ctx, "duration"),
                                Easing.LINEAR,
                                target
                            )
                                .forwards();
                        }
                    }))))
            .then(literal("at")
                .then(argument("speed", FloatArgumentType.floatArg(0.1f))
                    .then(next.apply(new AnimationConfigurer() {
                        @Override
                        public <A extends Animatable<A>> void configureAnimation(CommandContext<FabricClientCommandSource> ctx, AnimatableProperty<A> property, A target, float distance) {
                            int duration = (int) ((distance / FloatArgumentType.getFloat(ctx, "speed")) * 1000);

                            property.animate(
                                duration,
                                Easing.LINEAR,
                                target
                            )
                                .forwards();
                        }
                    }))));
    }

    static FabricClientCommandSource getSourceForCamera(FabricClientCommandSource delegate, CameraWindow camera) {
        return new FabricClientCommandSource() {
            @Override
            public void sendFeedback(class_2561 text) {
                delegate.sendFeedback(text);
            }

            @Override
            public void sendError(class_2561 text) {
                delegate.sendError(text);
            }

            @Override
            public class_310 getClient() {
                return delegate.getClient();
            }

            @Override
            public class_746 getPlayer() {
                return delegate.getPlayer();
            }

            @Override
            public class_638 getWorld() {
                return delegate.getWorld();
            }

            @Override
            public Collection<String> method_9262() {
                return delegate.method_9262();
            }

            @Override
            public Collection<String> method_9267() {
                return delegate.method_9267();
            }

            @Override
            public Stream<class_2960> method_9254() {
                return delegate.method_9254();
            }

            @Override
            public Stream<class_2960> method_9273() {
                return delegate.method_9273();
            }

            @Override
            public CompletableFuture<Suggestions> method_9261(CommandContext<?> context) {
                return delegate.method_9261(context);
            }

            @Override
            public Set<class_5321<class_1937>> method_29310() {
                return delegate.method_29310();
            }

            @Override
            public class_5455 method_30497() {
                return delegate.method_30497();
            }

            @Override
            public class_7699 method_45549() {
                return delegate.method_45549();
            }

            @Override
            public CompletableFuture<Suggestions> method_41213(class_5321<? extends class_2378<?>> registryRef, class_7078 suggestedIdType, SuggestionsBuilder builder, CommandContext<?> context) {
                return delegate.method_41213(registryRef, suggestedIdType, builder, context);
            }

            @Override
            public boolean method_9259(int level) {
                return delegate.method_9259(level);
            }

            @Override
            public class_243 getPosition() {
                return camera.worldView.position();
            }

            @Override
            public class_241 getRotation() {
                return new class_241(camera.worldView.pitch(), camera.worldView.yaw());
            }
        };
    }

    public interface AnimationConfigurer {
        <A extends Animatable<A>> void configureAnimation(CommandContext<FabricClientCommandSource> ctx, AnimatableProperty<A> property, A target, float distance);
    }
}
