package me.basiqueevangelist.multicam.client.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2277;
import net.minecraft.class_2278;
import net.minecraft.class_241;
import net.minecraft.class_243;

public class ClientDefaultPosArgument implements ClientPosArgument {
    private final class_2278 x;
    private final class_2278 y;
    private final class_2278 z;

    public ClientDefaultPosArgument(class_2278 x, class_2278 y, class_2278 z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public class_243 toAbsolutePos(FabricClientCommandSource source) {
        class_243 vec3d = source.getPosition();
        return new class_243(this.x.method_9740(vec3d.field_1352), this.y.method_9740(vec3d.field_1351), this.z.method_9740(vec3d.field_1350));
    }

    @Override
    public class_241 toAbsoluteRotation(FabricClientCommandSource source) {
        class_241 vec2f = source.getRotation();
        return new class_241((float)this.x.method_9740(vec2f.field_1343), (float)this.y.method_9740(vec2f.field_1342));
    }

    @Override
    public boolean isXRelative() {
        return this.x.method_9741();
    }

    @Override
    public boolean isYRelative() {
        return this.y.method_9741();
    }

    @Override
    public boolean isZRelative() {
        return this.z.method_9741();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (!(o instanceof ClientDefaultPosArgument defaultPosArgument)) {
            return false;
        } else if (!this.x.equals(defaultPosArgument.x)) {
            return false;
        } else {
            return !this.y.equals(defaultPosArgument.y) ? false : this.z.equals(defaultPosArgument.z);
        }
    }

    public static ClientDefaultPosArgument parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        class_2278 coordinateArgument = class_2278.method_9739(reader);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            class_2278 coordinateArgument2 = class_2278.method_9739(reader);
            if (reader.canRead() && reader.peek() == ' ') {
                reader.skip();
                class_2278 coordinateArgument3 = class_2278.method_9739(reader);
                return new ClientDefaultPosArgument(coordinateArgument, coordinateArgument2, coordinateArgument3);
            } else {
                reader.setCursor(i);
                throw class_2277.field_10755.createWithContext(reader);
            }
        } else {
            reader.setCursor(i);
            throw class_2277.field_10755.createWithContext(reader);
        }
    }

    public static ClientDefaultPosArgument parse(StringReader reader, boolean centerIntegers) throws CommandSyntaxException {
        int i = reader.getCursor();
        class_2278 coordinateArgument = class_2278.method_9743(reader, centerIntegers);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            class_2278 coordinateArgument2 = class_2278.method_9743(reader, false);
            if (reader.canRead() && reader.peek() == ' ') {
                reader.skip();
                class_2278 coordinateArgument3 = class_2278.method_9743(reader, centerIntegers);
                return new ClientDefaultPosArgument(coordinateArgument, coordinateArgument2, coordinateArgument3);
            } else {
                reader.setCursor(i);
                throw class_2277.field_10755.createWithContext(reader);
            }
        } else {
            reader.setCursor(i);
            throw class_2277.field_10755.createWithContext(reader);
        }
    }

    public static ClientDefaultPosArgument absolute(double x, double y, double z) {
        return new ClientDefaultPosArgument(new class_2278(false, x), new class_2278(false, y), new class_2278(false, z));
    }

    public static ClientDefaultPosArgument absolute(class_241 vec) {
        return new ClientDefaultPosArgument(new class_2278(false, vec.field_1343), new class_2278(false, vec.field_1342), new class_2278(true, 0.0));
    }

    public static ClientDefaultPosArgument zero() {
        return new ClientDefaultPosArgument(new class_2278(true, 0.0), new class_2278(true, 0.0), new class_2278(true, 0.0));
    }

    public int hashCode() {
        int i = this.x.hashCode();
        i = 31 * i + this.y.hashCode();
        return 31 * i + this.z.hashCode();
    }
}
