package me.basiqueevangelist.multicam.client.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2183;
import net.minecraft.class_2277;
import net.minecraft.class_2278;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import java.util.Objects;

public class ClientLookingPosArgument implements ClientPosArgument {
    private final double x;
    private final double y;
    private final double z;

    public ClientLookingPosArgument(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public class_243 toAbsolutePos(FabricClientCommandSource source) {
        class_241 vec2f = source.getRotation();
        class_243 vec3d = class_2183.class_2184.field_9853.method_9302(source.getEntity());
        float f = class_3532.method_15362((vec2f.field_1342 + 90.0F) * (float) (Math.PI / 180.0));
        float g = class_3532.method_15374((vec2f.field_1342 + 90.0F) * (float) (Math.PI / 180.0));
        float h = class_3532.method_15362(-vec2f.field_1343 * (float) (Math.PI / 180.0));
        float i = class_3532.method_15374(-vec2f.field_1343 * (float) (Math.PI / 180.0));
        float j = class_3532.method_15362((-vec2f.field_1343 + 90.0F) * (float) (Math.PI / 180.0));
        float k = class_3532.method_15374((-vec2f.field_1343 + 90.0F) * (float) (Math.PI / 180.0));
        class_243 vec3d2 = new class_243(f * h, i, g * h);
        class_243 vec3d3 = new class_243(f * j, k, g * j);
        class_243 vec3d4 = vec3d2.method_1036(vec3d3).method_1021(-1.0);
        double d = vec3d2.field_1352 * this.z + vec3d3.field_1352 * this.y + vec3d4.field_1352 * this.x;
        double e = vec3d2.field_1351 * this.z + vec3d3.field_1351 * this.y + vec3d4.field_1351 * this.x;
        double l = vec3d2.field_1350 * this.z + vec3d3.field_1350 * this.y + vec3d4.field_1350 * this.x;
        return new class_243(vec3d.field_1352 + d, vec3d.field_1351 + e, vec3d.field_1350 + l);
    }

    @Override
    public class_241 toAbsoluteRotation(FabricClientCommandSource source) {
        return class_241.field_1340;
    }

    @Override
    public boolean isXRelative() {
        return true;
    }

    @Override
    public boolean isYRelative() {
        return true;
    }

    @Override
    public boolean isZRelative() {
        return true;
    }

    public static ClientLookingPosArgument parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        double d = readCoordinate(reader, i);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            double e = readCoordinate(reader, i);
            if (reader.canRead() && reader.peek() == ' ') {
                reader.skip();
                double f = readCoordinate(reader, i);
                return new ClientLookingPosArgument(d, e, f);
            } else {
                reader.setCursor(i);
                throw class_2277.field_10755.createWithContext(reader);
            }
        } else {
            reader.setCursor(i);
            throw class_2277.field_10755.createWithContext(reader);
        }
    }

    private static double readCoordinate(StringReader reader, int startingCursorPos) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw class_2278.field_10759.createWithContext(reader);
        } else if (reader.peek() != '^') {
            reader.setCursor(startingCursorPos);
            throw class_2277.field_10757.createWithContext(reader);
        } else {
            reader.skip();
            return reader.canRead() && reader.peek() != ' ' ? reader.readDouble() : 0.0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else {
            return !(o instanceof ClientLookingPosArgument lookingPosArgument)
                ? false
                : this.x == lookingPosArgument.x && this.y == lookingPosArgument.y && this.z == lookingPosArgument.z;
        }
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }
}
