package me.basiqueevangelist.multicam.client.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_243;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;

public class ClientVec3ArgumentType implements ArgumentType<ClientPosArgument> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0 0", "~ ~ ~", "^ ^ ^", "^1 ^ ^-5", "0.1 -0.5 .9", "~0.5 ~1 ~-5");
    private final boolean centerIntegers;

    public ClientVec3ArgumentType(boolean centerIntegers) {
        this.centerIntegers = centerIntegers;
    }

    public static ClientVec3ArgumentType vec3() {
        return new ClientVec3ArgumentType(true);
    }

    public static ClientVec3ArgumentType vec3(boolean centerIntegers) {
        return new ClientVec3ArgumentType(centerIntegers);
    }

    public static class_243 getVec3(CommandContext<FabricClientCommandSource> context, String name) {
        return context.getArgument(name, ClientPosArgument.class).toAbsolutePos(context.getSource());
    }

    public static ClientPosArgument getPosArgument(CommandContext<FabricClientCommandSource> context, String name) {
        return context.getArgument(name, ClientPosArgument.class);
    }

    public ClientPosArgument parse(StringReader stringReader) throws CommandSyntaxException {
        return stringReader.canRead() && stringReader.peek() == '^'
            ? ClientLookingPosArgument.parse(stringReader)
            : ClientDefaultPosArgument.parse(stringReader, this.centerIntegers);
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!(context.getSource() instanceof class_2172)) {
            return Suggestions.empty();
        } else {
            String string = builder.getRemaining();
            Collection<class_2172.class_2173> collection;
            if (!string.isEmpty() && string.charAt(0) == '^') {
                collection = Collections.singleton(class_2172.class_2173.field_9834);
            } else {
                collection = ((class_2172)context.getSource()).method_17772();
            }

            return class_2172.method_9260(string, collection, builder, class_2170.method_9238(this::parse));
        }
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

