package me.basiqueevangelist.multicam.mixin.client;

import io.wispforest.owo.ui.util.ScissorStack;
import me.basiqueevangelist.windowapi.context.CurrentWindowContext;
import net.minecraft.class_1041;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(ScissorStack.class)
public class OwoScissorStackMixin {
    @Redirect(method = {"pushDirect", "applyState"}, at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/Window;getScaleFactor()D"))
    private static double getScaleFactor(class_1041 instance) {
        return CurrentWindowContext.current().scaleFactor();
    }

    @Redirect(method = "pushDirect", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/Window;getScaledHeight()I"))
    private static int getScaleHeight(class_1041 instance) {
        return CurrentWindowContext.current().scaledHeight();
    }

    @Redirect(method = "applyState", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/Window;getFramebufferWidth()I"))
    private static int getFramebufferWidth(class_1041 instance) {
        return CurrentWindowContext.current().framebufferWidth();
    }

    @Redirect(method = "applyState", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/Window;getFramebufferHeight()I"))
    private static int getFramebufferHeight(class_1041 instance) {
        return CurrentWindowContext.current().framebufferHeight();
    }
}
