package me.basiqueevangelist.windowapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public interface WindowIcon {
    static WindowIcon fromResources(class_2960... iconIds) {
        return fromResources(List.of(iconIds));
    }

    static WindowIcon fromResources(List<class_2960> iconIds) {
        return new WindowIcon() {
            @Override
            public List<class_1011> listIconImages() {
                List<class_1011> iconImages = new ArrayList<>(iconIds.size());

                for (class_2960 iconId : iconIds) {
                    var icon = class_310.method_1551().method_1478().method_14486(iconId).orElse(null);

                    if (icon == null) continue;

                    try {
                        iconImages.add(class_1011.method_4309(icon.method_14482()));
                    } catch (IOException e) {
                        throw new RuntimeException("Couldn't open icon " + iconId, e);
                    }
                }

                return iconImages;
            }

            @Override
            public boolean closeAfterUse() {
                return true;
            }
        };
    }

    static WindowIcon fromNativeImages(List<class_1011> icons, boolean closeAfterUse) {
        return new WindowIcon() {
            @Override
            public List<class_1011> listIconImages() {
                return icons;
            }

            @Override
            public boolean closeAfterUse() {
                return closeAfterUse;
            }
        };
    }

    List<class_1011> listIconImages();

    boolean closeAfterUse();
}