package me.basiqueevangelist.windowapi.context;

import me.basiqueevangelist.windowapi.SupportsFeaturesImpl;
import me.basiqueevangelist.windowapi.WindowFramebufferResized;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;

import java.util.WeakHashMap;

public class VanillaWindowContext extends SupportsFeaturesImpl<WindowContext> implements WindowContext {
    private static final WeakHashMap<class_1041, VanillaWindowContext> MAP = new WeakHashMap<>();

    public static final VanillaWindowContext MAIN = new VanillaWindowContext(class_310.method_1551().method_22683(), class_310.method_1551().method_1522());

    private final class_1041 window;
    private final class_276 framebuffer;

    private final Event<WindowFramebufferResized> framebufferResizedEvents = WindowFramebufferResized.newEvent();

    private VanillaWindowContext(class_1041 window, class_276 framebuffer) {
        this.window = window;
        this.framebuffer = framebuffer;

        MAP.put(window, this);
    }

    @ApiStatus.Internal
    public static void onWindowResized(class_1041 window) {
        var ctx = MAP.get(window);
        if (ctx == null) return;
        ctx.framebufferResizedEvents.invoker().onFramebufferResized(window.method_4489(), window.method_4506());
    }

    @Override
    public int framebufferWidth() {
        return window.method_4489();
    }

    @Override
    public int framebufferHeight() {
        return window.method_4506();
    }

    @Override
    public Event<WindowFramebufferResized> framebufferResized() {
        return framebufferResizedEvents;
    }

    @Override
    public class_276 framebuffer() {
        return framebuffer;
    }

    @Override
    public int scaledWidth() {
        return window.method_4486();
    }

    @Override
    public int scaledHeight() {
        return window.method_4502();
    }

    @Override
    public double scaleFactor() {
        return window.method_4495();
    }

    @Override
    public long handle() {
        return window.method_4490();
    }

    @Override
    public String toString() {
        return "VanillaWindowContext[" + (this == MAIN ? "MAIN" : window) + "]";
    }
}
