/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class PaintingButton
extends Button {
    private static final int BORDER = 3;
    private static final int YELLOW = -256;
    private int animationY;
    private final ResourceLocation resLoc;
    public final PaintingVariant painting;

    public PaintingButton(int x, int y, int w, int h, Component text, Button.OnPress onPress, PaintingVariant painting) {
        super(x, y, w, h, text, onPress, Button.DEFAULT_NARRATION);
        this.resLoc = ResourceLocation.fromNamespaceAndPath((String)painting.assetId().getNamespace(), (String)("textures/painting/" + painting.assetId().getPath() + ".png"));
        this.painting = painting;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.blit(this.resLoc, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (this.isHovered) {
            guiGraphics.fill(this.getX() - 3, this.getY() - 3, this.getX() + this.width + 3, this.getY(), -256);
            guiGraphics.fill(this.getX() - 3, this.getY() + this.height, this.getX() + this.width + 3, this.getY() + this.height + 3, -256);
            guiGraphics.fill(this.getX() - 3, this.getY(), this.getX(), this.getY() + this.height, -256);
            guiGraphics.fill(this.getX() + this.width, this.getY(), this.getX() + this.width + 3, this.getY() + this.height, -256);
        }
    }

    public void shiftY(int dy) {
        this.setY(this.getY() + dy);
    }

    public void shiftX(int dx) {
        this.setX(this.getX() + dx);
    }
}

