/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.network;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import subaraki.paintings.gui.PaintingScreen;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.network.ProcessClientPacket;
import subaraki.paintings.network.ProcessServerPacket;
import subaraki.paintings.network.client.CPacketPaintingScreen;
import subaraki.paintings.network.client.CPacketPaintingUpdate;
import subaraki.paintings.network.server.SPacketPainting;

@EventBusSubscriber(modid="paintings", bus=EventBusSubscriber.Bus.MOD)
public class NetworkRegistry {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar NETWORK = event.registrar("1");
        NETWORK.playToClient(NetworkHandler.CPACKETSCREEN_TYPE, NetworkHandler.CPACKETSCREEN_CODEC, PayloadHandler::handleCPacketScreen);
        NETWORK.playToClient(NetworkHandler.CPACKETSYNC_TYPE, NetworkHandler.CPACKETSYNC_CODEC, PayloadHandler::handleCPacketSync);
        NETWORK.playToServer(NetworkHandler.SPACKETPAINTING_TYPE, NetworkHandler.SPACKETPAINTING_CODEC, PayloadHandler::handleSPacketUpdate);
    }

    private static class PayloadHandler {
        private PayloadHandler() {
        }

        private static void handleCPacketScreen(CPacketPaintingScreen packet, IPayloadContext context) {
            context.enqueueWork(() -> ProcessClientPacket.openScreen(packet.pos(), packet.direction(), packet.paintings(), PaintingScreen::new));
        }

        private static void handleSPacketUpdate(SPacketPainting packet, IPayloadContext context) {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Level level = serverPlayer.level();
                context.enqueueWork(() -> ProcessServerPacket.handle(level, serverPlayer, packet.pos(), packet.direction(), packet.painting(), (painting, player) -> PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (CustomPacketPayload)new CPacketPaintingUpdate(packet.painting(), painting.getId()), (CustomPacketPayload[])new CustomPacketPayload[0])));
            }
        }

        private static void handleCPacketSync(CPacketPaintingUpdate packet, IPayloadContext context) {
            context.enqueueWork(() -> ProcessClientPacket.updatePainting(packet.entityId(), packet.painting()));
        }
    }
}

