/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.network;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.Level;
import subaraki.paintings.Paintings;
import subaraki.paintings.network.supplier.SyncpacketSupplier;

public class ProcessServerPacket {
    public static void handle(Level level, ServerPlayer player, BlockPos pos, Direction direction, PaintingVariant painting, SyncpacketSupplier packet) {
        BlockPos actualPos = pos.relative(direction);
        level.registryAccess().registry(Registries.PAINTING_VARIANT).ifPresent(registry -> registry.getHolder(ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)painting.assetId())).ifPresent(holder -> {
            Painting entity = new Painting(level, actualPos, direction, (Holder)holder);
            entity.setYRot(direction.toYRot());
            entity.setPos((double)actualPos.getX(), (double)pos.getY(), (double)actualPos.getZ());
            Paintings.UTILITY.updatePaintingBoundingBox((HangingEntity)entity);
            level.addFreshEntity((Entity)entity);
            if (!player.isCreative()) {
                player.getItemInHand(player.getUsedItemHand()).shrink(1);
            }
            packet.send(entity, player);
        }));
    }
}

