/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1041;
import net.minecraft.class_11909;
import net.minecraft.class_1535;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import subaraki.paintings.Paintings;
import subaraki.paintings.gui.IPaintingGUI;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.mixin.ScreenAccessor;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.network.server.SPacketPainting;
import subaraki.paintings.utils.Services;

public class PaintingScreen
extends class_437
implements IPaintingGUI {
    public static final int START_X = 10;
    public static final int START_Y = 30;
    public static final int GAP = 5;
    private final class_2338 pos;
    private final class_2350 face;
    private final List<class_1535> types;
    private int scrollBarScroll = 0;

    public PaintingScreen(List<class_1535> types, class_2338 pos, class_2350 face) {
        super((class_2561)class_2561.method_43471((String)"select.a.painting"));
        this.types = types;
        this.pos = pos;
        this.face = face;
    }

    protected void method_25426() {
        super.method_25426();
        this.addButtons();
        this.scrollBarScroll = 0;
    }

    private void addButtons() {
        int END_X = this.field_22789 - 30;
        int prevHeight = this.types.getFirst().comp_2671() * 16;
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (class_1535 variant : this.types) {
            int width = variant.comp_2670() * 16;
            int height = variant.comp_2671() * 16;
            if (posx + width > END_X || prevHeight > height) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = height;
            }
            try {
                this.method_37063((class_364)new PaintingButton(posx, posy, width, height, (class_2561)class_2561.method_43470((String)""), button -> {
                    this.sendPacket(variant, this.pos, this.face);
                    this.method_25432();
                    this.method_25419();
                }, variant));
            }
            catch (NullPointerException e) {
                Paintings.LOGGER.warn("*******************");
                Paintings.LOGGER.warn(e.getMessage());
                Paintings.LOGGER.warn("*******************");
            }
            posx += 5 + width;
            ++index;
        }
        this.centerRow(rowstart, this.getRenderablesWithCast().size() - 1);
    }

    private void centerRow(int start, int end) {
        if (this.optionalAbstractWidget(start).isPresent() && this.optionalAbstractWidget(end).isPresent()) {
            int left = this.optionalAbstractWidget(start).get().method_46426();
            int right = this.optionalAbstractWidget(end).get().method_46426() + this.optionalAbstractWidget(end).get().method_25368();
            int correction = (this.field_22789 - 20 - (right - left)) / 2;
            for (int i = start; i <= end; ++i) {
                this.optionalAbstractWidget(i).ifPresent(widget -> {
                    if (widget instanceof PaintingButton) {
                        PaintingButton painting = (PaintingButton)((Object)widget);
                        painting.shiftX(correction);
                    }
                });
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float f) {
        guiGraphics.method_25294(10, 30, this.field_22789 - 10, this.field_22790 - 30, 0x44444444);
        class_1041 window = this.field_22787.method_22683();
        int scale = window.method_4495();
        guiGraphics.method_44379(10, 30, this.field_22789, this.field_22790 - 30);
        super.method_25394(guiGraphics, mouseX, mouseY, f);
        guiGraphics.method_44380();
        if (!this.getRenderablesWithCast().isEmpty()) {
            this.drawFakeScrollBar(guiGraphics);
        }
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        this.drawToolTips(guiGraphics, mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalScroll, double verticalScroll) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int move = (verticalScroll < 0.0 ? -1 : (verticalScroll > 0.0 ? 1 : 0)) * 16;
            this.movePaintingWidgets(move);
        }
        return super.method_25401(mouseX, mouseY, horizontalScroll, verticalScroll);
    }

    public boolean method_25403(class_11909 event, double mouseX, double mouseY) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            float move = (float)event.comp_4799() * -1.0f;
            int paintingCanvasTopY = this.optionalFirstWidget().get().method_46427();
            int paintingCanvasBotY = this.optionalLastWidget().get().method_46427() + this.optionalLastWidget().get().method_25364();
            int paintingContainerSize = paintingCanvasBotY - paintingCanvasTopY;
            int viewport = this.field_22790 - 30;
            float portToCanvasScale = (float)viewport / (float)paintingContainerSize;
            float barsize = (float)viewport * portToCanvasScale;
            float scaledViewport = (float)viewport - barsize;
            float usableSpaceScale = (float)paintingContainerSize / scaledViewport;
            float scaledDrageMove = move * usableSpaceScale;
            this.movePaintingWidgets((int)scaledDrageMove);
        }
        return super.method_25403(event, mouseX, mouseY);
    }

    private void movePaintingWidgets(int scrollAmount) {
        int paintingCanvasTopY = this.optionalFirstWidget().get().method_46427();
        int onScreenTopLimit = 35;
        int paintingCanvasBotY = this.optionalLastWidget().get().method_46427() + this.optionalLastWidget().get().method_25364();
        int onScreenBottomLimit = this.field_22790 - onScreenTopLimit;
        if (scrollAmount > 0 && paintingCanvasTopY < onScreenTopLimit || scrollAmount < 0 && paintingCanvasBotY >= onScreenBottomLimit) {
            this.getRenderablesWithCast().forEach(widget -> ((class_339)widget).method_46419(((class_339)widget).method_46427() + scrollAmount));
            this.scrollBarScroll -= scrollAmount;
        }
    }

    private void drawToolTips(class_332 guiGraphics, int mouseX, int mouseY) {
        if (!Services.CONFIG.showPaintingSize()) {
            return;
        }
        for (class_4068 guiButton : this.getRenderablesWithCast()) {
            class_1535 variant;
            PaintingButton button;
            if (!(guiButton instanceof PaintingButton) || !(button = (PaintingButton)guiButton).method_25405(mouseX, mouseY) || (variant = button.painting) == null) continue;
            class_2561 author = variant.comp_2919().orElseGet(class_2561::method_43473);
            class_2561 title = variant.comp_2918().orElseGet(class_2561::method_43473);
            ArrayList<class_5684> list = new ArrayList<class_5684>();
            list.add(class_5684.method_32662((class_5481)title.method_30937()));
            list.add(class_5684.method_32662((class_5481)class_2561.method_43470((String)(variant.comp_2670() + "x" + variant.comp_2671())).method_30937()));
            list.add(class_5684.method_32662((class_5481)author.method_30937()));
            guiGraphics.method_51435(this.field_22793, list, mouseX, mouseY, class_8001.field_41687, null);
        }
    }

    private void drawFakeScrollBar(class_332 guiGraphics) {
        if (this.getRenderablesWithCast().isEmpty()) {
            return;
        }
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int top = this.optionalFirstWidget().get().method_46427();
            int containerSize = this.field_22790 - 60;
            int bot = this.optionalLastWidget().get().method_46427() + this.optionalLastWidget().get().method_25364();
            int totalSize = bot - top;
            float percent = (float)containerSize / (float)totalSize * 100.0f;
            if ((double)percent < 100.0) {
                int sizeBar = (int)((float)containerSize / 100.0f * percent);
                int relativeScroll = (int)((float)this.scrollBarScroll / 100.0f * percent);
                guiGraphics.method_25296(this.field_22789 - 10, 30, this.field_22789, 30 + containerSize, Integer.MIN_VALUE, -2145246686);
                guiGraphics.method_25296(this.field_22789 - 10, 30 + relativeScroll, this.field_22789, 30 + relativeScroll + sizeBar, -2130706433, -2145246686);
            }
        }
    }

    private Optional<class_339> optionalFirstWidget() {
        return this.optionalAbstractWidget(0);
    }

    private Optional<class_339> optionalLastWidget() {
        return this.optionalAbstractWidget(this.getRenderablesWithCast().size() - 1);
    }

    @Override
    public Optional<class_339> optionalAbstractWidget(int index) {
        class_4068 renderable = this.getRenderablesWithCast().get(index);
        if (renderable instanceof class_339) {
            class_339 aw = (class_339)renderable;
            return Optional.of(aw);
        }
        return Optional.empty();
    }

    @Override
    public List<class_4068> getRenderablesWithCast() {
        return ((ScreenAccessor)((Object)this)).getRenderables();
    }

    @Override
    public void sendPacket(class_1535 variant, class_2338 pos, class_2350 face) {
        NetworkHandler.sendServerpacket.accept(new SPacketPainting(variant, pos, face));
    }
}

