/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import subaraki.paintings.Paintings;
import subaraki.paintings.mixin.IPaintingAccessor;
import subaraki.paintings.network.supplier.PlacementPacketSupplier;
import subaraki.paintings.utils.PaintingUtility;
import subaraki.paintings.utils.Services;

public class ProcessPlacementEvent {
    private static final List<ResourceKey<PaintingVariant>> vanillaPaintings = new ArrayList<ResourceKey<PaintingVariant>>();

    public static boolean processPlacementEvent(ItemStack itemStack, Player player, Direction face, BlockPos blockPos, Level level, PlacementPacketSupplier packetSupplier) {
        Optional registry = level.registryAccess().lookup(Registries.PAINTING_VARIANT);
        if (!Services.CONFIG.useSelectionGUI() || registry.isEmpty()) {
            return false;
        }
        Registry paintingRegistry = (Registry)registry.get();
        if (itemStack.getItem() == Items.PAINTING) {
            boolean dataflag = itemStack.getComponentsPatch().isEmpty();
            if (!dataflag) {
                return false;
            }
            BlockPos actualPos = blockPos.relative(face);
            boolean flag = face.getAxis().isHorizontal();
            if (flag && player.mayUseItemAt(actualPos, face, itemStack)) {
                Optional optPainting = Painting.create((Level)level, (BlockPos)actualPos, (Direction)face);
                optPainting.ifPresent(paintingEntity -> {
                    paintingEntity.setYRot(face.toYRot());
                    paintingEntity.setPos((double)actualPos.getX(), (double)blockPos.getY(), (double)actualPos.getZ());
                    if (paintingEntity.survives()) {
                        player.swing(InteractionHand.MAIN_HAND);
                        if (!level.isClientSide()) {
                            paintingEntity.playPlacementSound();
                            Holder originalArt = paintingEntity.getVariant();
                            List<ResourceLocation> validArts = paintingRegistry.keySet().stream().filter(resourceLocation -> {
                                PaintingVariant variant = (PaintingVariant)paintingRegistry.getValue(resourceLocation);
                                Optional optionalResourceKey = paintingRegistry.getResourceKey((Object)variant);
                                if (optionalResourceKey.isPresent()) {
                                    ((IPaintingAccessor)paintingEntity).callSetVariant((Holder<PaintingVariant>)paintingRegistry.wrapAsHolder((Object)variant));
                                    return paintingEntity.survives() && (!Services.CONFIG.useVanillaOnly() || vanillaPaintings.contains(optionalResourceKey.get()));
                                }
                                return false;
                            }).toList();
                            ((IPaintingAccessor)paintingEntity).callSetVariant((Holder<PaintingVariant>)originalArt);
                            Paintings.UTILITY.updatePaintingBoundingBox((HangingEntity)paintingEntity);
                            List<PaintingVariant> sorted = validArts.stream().map(arg_0 -> ((Registry)paintingRegistry).getValue(arg_0)).sorted(PaintingUtility.ART_COMPARATOR).toList();
                            packetSupplier.send((ServerPlayer)player, (Painting)paintingEntity, sorted);
                        }
                    }
                });
                return true;
            }
        }
        return false;
    }

    static {
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.KEBAB);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.AZTEC);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.ALBAN);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.AZTEC2);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.BOMB);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.PLANT);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.WASTELAND);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.POOL);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.COURBET);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.SEA);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.SUNSET);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.CREEBET);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.WANDERER);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.GRAHAM);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.MATCH);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.BUST);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.STAGE);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.VOID);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.SKULL_AND_ROSES);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.WITHER);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.FIGHTERS);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.POINTER);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.PIGSCENE);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.BURNING_SKULL);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.SKELETON);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.DONKEY_KONG);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.EARTH);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.WIND);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.FIRE);
        vanillaPaintings.add((ResourceKey<PaintingVariant>)PaintingVariants.WATER);
    }
}

