/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.decoration.PaintingVariant;
import subaraki.paintings.Paintings;
import subaraki.paintings.gui.IPaintingGUI;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.mixin.ScreenAccessor;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.network.server.SPacketPainting;
import subaraki.paintings.utils.Services;

public class PaintingScreen
extends Screen
implements IPaintingGUI {
    public static final int START_X = 10;
    public static final int START_Y = 30;
    public static final int GAP = 5;
    private final BlockPos pos;
    private final Direction face;
    private final List<PaintingVariant> types;
    private int scrollBarScroll = 0;

    public PaintingScreen(List<PaintingVariant> types, BlockPos pos, Direction face) {
        super((Component)Component.translatable((String)"select.a.painting"));
        this.types = types;
        this.pos = pos;
        this.face = face;
    }

    protected void init() {
        super.init();
        this.addButtons();
        this.scrollBarScroll = 0;
    }

    private void addButtons() {
        int END_X = this.width - 30;
        int prevHeight = this.types.getFirst().height() * 16;
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (PaintingVariant variant : this.types) {
            int width = variant.width() * 16;
            int height = variant.height() * 16;
            if (posx + width > END_X || prevHeight > height) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = height;
            }
            try {
                this.addRenderableWidget((GuiEventListener)new PaintingButton(posx, posy, width, height, (Component)Component.literal((String)""), button -> {
                    this.sendPacket(variant, this.pos, this.face);
                    this.removed();
                    this.onClose();
                }, variant));
            }
            catch (NullPointerException e) {
                Paintings.LOGGER.warn("*******************");
                Paintings.LOGGER.warn(e.getMessage());
                Paintings.LOGGER.warn("*******************");
            }
            posx += 5 + width;
            ++index;
        }
        this.centerRow(rowstart, this.getRenderablesWithCast().size() - 1);
    }

    private void centerRow(int start, int end) {
        if (this.optionalAbstractWidget(start).isPresent() && this.optionalAbstractWidget(end).isPresent()) {
            int left = this.optionalAbstractWidget(start).get().getX();
            int right = this.optionalAbstractWidget(end).get().getX() + this.optionalAbstractWidget(end).get().getWidth();
            int correction = (this.width - 20 - (right - left)) / 2;
            for (int i = start; i <= end; ++i) {
                this.optionalAbstractWidget(i).ifPresent(widget -> {
                    if (widget instanceof PaintingButton) {
                        PaintingButton painting = (PaintingButton)((Object)widget);
                        painting.shiftX(correction);
                    }
                });
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
        guiGraphics.fill(10, 30, this.width - 10, this.height - 30, 0x44444444);
        Window window = this.minecraft.getWindow();
        int scale = window.getGuiScale();
        guiGraphics.enableScissor(10, 30, this.width, this.height - 30);
        super.render(guiGraphics, mouseX, mouseY, f);
        guiGraphics.disableScissor();
        if (!this.getRenderablesWithCast().isEmpty()) {
            this.drawFakeScrollBar(guiGraphics);
        }
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        this.drawToolTips(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalScroll, double verticalScroll) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int move = (verticalScroll < 0.0 ? -1 : (verticalScroll > 0.0 ? 1 : 0)) * 16;
            this.movePaintingWidgets(move);
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalScroll, verticalScroll);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseX, double mouseY) {
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            float move = (float)event.y() * -1.0f;
            int paintingCanvasTopY = this.optionalFirstWidget().get().getY();
            int paintingCanvasBotY = this.optionalLastWidget().get().getY() + this.optionalLastWidget().get().getHeight();
            int paintingContainerSize = paintingCanvasBotY - paintingCanvasTopY;
            int viewport = this.height - 30;
            float portToCanvasScale = (float)viewport / (float)paintingContainerSize;
            float barsize = (float)viewport * portToCanvasScale;
            float scaledViewport = (float)viewport - barsize;
            float usableSpaceScale = (float)paintingContainerSize / scaledViewport;
            float scaledDrageMove = move * usableSpaceScale;
            this.movePaintingWidgets((int)scaledDrageMove);
        }
        return super.mouseDragged(event, mouseX, mouseY);
    }

    private void movePaintingWidgets(int scrollAmount) {
        int paintingCanvasTopY = this.optionalFirstWidget().get().getY();
        int onScreenTopLimit = 35;
        int paintingCanvasBotY = this.optionalLastWidget().get().getY() + this.optionalLastWidget().get().getHeight();
        int onScreenBottomLimit = this.height - onScreenTopLimit;
        if (scrollAmount > 0 && paintingCanvasTopY < onScreenTopLimit || scrollAmount < 0 && paintingCanvasBotY >= onScreenBottomLimit) {
            this.getRenderablesWithCast().forEach(widget -> ((AbstractWidget)widget).setY(((AbstractWidget)widget).getY() + scrollAmount));
            this.scrollBarScroll -= scrollAmount;
        }
    }

    private void drawToolTips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!Services.CONFIG.showPaintingSize()) {
            return;
        }
        for (Renderable guiButton : this.getRenderablesWithCast()) {
            PaintingVariant variant;
            PaintingButton button;
            if (!(guiButton instanceof PaintingButton) || !(button = (PaintingButton)guiButton).isMouseOver(mouseX, mouseY) || (variant = button.painting) == null) continue;
            Component author = variant.author().orElseGet(Component::empty);
            Component title = variant.title().orElseGet(Component::empty);
            ArrayList<ClientTooltipComponent> list = new ArrayList<ClientTooltipComponent>();
            list.add(ClientTooltipComponent.create((FormattedCharSequence)title.getVisualOrderText()));
            list.add(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)(variant.width() + "x" + variant.height())).getVisualOrderText()));
            list.add(ClientTooltipComponent.create((FormattedCharSequence)author.getVisualOrderText()));
            guiGraphics.renderTooltip(this.font, list, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
        }
    }

    private void drawFakeScrollBar(GuiGraphics guiGraphics) {
        if (this.getRenderablesWithCast().isEmpty()) {
            return;
        }
        if (this.optionalFirstWidget().isPresent() && this.optionalLastWidget().isPresent()) {
            int top = this.optionalFirstWidget().get().getY();
            int containerSize = this.height - 60;
            int bot = this.optionalLastWidget().get().getY() + this.optionalLastWidget().get().getHeight();
            int totalSize = bot - top;
            float percent = (float)containerSize / (float)totalSize * 100.0f;
            if ((double)percent < 100.0) {
                int sizeBar = (int)((float)containerSize / 100.0f * percent);
                int relativeScroll = (int)((float)this.scrollBarScroll / 100.0f * percent);
                guiGraphics.fillGradient(this.width - 10, 30, this.width, 30 + containerSize, Integer.MIN_VALUE, -2145246686);
                guiGraphics.fillGradient(this.width - 10, 30 + relativeScroll, this.width, 30 + relativeScroll + sizeBar, -2130706433, -2145246686);
            }
        }
    }

    private Optional<AbstractWidget> optionalFirstWidget() {
        return this.optionalAbstractWidget(0);
    }

    private Optional<AbstractWidget> optionalLastWidget() {
        return this.optionalAbstractWidget(this.getRenderablesWithCast().size() - 1);
    }

    @Override
    public Optional<AbstractWidget> optionalAbstractWidget(int index) {
        Renderable renderable = this.getRenderablesWithCast().get(index);
        if (renderable instanceof AbstractWidget) {
            AbstractWidget aw = (AbstractWidget)renderable;
            return Optional.of(aw);
        }
        return Optional.empty();
    }

    @Override
    public List<Renderable> getRenderablesWithCast() {
        return ((ScreenAccessor)((Object)this)).getRenderables();
    }

    @Override
    public void sendPacket(PaintingVariant variant, BlockPos pos, Direction face) {
        NetworkHandler.sendServerpacket.accept(new SPacketPainting(variant, pos, face));
    }
}

