/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.utils;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.phys.AABB;
import subaraki.paintings.utils.ArtComparator;

public class PaintingUtility {
    public static final ArtComparator ART_COMPARATOR = new ArtComparator();

    public void updatePaintingBoundingBox(HangingEntity painting) {
        double hangX = (double)painting.getPos().getX() + 0.5;
        double hangY = (double)painting.getPos().getY() + 0.5;
        double hangZ = (double)painting.getPos().getZ() + 0.5;
        double offsetWidth = painting.getBbWidth() % 32.0f == 0.0f ? 0.5 : 0.0;
        double offsetHeight = painting.getBbHeight() % 32.0f == 0.0f ? 0.5 : 0.0;
        hangX -= (double)painting.getDirection().getStepX() * 0.46875;
        hangZ -= (double)painting.getDirection().getStepZ() * 0.46875;
        Direction enumfacing = painting.getDirection().getCounterClockWise();
        painting.setPosRaw(hangX += offsetWidth * (double)enumfacing.getStepX(), hangY += offsetHeight, hangZ += offsetWidth * (double)enumfacing.getStepZ());
        double widthX = painting.getBbWidth();
        double height = painting.getBbHeight();
        double widthZ = painting.getBbWidth();
        if (painting.getDirection().getAxis() == Direction.Axis.Z) {
            widthZ = 1.0;
        } else {
            widthX = 1.0;
        }
        painting.setBoundingBox(new AABB(hangX - (widthX /= 32.0), hangY - (height /= 32.0), hangZ - (widthZ /= 32.0), hangX + widthX, hangY + height, hangZ + widthZ));
    }
}

