/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.compat_layer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import subaraki.paintings.compat_layer.IPackRepoDiscoveryService;

public class OpenLoaderCompat
implements IPackRepoDiscoveryService {
    private final Path configDir = Path.of(".", "config", "openloader");

    @Override
    public Collection<String> getPackRepos() {
        File configFile;
        HashSet<String> staticFolders = new HashSet<String>();
        boolean isOpenLoaderLoaded = false;
        try {
            Class.forName("net.darkhax.openloader.Constants");
            isOpenLoaderLoaded = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (isOpenLoaderLoaded && (configFile = this.configDir.resolve("advanced_options.json").toFile()).exists()) {
            try (FileReader reader = new FileReader(configFile);){
                JsonObject config = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (config.has("resourcePacks")) {
                    JsonObject packConfig = config.get("resourcePacks").getAsJsonObject();
                    if (packConfig.has("enabled") && packConfig.get("enabled").getAsBoolean()) {
                        staticFolders.add(this.configDir.resolve("resources").toFile().getPath());
                    }
                    if (packConfig.has("enabled") && packConfig.get("enabled").getAsBoolean() && packConfig.has("additionalFolders")) {
                        packConfig.get("additionalFolders").getAsJsonArray().forEach(elem -> staticFolders.add(elem.getAsString()));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return staticFolders;
    }
}

