/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.immersiveui;

import it.hurts.shatterbyte.shatterlib.module.config.annotation.Prop;
import it.hurts.shatterbyte.shatterlib.module.config.impl.ShatterConfig;
import lombok.Generated;

public class Config
implements ShatterConfig {
    @Prop(comment="Enables the hotbar selector animation.")
    private boolean enableHotbarSelectorAnimation = true;
    @Prop(comment="Enables floating item rotation.")
    private boolean enableFloatingItemRotation = true;
    @Prop(comment="Enables hovering of matching items.")
    private boolean enableMatchingItemHovering = true;
    @Prop(comment="Disables vanilla slot highlighting")
    private boolean disableVanillaSlotHighlighting = true;
    @Prop(comment="Enables particles for rare items.")
    private boolean enableRarityParticles = true;
    @Prop(comment="Affects the speed of the hotbar selector.")
    private double hotbarSelectorSpeed = 3.0;
    @Prop(comment="Affects the size of the hovered item.")
    private float hoveredItemScale = 1.4f;
    @Prop(comment="Affects the size of the floating item.")
    private float floatingItemScale = 1.4f;
    @Prop(comment="Affects the hover amplitude of items, that match to the item that is carried in the cursor.")
    private float matchingItemHoverAmplitude = 0.8f;
    @Prop(comment="Affects the easing speed, that is applied to the rotation of the floating item.")
    private float floatingItemEasingSpeed = 0.75f;
    @Prop(comment="Affects the rotation amplitude of the floating item.")
    private float floatingItemRotationAmplitude = 1.0f;
    @Prop(comment="Moves the hotbar selector above the items. You might want to disable this, if you use resource packs that change the default selector texture.")
    private boolean renderHotbarSelectorAboveItems = false;
    @Prop(comment="Enables screen shake.")
    private boolean enableScreenShake = true;
    @Prop(comment="Screen shake timer in ticks.")
    private int shakeTimer = 8;
    @Prop(comment="Screen shake amplitude.")
    private float shakeAmplitude = 1.25f;
    @Prop(comment="Enables particles in the enchant(ing/ment) table.")
    private boolean enableEnchantParticles = true;
    @Prop(comment="Enables special formatting for items with cursed enchantments.")
    private boolean enableCurseFormatting = true;
    @Prop(comment="Enables wobbly items in advancement toasts.")
    private boolean enableAdvancementToastItems = true;

    @Generated
    public Config() {
    }

    @Generated
    public boolean isEnableHotbarSelectorAnimation() {
        return this.enableHotbarSelectorAnimation;
    }

    @Generated
    public boolean isEnableFloatingItemRotation() {
        return this.enableFloatingItemRotation;
    }

    @Generated
    public boolean isEnableMatchingItemHovering() {
        return this.enableMatchingItemHovering;
    }

    @Generated
    public boolean isDisableVanillaSlotHighlighting() {
        return this.disableVanillaSlotHighlighting;
    }

    @Generated
    public boolean isEnableRarityParticles() {
        return this.enableRarityParticles;
    }

    @Generated
    public double getHotbarSelectorSpeed() {
        return this.hotbarSelectorSpeed;
    }

    @Generated
    public float getHoveredItemScale() {
        return this.hoveredItemScale;
    }

    @Generated
    public float getFloatingItemScale() {
        return this.floatingItemScale;
    }

    @Generated
    public float getMatchingItemHoverAmplitude() {
        return this.matchingItemHoverAmplitude;
    }

    @Generated
    public float getFloatingItemEasingSpeed() {
        return this.floatingItemEasingSpeed;
    }

    @Generated
    public float getFloatingItemRotationAmplitude() {
        return this.floatingItemRotationAmplitude;
    }

    @Generated
    public boolean isRenderHotbarSelectorAboveItems() {
        return this.renderHotbarSelectorAboveItems;
    }

    @Generated
    public boolean isEnableScreenShake() {
        return this.enableScreenShake;
    }

    @Generated
    public int getShakeTimer() {
        return this.shakeTimer;
    }

    @Generated
    public float getShakeAmplitude() {
        return this.shakeAmplitude;
    }

    @Generated
    public boolean isEnableEnchantParticles() {
        return this.enableEnchantParticles;
    }

    @Generated
    public boolean isEnableCurseFormatting() {
        return this.enableCurseFormatting;
    }

    @Generated
    public boolean isEnableAdvancementToastItems() {
        return this.enableAdvancementToastItems;
    }

    @Generated
    public void setEnableHotbarSelectorAnimation(boolean enableHotbarSelectorAnimation) {
        this.enableHotbarSelectorAnimation = enableHotbarSelectorAnimation;
    }

    @Generated
    public void setEnableFloatingItemRotation(boolean enableFloatingItemRotation) {
        this.enableFloatingItemRotation = enableFloatingItemRotation;
    }

    @Generated
    public void setEnableMatchingItemHovering(boolean enableMatchingItemHovering) {
        this.enableMatchingItemHovering = enableMatchingItemHovering;
    }

    @Generated
    public void setDisableVanillaSlotHighlighting(boolean disableVanillaSlotHighlighting) {
        this.disableVanillaSlotHighlighting = disableVanillaSlotHighlighting;
    }

    @Generated
    public void setEnableRarityParticles(boolean enableRarityParticles) {
        this.enableRarityParticles = enableRarityParticles;
    }

    @Generated
    public void setHotbarSelectorSpeed(double hotbarSelectorSpeed) {
        this.hotbarSelectorSpeed = hotbarSelectorSpeed;
    }

    @Generated
    public void setHoveredItemScale(float hoveredItemScale) {
        this.hoveredItemScale = hoveredItemScale;
    }

    @Generated
    public void setFloatingItemScale(float floatingItemScale) {
        this.floatingItemScale = floatingItemScale;
    }

    @Generated
    public void setMatchingItemHoverAmplitude(float matchingItemHoverAmplitude) {
        this.matchingItemHoverAmplitude = matchingItemHoverAmplitude;
    }

    @Generated
    public void setFloatingItemEasingSpeed(float floatingItemEasingSpeed) {
        this.floatingItemEasingSpeed = floatingItemEasingSpeed;
    }

    @Generated
    public void setFloatingItemRotationAmplitude(float floatingItemRotationAmplitude) {
        this.floatingItemRotationAmplitude = floatingItemRotationAmplitude;
    }

    @Generated
    public void setRenderHotbarSelectorAboveItems(boolean renderHotbarSelectorAboveItems) {
        this.renderHotbarSelectorAboveItems = renderHotbarSelectorAboveItems;
    }

    @Generated
    public void setEnableScreenShake(boolean enableScreenShake) {
        this.enableScreenShake = enableScreenShake;
    }

    @Generated
    public void setShakeTimer(int shakeTimer) {
        this.shakeTimer = shakeTimer;
    }

    @Generated
    public void setShakeAmplitude(float shakeAmplitude) {
        this.shakeAmplitude = shakeAmplitude;
    }

    @Generated
    public void setEnableEnchantParticles(boolean enableEnchantParticles) {
        this.enableEnchantParticles = enableEnchantParticles;
    }

    @Generated
    public void setEnableCurseFormatting(boolean enableCurseFormatting) {
        this.enableCurseFormatting = enableCurseFormatting;
    }

    @Generated
    public void setEnableAdvancementToastItems(boolean enableAdvancementToastItems) {
        this.enableAdvancementToastItems = enableAdvancementToastItems;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableHotbarSelectorAnimation() != other.isEnableHotbarSelectorAnimation()) {
            return false;
        }
        if (this.isEnableFloatingItemRotation() != other.isEnableFloatingItemRotation()) {
            return false;
        }
        if (this.isEnableMatchingItemHovering() != other.isEnableMatchingItemHovering()) {
            return false;
        }
        if (this.isDisableVanillaSlotHighlighting() != other.isDisableVanillaSlotHighlighting()) {
            return false;
        }
        if (this.isEnableRarityParticles() != other.isEnableRarityParticles()) {
            return false;
        }
        if (Double.compare(this.getHotbarSelectorSpeed(), other.getHotbarSelectorSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getHoveredItemScale(), other.getHoveredItemScale()) != 0) {
            return false;
        }
        if (Float.compare(this.getFloatingItemScale(), other.getFloatingItemScale()) != 0) {
            return false;
        }
        if (Float.compare(this.getMatchingItemHoverAmplitude(), other.getMatchingItemHoverAmplitude()) != 0) {
            return false;
        }
        if (Float.compare(this.getFloatingItemEasingSpeed(), other.getFloatingItemEasingSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getFloatingItemRotationAmplitude(), other.getFloatingItemRotationAmplitude()) != 0) {
            return false;
        }
        if (this.isRenderHotbarSelectorAboveItems() != other.isRenderHotbarSelectorAboveItems()) {
            return false;
        }
        if (this.isEnableScreenShake() != other.isEnableScreenShake()) {
            return false;
        }
        if (this.getShakeTimer() != other.getShakeTimer()) {
            return false;
        }
        if (Float.compare(this.getShakeAmplitude(), other.getShakeAmplitude()) != 0) {
            return false;
        }
        if (this.isEnableEnchantParticles() != other.isEnableEnchantParticles()) {
            return false;
        }
        if (this.isEnableCurseFormatting() != other.isEnableCurseFormatting()) {
            return false;
        }
        return this.isEnableAdvancementToastItems() == other.isEnableAdvancementToastItems();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableHotbarSelectorAnimation() ? 79 : 97);
        result = result * 59 + (this.isEnableFloatingItemRotation() ? 79 : 97);
        result = result * 59 + (this.isEnableMatchingItemHovering() ? 79 : 97);
        result = result * 59 + (this.isDisableVanillaSlotHighlighting() ? 79 : 97);
        result = result * 59 + (this.isEnableRarityParticles() ? 79 : 97);
        long $hotbarSelectorSpeed = Double.doubleToLongBits(this.getHotbarSelectorSpeed());
        result = result * 59 + (int)($hotbarSelectorSpeed >>> 32 ^ $hotbarSelectorSpeed);
        result = result * 59 + Float.floatToIntBits(this.getHoveredItemScale());
        result = result * 59 + Float.floatToIntBits(this.getFloatingItemScale());
        result = result * 59 + Float.floatToIntBits(this.getMatchingItemHoverAmplitude());
        result = result * 59 + Float.floatToIntBits(this.getFloatingItemEasingSpeed());
        result = result * 59 + Float.floatToIntBits(this.getFloatingItemRotationAmplitude());
        result = result * 59 + (this.isRenderHotbarSelectorAboveItems() ? 79 : 97);
        result = result * 59 + (this.isEnableScreenShake() ? 79 : 97);
        result = result * 59 + this.getShakeTimer();
        result = result * 59 + Float.floatToIntBits(this.getShakeAmplitude());
        result = result * 59 + (this.isEnableEnchantParticles() ? 79 : 97);
        result = result * 59 + (this.isEnableCurseFormatting() ? 79 : 97);
        result = result * 59 + (this.isEnableAdvancementToastItems() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "Config(enableHotbarSelectorAnimation=" + this.isEnableHotbarSelectorAnimation() + ", enableFloatingItemRotation=" + this.isEnableFloatingItemRotation() + ", enableMatchingItemHovering=" + this.isEnableMatchingItemHovering() + ", disableVanillaSlotHighlighting=" + this.isDisableVanillaSlotHighlighting() + ", enableRarityParticles=" + this.isEnableRarityParticles() + ", hotbarSelectorSpeed=" + this.getHotbarSelectorSpeed() + ", hoveredItemScale=" + this.getHoveredItemScale() + ", floatingItemScale=" + this.getFloatingItemScale() + ", matchingItemHoverAmplitude=" + this.getMatchingItemHoverAmplitude() + ", floatingItemEasingSpeed=" + this.getFloatingItemEasingSpeed() + ", floatingItemRotationAmplitude=" + this.getFloatingItemRotationAmplitude() + ", renderHotbarSelectorAboveItems=" + this.isRenderHotbarSelectorAboveItems() + ", enableScreenShake=" + this.isEnableScreenShake() + ", shakeTimer=" + this.getShakeTimer() + ", shakeAmplitude=" + this.getShakeAmplitude() + ", enableEnchantParticles=" + this.isEnableEnchantParticles() + ", enableCurseFormatting=" + this.isEnableCurseFormatting() + ", enableAdvancementToastItems=" + this.isEnableAdvancementToastItems() + ")";
    }
}

