/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block.entity.coffin;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawner;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerConfig;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.registry.TTMobEffects;
import net.frozenblock.trailiertales.registry.TTParticleTypes;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4844;
import net.minecraft.class_5819;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class CoffinSpawnerData {
    public static MapCodec<CoffinSpawnerData> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1952.field_34461.optionalFieldOf("spawn_potentials", (Object)class_6012.method_34990()).forGetter(data -> data.spawnPotentials), (App)Codec.INT.listOf().lenientOptionalFieldOf("souls_to_spawn", (Object)new IntArrayList()).forGetter(data -> data.soulsToSpawn), (App)class_4844.field_47491.lenientOptionalFieldOf("potential_players", (Object)Sets.newHashSet()).forGetter(data -> data.potentialPlayers), (App)class_4844.field_47491.lenientOptionalFieldOf("detected_players", (Object)Sets.newHashSet()).forGetter(data -> data.detectedPlayers), (App)class_4844.field_47491.optionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(data -> data.currentMobs), (App)class_4844.field_47491.optionalFieldOf("current_apparitions", (Object)Sets.newHashSet()).forGetter(data -> data.currentApparitions), (App)Codec.LONG.optionalFieldOf("power_cooldown_ends_at", (Object)0L).forGetter(data -> data.powerCooldownEndsAt), (App)Codec.LONG.lenientOptionalFieldOf("next_mob_spawns_at", (Object)0L).forGetter(data -> data.nextMobSpawnsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(data -> data.totalMobsSpawned), (App)Codec.LONG.lenientOptionalFieldOf("next_apparition_spawns_at", (Object)0L).forGetter(data -> data.nextApparitionSpawnsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("total_apparitions_spawned", (Object)0).forGetter(data -> data.totalApparitionsSpawned), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(data -> data.cooldownEndsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("power", (Object)0).forGetter(data -> data.power), (App)class_1952.field_34460.optionalFieldOf("spawn_data").forGetter(data -> data.nextSpawnData), (App)Codec.BOOL.optionalFieldOf("within_catacombs", (Object)false).forGetter(data -> data.withinCatacombs), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("max_active_light_level", (Object)10).forGetter(data -> data.maxActiveLightLevel)).apply((Applicative)instance, CoffinSpawnerData::new));
    protected final IntArrayList soulsToSpawn = new IntArrayList();
    protected final Set<UUID> potentialPlayers = new HashSet<UUID>();
    protected final Set<UUID> detectedPlayers = new HashSet<UUID>();
    protected final Set<UUID> currentMobs = new HashSet<UUID>();
    protected final Set<UUID> currentApparitions = new HashSet<UUID>();
    protected long powerCooldownEndsAt;
    protected long nextMobSpawnsAt;
    protected int totalMobsSpawned;
    protected long nextApparitionSpawnsAt;
    protected int totalApparitionsSpawned;
    protected long cooldownEndsAt;
    protected int power;
    protected Optional<class_1952> nextSpawnData;
    protected boolean withinCatacombs;
    protected int maxActiveLightLevel;
    private class_6012<class_1952> spawnPotentials;

    public CoffinSpawnerData() {
        this((class_6012<class_1952>)class_6012.method_34990(), (List<Integer>)new IntArrayList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, 0L, 0, 0L, 0, Optional.empty(), false, 7);
    }

    public CoffinSpawnerData(class_6012<class_1952> spawnPotentials, List<Integer> soulsToSpawn, Set<UUID> potentialPlayers, Set<UUID> detectedPlayers, Set<UUID> currentMobs, Set<UUID> currentApparitions, long powerCooldownEndsAt, long nextMobSpawnsAt, int totalMobsSpawned, long nextApparitionSpawnsAt, int totalApparitionsSpawned, long cooldownEndsAt, int power, Optional<class_1952> nextSpawnData, boolean withinCatacombs, int maxActiveLightLevel) {
        this.spawnPotentials = spawnPotentials;
        this.soulsToSpawn.addAll(soulsToSpawn);
        this.potentialPlayers.addAll(potentialPlayers);
        this.detectedPlayers.addAll(detectedPlayers);
        this.currentMobs.addAll(currentMobs);
        this.currentApparitions.addAll(currentApparitions);
        this.powerCooldownEndsAt = powerCooldownEndsAt;
        this.nextMobSpawnsAt = nextMobSpawnsAt;
        this.totalMobsSpawned = totalMobsSpawned;
        this.nextApparitionSpawnsAt = nextApparitionSpawnsAt;
        this.totalApparitionsSpawned = totalApparitionsSpawned;
        this.cooldownEndsAt = cooldownEndsAt;
        this.power = power;
        this.nextSpawnData = nextSpawnData;
        this.withinCatacombs = withinCatacombs;
        this.maxActiveLightLevel = maxActiveLightLevel;
    }

    public void immediatelyActivate(class_1937 level, class_2338 pos, @NotNull CoffinSpawner coffinSpawner) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        if (coffinSpawner.canSpawnApparition((class_1937)serverLevel, pos, true)) {
            this.nextApparitionSpawnsAt = 0L;
            this.nextMobSpawnsAt = 0L;
            coffinSpawner.addPower(1, (class_1937)serverLevel);
            coffinSpawner.spawnApparition(serverLevel, pos);
        }
    }

    public void reset() {
        this.totalMobsSpawned = 0;
        this.power = 0;
        this.nextMobSpawnsAt = 0L;
        this.powerCooldownEndsAt = 0L;
        this.nextApparitionSpawnsAt = 0L;
        this.cooldownEndsAt = 0L;
        this.currentMobs.clear();
        this.currentApparitions.clear();
    }

    public boolean hasMobToSpawn(class_5819 random) {
        boolean hasNextSpawnData = this.getOrCreateNextSpawnData(random).method_38093().method_10545("id");
        return hasNextSpawnData || !this.spawnPotentials().method_34993();
    }

    public boolean hasFinishedSpawningAllMobs(@NotNull CoffinSpawnerConfig config, int players) {
        return this.totalMobsSpawned >= config.calculateTargetTotalMobs(players);
    }

    public boolean haveAllCurrentMobsDied() {
        return this.currentMobs.isEmpty();
    }

    public boolean haveAllCurrentApparitionsDied() {
        return this.currentApparitions.isEmpty();
    }

    public boolean trackingEntity(@NotNull class_1297 entity) {
        return this.currentMobs.contains(entity.method_5667());
    }

    public boolean trackingApparition(@NotNull class_1297 entity) {
        return this.currentApparitions.contains(entity.method_5667());
    }

    public boolean isOnCooldown(@NotNull class_1937 level) {
        return level.method_75260() < this.cooldownEndsAt;
    }

    public boolean hasMobToSpawnAndIsntOnCooldown(class_1937 level, class_5819 random) {
        return !this.isOnCooldown(level) && this.hasMobToSpawn(random);
    }

    public int getPower() {
        return this.power;
    }

    public boolean isReadyToSpawnNextMob(@NotNull class_3218 level, CoffinSpawnerConfig config, int players) {
        return this.isPreparingToSpawnNextMob(level, config, players, 0);
    }

    public boolean isPreparingToSpawnNextMob(@NotNull class_3218 level, CoffinSpawnerConfig config, int players, int timeAhead) {
        return level.method_75260() + (long)timeAhead >= this.nextMobSpawnsAt && this.detectedAnyPlayers() && this.currentMobs.size() < config.calculateTargetSimultaneousMobs(players);
    }

    public int countAdditionalPlayers() {
        return Math.max(0, this.detectedPlayers.size() - 1);
    }

    public boolean detectedAnyPlayers() {
        return !this.detectedPlayers.isEmpty();
    }

    public boolean hasPotentialPlayers() {
        return !this.potentialPlayers.isEmpty();
    }

    public Optional<class_1657> getClosestDetectedPlayer(class_1937 level, class_243 origin) {
        return this.getClosestPlayerFromSet(this.detectedPlayers, level, origin);
    }

    public Optional<class_1657> getClosestPotentialPlayer(class_1937 level, class_243 origin) {
        return this.getClosestPlayerFromSet(this.potentialPlayers, level, origin);
    }

    private Optional<class_1657> getClosestPlayerFromSet(@NotNull Set<UUID> players, class_1937 level, class_243 origin) {
        if (players.isEmpty()) {
            return Optional.empty();
        }
        AtomicReference<Double> closestDistance = new AtomicReference<Double>((Double)Double.MAX_VALUE);
        AtomicReference closestPlayer = new AtomicReference(Optional.empty());
        players.forEach(uuid -> {
            double distanceTo;
            class_1657 player = level.method_18470(uuid);
            if (player != null && class_1301.field_6156.test(player) && (distanceTo = player.method_5707(origin)) < (Double)closestDistance.get()) {
                closestDistance.set(distanceTo);
                closestPlayer.set(Optional.of(player));
            }
        });
        return closestPlayer.get();
    }

    public List<class_1657> getNearbyDetectedPlayers(class_1937 level, class_243 origin, double distance) {
        return this.getNearbyPlayersFromSet(this.detectedPlayers, level, origin, distance);
    }

    public List<class_1657> getNearbyPotentialPlayers(class_1937 level, class_243 origin, double distance) {
        return this.getNearbyPlayersFromSet(this.potentialPlayers, level, origin, distance);
    }

    @NotNull
    private List<class_1657> getNearbyPlayersFromSet(@NotNull Set<UUID> players, class_1937 level, class_243 origin, double distance) {
        ArrayList<class_1657> nearbyPlayers = new ArrayList<class_1657>();
        double squaredDistance = distance * distance;
        if (players.isEmpty()) {
            return nearbyPlayers;
        }
        players.forEach(uuid -> {
            class_1657 player = level.method_18470(uuid);
            if (player != null && class_1301.field_6156.test(player) && player.method_5707(origin) < squaredDistance) {
                nearbyPlayers.add(player);
            }
        });
        return nearbyPlayers;
    }

    public void tryDetectPlayers(@NotNull class_3218 world, @NotNull class_2338 pos, class_2350 direction, CoffinSpawner coffinSpawner) {
        boolean isSecondForPos;
        boolean bl = isSecondForPos = (pos.method_10063() + world.method_75260()) % 20L == 0L;
        if (!isSecondForPos) {
            return;
        }
        List list = coffinSpawner.getPlayerDetector().detect(world, coffinSpawner.getEntitySelector(), pos, (double)coffinSpawner.getRequiredPlayerRange(), this.withinCatacombs);
        this.potentialPlayers.addAll(list);
        if (!coffinSpawner.isOminous() && !list.isEmpty()) {
            Optional<Pair<class_1657, class_6880<class_1291>>> optional = CoffinSpawnerData.findPlayerWithOminousEffect(world, list);
            optional.ifPresent(pair -> {
                class_1657 player = (class_1657)pair.getFirst();
                if (pair.getSecond() == class_1294.field_16595) {
                    CoffinSpawnerData.transformBadOmenIntoSiegeOmen(player);
                }
                coffinSpawner.applyOminous(world);
            });
        }
        ArrayList<UUID> detectedList = new ArrayList<UUID>(list);
        detectedList.removeIf(uuid -> {
            class_1657 player;
            class_1657 patt0$temp = world.method_18470(uuid);
            return !(patt0$temp instanceof class_1657) || !(player = patt0$temp).method_6059(TTMobEffects.HAUNT) && !player.method_6059(TTMobEffects.SIEGE_OMEN);
        });
        for (UUID uuid2 : this.currentApparitions) {
            Apparition apparition;
            class_1309 target;
            class_1297 class_12972 = world.method_66347(uuid2);
            if (!(class_12972 instanceof Apparition) || !((target = (apparition = (Apparition)class_12972).method_5968()) instanceof class_1657)) continue;
            class_1657 player = (class_1657)target;
            detectedList.add(player.method_5667());
        }
        if (this.detectedPlayers.addAll(detectedList)) {
            class_5819 randomSource = world.field_9229;
            CoffinBlock.spawnParticlesFrom(world, (class_2394)TTParticleTypes.COFFIN_SOUL, 8 + Math.min(this.countAdditionalPlayers() * 3, 15), 0.015, direction, pos, 0.45);
            world.method_8396(null, pos, TTSounds.COFFIN_DETECT_PLAYER, class_3419.field_15245, 2.0f, (randomSource.method_43057() - randomSource.method_43057()) * 0.2f + 1.0f);
        }
        this.detectedPlayers.removeIf(uuid -> !detectedList.contains(uuid));
    }

    private static Optional<Pair<class_1657, class_6880<class_1291>>> findPlayerWithOminousEffect(class_3218 world, @NotNull List<UUID> list) {
        class_1657 player = null;
        for (UUID uUID : list) {
            class_1657 player2 = world.method_18470(uUID);
            if (player2 == null) continue;
            class_6880<class_1291> holder = TTMobEffects.SIEGE_OMEN;
            if (player2.method_6059(holder)) {
                return Optional.of(Pair.of((Object)player2, holder));
            }
            if (!player2.method_6059(class_1294.field_16595)) continue;
            player = player2;
        }
        return Optional.ofNullable(player).map(playerx -> Pair.of((Object)playerx, (Object)class_1294.field_16595));
    }

    private static void transformBadOmenIntoSiegeOmen(@NotNull class_1657 player) {
        class_1293 mobEffectInstance = player.method_6112(class_1294.field_16595);
        if (mobEffectInstance != null) {
            int i = mobEffectInstance.method_5578() + 1;
            int j = 18000 * i;
            player.method_6016(class_1294.field_16595);
            player.method_6092(new class_1293(TTMobEffects.SIEGE_OMEN, j, 0));
        }
    }

    public boolean isPowerCooldownFinished(@NotNull class_3218 level) {
        return level.method_75260() >= this.powerCooldownEndsAt;
    }

    public void setEntityId(class_1299<?> type, class_5819 random) {
        this.getOrCreateNextSpawnData(random).method_38093().method_10582("id", class_7923.field_41177.method_10221(type).toString());
    }

    public class_6012<class_1952> spawnPotentials() {
        return this.spawnPotentials;
    }

    @NotNull
    class_1952 getOrCreateNextSpawnData(class_5819 random) {
        if (this.nextSpawnData.isEmpty()) {
            this.setNextSpawnData(this.spawnPotentials.method_34992(random).orElseGet(class_1952::new));
        }
        return this.nextSpawnData.get();
    }

    protected void setNextSpawnData(class_1952 spawnEntry) {
        this.nextSpawnData = Optional.ofNullable(spawnEntry);
    }
}

