/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.client.renderer.debug;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.trailiertales.block.entity.coffin.impl.EntityCoffinData;
import net.minecraft.class_12021;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_863;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CoffinDebugRenderer
implements class_863.class_864 {
    private static final int CONNECTION_COLOR = class_9848.method_61324((int)255, (int)50, (int)125, (int)90);
    private static final int SELECTED_CONNECTION_COLOR = class_9848.method_61324((int)255, (int)255, (int)50, (int)255);
    private static final int TEXT_COLOR = class_9848.method_61324((int)255, (int)255, (int)255, (int)255);
    private final class_310 minecraft;
    private final IntArrayList scheduledRemovals = new IntArrayList();
    private final Map<Integer, EntityCoffinData> connections = Maps.newHashMap();
    @Nullable
    private Integer lastLookedAtId;
    private long gameTime;

    public CoffinDebugRenderer(class_310 client) {
        this.minecraft = client;
    }

    private void clearRemovedEntities() {
        this.connections.entrySet().removeIf(entry -> {
            int id = (Integer)entry.getKey();
            if (this.scheduledRemovals.contains(id)) {
                return true;
            }
            class_1297 entity = this.minecraft.field_1687.method_8469(id);
            return entity == null || entity.method_31481();
        });
    }

    public void addConnection(int entityId, class_2338 coffinPos, long lastInteractionTime, long gameTime) {
        this.connections.put(entityId, new EntityCoffinData(coffinPos, UUID.randomUUID(), lastInteractionTime));
        this.gameTime = gameTime;
    }

    public void scheduleRemoval(int entityId) {
        this.scheduledRemovals.add(entityId);
    }

    public void method_23109(double cameraX, double cameraY, double cameraZ, class_12021 debugValueAccess, class_4604 frustum, float unknown) {
        this.clearRemovedEntities();
        this.scheduledRemovals.removeIf(id -> true);
        if (!this.minecraft.field_1724.method_7325()) {
            this.updateLastLookedAtUuid();
        }
        for (Map.Entry<Integer, EntityCoffinData> connectionInfo : this.connections.entrySet()) {
            class_1297 entity;
            EntityCoffinData coffinData = connectionInfo.getValue();
            boolean selected = false;
            Integer id2 = connectionInfo.getKey();
            if (id2 != null && (entity = this.minecraft.field_1687.method_8469(id2.intValue())) == null) continue;
        }
    }

    private void updateLastLookedAtUuid() {
        class_863.method_23101((class_1297)this.minecraft.method_1560(), (int)8).ifPresent(entity -> {
            this.lastLookedAtId = entity.method_5628();
        });
    }
}

