/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.entity.ai.apparition;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.registry.TTEntityTypes;
import net.frozenblock.trailiertales.registry.TTMemoryModuleTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;

public class ApparitionAidablesSensor
extends class_4148<Apparition> {
    @NotNull
    public Set<class_4140<?>> method_19099() {
        return Set.of(TTMemoryModuleTypes.NEARBY_AIDABLES, TTMemoryModuleTypes.NEAREST_AIDABLE);
    }

    protected boolean isMatchingEntity(Apparition apparition, class_1309 target, List<UUID> takenUUIDs) {
        return this.isClose(apparition, target) && this.isAidable(apparition, target, takenUUIDs);
    }

    private boolean isAidable(@NotNull Apparition apparition, @NotNull class_1309 entity, List<UUID> takenUUIDs) {
        class_1309 newTarget = apparition.method_5968();
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            if (!(newTarget == null || mob.method_5864() == TTEntityTypes.APPARITION || mob.method_5864().method_5891().method_6136() || mob.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES) || takenUUIDs.contains(mob.method_5667()))) {
                Optional trackingUUIDs;
                class_4095<Apparition> brain = apparition.method_18868();
                if (brain.method_18896(TTMemoryModuleTypes.AIDING_TIME) && (trackingUUIDs = brain.method_18904(TTMemoryModuleTypes.AIDING_ENTITIES)).isPresent() && !((List)trackingUUIDs.get()).contains(mob.method_5667())) {
                    return false;
                }
                class_1309 currentTarget = mob.method_5968();
                return mob != apparition && mob.method_5805() && !mob.method_7325() && mob != currentTarget && (currentTarget == null || currentTarget.method_5864() != class_1299.field_6097);
            }
        }
        return false;
    }

    private boolean isClose(Apparition apparition, @NotNull class_1309 target) {
        return (double)target.method_5739((class_1297)apparition) <= apparition.method_45325(class_5134.field_23717);
    }

    protected void doTick(@NotNull class_3218 world, @NotNull Apparition apparition) {
        class_4095<Apparition> brain = apparition.method_18868();
        class_1309 attackTarget = apparition.method_5968();
        if (attackTarget != null) {
            ArrayList takenUUIDs = new ArrayList();
            world.method_27909().forEach(entity -> {
                Apparition otherApparition;
                if (entity instanceof Apparition && (otherApparition = (Apparition)((Object)entity)) != apparition) {
                    otherApparition.method_18868().method_18904(TTMemoryModuleTypes.AIDING_ENTITIES).ifPresent(takenUUIDs::addAll);
                }
            });
            double range = apparition.method_45325(class_5134.field_23717);
            class_238 aABB = apparition.method_5829().method_1009(range, range, range);
            List list = world.method_8390(class_1309.class, aABB, livingEntity2 -> this.isMatchingEntity(apparition, (class_1309)livingEntity2, takenUUIDs));
            list.sort(Comparator.comparingDouble(arg_0 -> ((Apparition)apparition).method_5858(arg_0)));
            brain.method_18878(TTMemoryModuleTypes.NEARBY_AIDABLES, (Object)list);
            brain.method_18879(TTMemoryModuleTypes.NEAREST_AIDABLE, this.getNearestEntity(apparition));
        } else {
            brain.method_18878(TTMemoryModuleTypes.NEARBY_AIDABLES, new ArrayList());
            brain.method_18875(TTMemoryModuleTypes.NEAREST_AIDABLE);
        }
    }

    private Optional<class_1309> getNearestEntity(@NotNull Apparition apparition) {
        return apparition.method_18868().method_18904(TTMemoryModuleTypes.NEARBY_AIDABLES).flatMap(livingEntities -> this.findClosest((List<? extends class_1309>)livingEntities, livingEntity -> true));
    }

    private Optional<class_1309> findClosest(@NotNull List<? extends class_1309> livingEntities, Predicate<class_1309> predicate) {
        for (class_1309 class_13092 : livingEntities) {
            if (!predicate.test(class_13092)) continue;
            return Optional.of(class_13092);
        }
        return Optional.empty();
    }
}

