/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block;

import com.mojang.serialization.MapCodec;
import net.frozenblock.trailiertales.registry.TTItems;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.minecraft.class_10225;
import net.minecraft.class_10376;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7118;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DawntrailBlock
extends class_10376
implements class_2256 {
    public static final MapCodec<DawntrailBlock> CODEC = DawntrailBlock.method_54094(DawntrailBlock::new);
    public static final class_2758 AGE = class_2741.field_12556;
    public static final int MAX_AGE = 2;
    private final class_7118 spreader = new DawntrailSpreader(this);

    @NotNull
    public MapCodec<DawntrailBlock> method_53969() {
        return CODEC;
    }

    public DawntrailBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AGE});
    }

    public static boolean canAttachTo(class_1922 world, @NotNull class_2350 direction, class_2338 pos, @NotNull class_2680 state) {
        return class_5778.method_33358((class_1922)world, (class_2350)direction, (class_2338)pos, (class_2680)state) || state.method_27852(class_2246.field_10362);
    }

    @NotNull
    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 tickAccess, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (!DawntrailBlock.method_33381((class_2680)state)) {
            return class_2246.field_10124.method_9564();
        }
        return DawntrailBlock.method_33366((class_2680)state, (class_2350)direction) && !DawntrailBlock.canAttachTo((class_1922)level, direction, neighborPos, neighborState) ? DawntrailBlock.method_33365((class_2680)state, (class_2746)DawntrailBlock.method_33374((class_2350)direction)) : state;
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        boolean bl = false;
        for (class_2350 direction : field_28421) {
            if (!DawntrailBlock.method_33366((class_2680)state, (class_2350)direction)) continue;
            class_2338 blockPos = pos.method_10093(direction);
            if (!DawntrailBlock.canAttachTo((class_1922)world, direction, blockPos, world.method_8320(blockPos))) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public boolean method_41438(class_1922 view, @NotNull class_2680 state, class_2338 pos, class_2350 dir) {
        if (!state.method_26227().method_15769()) {
            return false;
        }
        if (!(!this.method_33369(dir) || state.method_27852((class_2248)this) && DawntrailBlock.method_33366((class_2680)state, (class_2350)dir))) {
            class_2338 blockPos = pos.method_10093(dir);
            return DawntrailBlock.canAttachTo(view, dir, blockPos, view.method_8320(blockPos));
        }
        return false;
    }

    public static boolean isMaxAge(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) >= 2;
    }

    private void grow(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)AGE) + 1)), 2);
    }

    protected boolean method_9616(class_2680 state, @NotNull class_1750 context) {
        return context.method_8041().method_31574(this.method_8389()) && super.method_9616(state, context);
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return !DawntrailBlock.isMaxAge(state) || class_2350.method_42013().anyMatch(direction -> this.spreader.method_41443(state, (class_1922)world, pos, direction.method_10153()));
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        if (!DawntrailBlock.isMaxAge(state)) {
            this.grow((class_1937)world, pos, state);
        } else {
            this.spreader.method_41450(state, (class_1936)world, pos, random);
        }
    }

    @NotNull
    public class_1269 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (level instanceof class_3218 && DawntrailBlock.isMaxAge(state) && stack.method_31574(class_1802.field_8868)) {
            stack.method_7970(1, (class_1309)player, hand.method_73186());
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, level, pos, player, hand, hit);
    }

    public static void shear(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state, @Nullable class_1657 player) {
        level.method_8501(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
        class_1799 seeds = new class_1799((class_1935)TTItems.DAWNTRAIL_SEEDS);
        seeds.method_7939(DawntrailBlock.method_41440((class_2680)state).size());
        DawntrailBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)seeds);
        level.method_8396(null, pos, class_3417.field_34896, class_3419.field_15245, 1.0f, 1.0f);
        level.method_8396(null, pos, TTSounds.DAWNTRAIL_PICK, class_3419.field_15245, 1.0f, 0.95f + level.field_9229.method_43057() * 0.1f);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28730, pos);
    }

    @NotNull
    public class_7118 method_41432() {
        return this.spreader;
    }

    public static class DawntrailSpreader
    extends class_7118 {
        public DawntrailSpreader(@NotNull DawntrailBlock block) {
            super((class_7118.class_7120)new class_7118.class_7119((class_5778)block));
        }
    }
}

