/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block.entity.coffin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record CoffinSpawnerConfig(int spawnRange, float totalMobs, float simultaneousMobs, float totalMobsAddedPerPlayer, float simultaneousMobsAddedPerPlayer, int ticksBetweenSpawn, int powerForNextLevel, int maxApparitions, int ticksBetweenApparitionSpawn) {
    public static final CoffinSpawnerConfig DEFAULT = new CoffinSpawnerConfig(4, 6.0f, 1.0f, 2.0f, 0.0f, 400, 4, 1, 1600);
    public static final CoffinSpawnerConfig IRRITATED = new CoffinSpawnerConfig(5, 12.0f, 1.0f, 2.0f, 1.0f, 300, 6, 1, 1200);
    public static final CoffinSpawnerConfig AGGRESSIVE = new CoffinSpawnerConfig(6, 10.0f, 1.0f, 3.0f, 1.0f, 200, 10, 1, 1000);
    public static final CoffinSpawnerConfig OMINOUS = new CoffinSpawnerConfig(6, 15.0f, 2.0f, 3.0f, 1.0f, 150, 15, 2, 800);
    public static final Codec<CoffinSpawnerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)128).lenientOptionalFieldOf("spawn_range", (Object)CoffinSpawnerConfig.DEFAULT.spawnRange).forGetter(CoffinSpawnerConfig::spawnRange), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).lenientOptionalFieldOf("total_mobs", (Object)Float.valueOf(CoffinSpawnerConfig.DEFAULT.totalMobs)).forGetter(CoffinSpawnerConfig::totalMobs), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).lenientOptionalFieldOf("simultaneous_mobs", (Object)Float.valueOf(CoffinSpawnerConfig.DEFAULT.simultaneousMobs)).forGetter(CoffinSpawnerConfig::simultaneousMobs), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).lenientOptionalFieldOf("total_mobs_added_per_player", (Object)Float.valueOf(CoffinSpawnerConfig.DEFAULT.totalMobsAddedPerPlayer)).forGetter(CoffinSpawnerConfig::totalMobsAddedPerPlayer), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).lenientOptionalFieldOf("simultaneous_mobs_added_per_player", (Object)Float.valueOf(CoffinSpawnerConfig.DEFAULT.simultaneousMobsAddedPerPlayer)).forGetter(CoffinSpawnerConfig::simultaneousMobsAddedPerPlayer), (App)Codec.intRange((int)80, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("ticks_between_spawn", (Object)CoffinSpawnerConfig.DEFAULT.ticksBetweenSpawn).forGetter(CoffinSpawnerConfig::ticksBetweenSpawn), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("power_for_next_level", (Object)CoffinSpawnerConfig.DEFAULT.powerForNextLevel).forGetter(CoffinSpawnerConfig::powerForNextLevel), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("max_apparitions", (Object)CoffinSpawnerConfig.DEFAULT.maxApparitions).forGetter(CoffinSpawnerConfig::maxApparitions), (App)Codec.intRange((int)800, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("ticks_between_apparition_spawn", (Object)CoffinSpawnerConfig.DEFAULT.ticksBetweenApparitionSpawn).forGetter(CoffinSpawnerConfig::ticksBetweenApparitionSpawn)).apply((Applicative)instance, CoffinSpawnerConfig::new));

    public int calculateTargetTotalMobs(int players) {
        return (int)Math.floor(this.totalMobs + this.totalMobsAddedPerPlayer * (float)players);
    }

    public int calculateTargetSimultaneousMobs(int players) {
        return (int)Math.floor(this.simultaneousMobs + this.simultaneousMobsAddedPerPlayer * (float)players);
    }
}

