/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.client.renderer.blockentity;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinBlockEntity;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerState;
import net.frozenblock.trailiertales.block.impl.CoffinPart;
import net.frozenblock.trailiertales.client.TTModelLayers;
import net.frozenblock.trailiertales.client.model.CoffinModel;
import net.frozenblock.trailiertales.client.renderer.blockentity.state.CoffinRenderState;
import net.frozenblock.trailiertales.registry.TTBlockEntityTypes;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_5599;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class CoffinRenderer
implements class_827<CoffinBlockEntity, CoffinRenderState> {
    private final CoffinModel headModel;
    private final CoffinModel footModel;

    public CoffinRenderer(@NotNull class_5614.class_5615 context) {
        this(context.comp_4539());
    }

    public CoffinRenderer(@NotNull class_5599 entityModelSet) {
        this.headModel = new CoffinModel(entityModelSet.method_32072(TTModelLayers.COFFIN_HEAD));
        this.footModel = new CoffinModel(entityModelSet.method_32072(TTModelLayers.COFFIN_FOOT));
    }

    @NotNull
    public static class_2960 getCoffinTexture(@NotNull CoffinPart part, CoffinSpawnerState state) {
        return part == CoffinPart.HEAD ? state.getHeadTexture() : state.getFootTexture();
    }

    public void submit(@NotNull CoffinRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, @NotNull class_12075 cameraRenderState) {
        float openProg = renderState.openProgress;
        openProg = 1.0f - openProg;
        openProg = 1.0f - openProg * openProg * openProg;
        this.submitPiece(poseStack, submitNodeCollector, renderState.part == CoffinPart.HEAD ? this.headModel : this.footModel, CoffinRenderer.getCoffinTexture(renderState.part, renderState.spawnerState), null, openProg, renderState.wobbleProgress, renderState.field_62676, class_4608.field_21444, renderState.field_62677, 0, false, renderState.direction);
    }

    public void renderInHand(@NotNull class_4587 poseStack, class_11659 collector, int packedLight, int packedOverlay, class_2960 headTexture, class_2960 footTexture, float openness, int outlineColor) {
        poseStack.method_46416(0.0f, -0.1f, 0.0f);
        this.submitPiece(poseStack, collector, this.headModel, headTexture, null, openness, 0.0f, packedLight, packedOverlay, null, outlineColor, false, class_2350.field_11035);
        this.submitPiece(poseStack, collector, this.footModel, footTexture, null, openness, 0.0f, packedLight, packedOverlay, null, outlineColor, true, class_2350.field_11035);
    }

    private void submitPiece(@NotNull class_4587 poseStack, @NotNull class_11659 collector, @NotNull CoffinModel model, @NotNull class_2960 texture, @Nullable class_2960 glowingTexture, float openProgress, float wobbleProgress, int packedLight, int packedOverlay, @Nullable class_11683.class_11792 breakProgress, int outlineColor, boolean renderAsOffsetFoot, class_2350 direction) {
        poseStack.method_22903();
        openProgress = CoffinRenderer.setupPoseStackAndCalculateOpenProgress(poseStack, renderAsOffsetFoot, direction, openProgress, wobbleProgress);
        collector.method_73489((class_3879)model, (Object)Float.valueOf(openProgress), poseStack, class_12249.method_75990((class_2960)texture), packedLight, packedOverlay, outlineColor, breakProgress);
        if (glowingTexture != null) {
            collector.method_73489((class_3879)model, (Object)Float.valueOf(openProgress), poseStack, class_12249.method_76014((class_2960)glowingTexture), packedLight, packedOverlay, outlineColor, null);
        }
        poseStack.method_22909();
    }

    private static float setupPoseStackAndCalculateOpenProgress(@NotNull class_4587 poseStack, boolean renderAsOffsetFoot, @NotNull class_2350 direction, float openProgress, float wobbleProgress) {
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-direction.method_10144()));
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        if (wobbleProgress >= 0.0f && wobbleProgress <= 1.0f) {
            float coffinWobble = wobbleProgress * (float)Math.PI * 2.5f;
            float wobbleDampen = 1.0f - wobbleProgress;
            float wobble = -3.0f * class_3532.method_15362((float)coffinWobble) * class_3532.method_15374((float)coffinWobble) * wobbleDampen;
            poseStack.method_49278((Quaternionfc)class_7833.field_40718.rotation(wobble * 0.015625f), 0.5f, 0.0f, 0.5f);
            float lidWobble = (wobbleProgress + 0.16666667f) * (float)Math.PI * 2.5f;
            openProgress += Math.max(0.0f, class_3532.method_15362((float)lidWobble) * -0.25f * (class_3532.method_15374((float)lidWobble) * -0.25f)) * wobbleDampen;
        }
        if (renderAsOffsetFoot) {
            poseStack.method_46416(0.0f, 0.0f, -1.0f);
        }
        return openProgress * 1.5707964f;
    }

    public void getExtents(Set<Vector3f> set) {
        class_4587 poseStack = new class_4587();
        CoffinRenderer.setupPoseStackAndCalculateOpenProgress(poseStack, false, class_2350.field_11035, 0.0f, 0.0f);
        this.headModel.method_63512().method_72152(poseStack, set);
        poseStack.method_34426();
        CoffinRenderer.setupPoseStackAndCalculateOpenProgress(poseStack, true, class_2350.field_11035, 0.0f, 0.0f);
        this.footModel.method_63512().method_72152(poseStack, set);
    }

    @NotNull
    public CoffinRenderState createRenderState() {
        return new CoffinRenderState();
    }

    public void extractRenderState(@NotNull CoffinBlockEntity coffin, @NotNull CoffinRenderState renderState, float partialTick, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)coffin, (class_11954)renderState, partialTick, cameraPos, crumblingOverlay);
        class_1937 level = coffin.method_10997();
        renderState.part = (CoffinPart)((Object)renderState.field_62674.method_11654(CoffinBlock.PART));
        renderState.spawnerState = (CoffinSpawnerState)((Object)renderState.field_62674.method_11654(CoffinBlock.STATE));
        renderState.ominous = coffin.getCoffinSpawner().isOminous();
        renderState.direction = (class_2350)renderState.field_62674.method_11654((class_2769)CoffinBlock.field_11177);
        renderState.openProgress = coffin.getOpenProgress(partialTick);
        renderState.wobbleProgress = ((float)(level.method_75260() - coffin.wobbleStartedAtTick) + partialTick) / 15.0f;
        class_4732.class_4734 neighborCombineResult = class_4732.method_24173(TTBlockEntityTypes.COFFIN, CoffinBlock::getBlockType, CoffinBlock::getConnectedDirection, (class_2769)CoffinBlock.field_11177, (class_2680)renderState.field_62674, (class_1936)level, (class_2338)renderState.field_62673, (world, pos) -> false);
        renderState.field_62676 = ((Int2IntFunction)neighborCombineResult.apply((class_4732.class_3923)new class_4737())).get(renderState.field_62676);
    }
}

