/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.client.renderer.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.trailiertales.TTConstants;
import net.frozenblock.trailiertales.client.TTModelLayers;
import net.frozenblock.trailiertales.client.model.ApparitionModel;
import net.frozenblock.trailiertales.client.renderer.entity.layers.ApparitionLayer;
import net.frozenblock.trailiertales.client.renderer.entity.state.ApparitionRenderState;
import net.frozenblock.trailiertales.entity.Apparition;
import net.minecraft.class_10042;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ApparitionRenderer
extends class_927<Apparition, ApparitionRenderState, ApparitionModel> {
    private static final class_2960 TEXTURE = TTConstants.id("textures/entity/apparition/apparition.png");
    private static final class_2960 HYPNOTIZING_TEXTURE = TTConstants.id("textures/entity/apparition/apparition_hypnotizing.png");
    private static final class_2960 SHOOTING_TEXTURE = TTConstants.id("textures/entity/apparition/apparition_shooting.png");
    private final class_10442 itemModelResolver;
    private float itemYaw;

    public ApparitionRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new ApparitionModel(context.method_32167(TTModelLayers.APPARITION)), 0.5f);
        this.method_4046(new ApparitionLayer((class_3883<ApparitionRenderState, ApparitionModel>)this, renderState -> renderState.innerTransparency, renderState -> renderState.outerTransparency, TEXTURE, 0));
        ApparitionModel.AlphaFunction<ApparitionRenderState> aidAlpha = renderState -> renderState.aidAnimProgress * 0.8f;
        this.method_4046(new ApparitionLayer((class_3883<ApparitionRenderState, ApparitionModel>)this, aidAlpha, aidAlpha, HYPNOTIZING_TEXTURE, 1));
        ApparitionModel.AlphaFunction<ApparitionRenderState> poltergeistAlpha = renderState -> renderState.poltergeistAnimProgress * 0.8f;
        this.method_4046(new ApparitionLayer((class_3883<ApparitionRenderState, ApparitionModel>)this, poltergeistAlpha, poltergeistAlpha, SHOOTING_TEXTURE, 2));
        this.itemModelResolver = context.method_65566();
    }

    public void submit(@NotNull ApparitionRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, @NotNull class_12075 cameraRenderState) {
        super.method_4054((class_10042)renderState, poseStack, submitNodeCollector, cameraRenderState);
        if (!renderState.item.method_65606()) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.425f, 0.0f);
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - this.itemYaw));
            poseStack.method_22907((Quaternionfc)class_7833.field_40715.rotation(renderState.itemYRot));
            poseStack.method_22907((Quaternionfc)class_7833.field_40717.rotation(renderState.itemZRot));
            renderState.item.method_65604(poseStack, submitNodeCollector, renderState.field_61820, class_4608.field_21444, renderState.field_61821);
            poseStack.method_22909();
        }
    }

    protected void setupRotations(@NotNull ApparitionRenderState renderState, @NotNull class_4587 poseStack, float bodyYaw, float scale) {
        super.method_4058((class_10042)renderState, poseStack, bodyYaw, scale);
        this.itemYaw = bodyYaw;
        this.field_4672 = renderState.totalTransparency;
    }

    @Nullable
    protected class_1921 getRenderType(@NotNull ApparitionRenderState renderState, boolean bl, boolean bl2, boolean bl3) {
        return null;
    }

    @NotNull
    public class_2960 getTextureLocation(ApparitionRenderState renderState) {
        return TEXTURE;
    }

    protected int getBlockLightLevel(Apparition entity, class_2338 pos) {
        return 15;
    }

    @NotNull
    public ApparitionRenderState createRenderState() {
        return new ApparitionRenderState();
    }

    public void extractRenderState(@NotNull Apparition apparition, @NotNull ApparitionRenderState renderState, float partialTick) {
        super.method_62355((class_1309)apparition, (class_10042)renderState, partialTick);
        renderState.field_61820 = 0xF00000;
        renderState.itemYRot = apparition.getItemYRot(partialTick);
        renderState.itemZRot = apparition.getItemZRot(partialTick);
        renderState.totalTransparency = apparition.totalTransparency(partialTick);
        renderState.innerTransparency = apparition.getInnerTransparency(partialTick);
        renderState.outerTransparency = apparition.getOuterTransparency(partialTick);
        renderState.flicker = apparition.getFlicker(partialTick);
        this.itemModelResolver.method_65597(renderState.item, apparition.getVisibleItem(), class_811.field_4318, (class_1309)apparition);
        renderState.aidAnimProgress = apparition.getAidAnimProgress(partialTick);
        renderState.poltergeistAnimProgress = apparition.getPoltergeistAnimProgress(partialTick);
    }
}

