/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block.entity.coffin;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Optional;
import java.util.UUID;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerConfig;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerData;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerState;
import net.frozenblock.trailiertales.block.entity.coffin.impl.EntityCoffinData;
import net.frozenblock.trailiertales.block.entity.coffin.impl.EntityCoffinInterface;
import net.frozenblock.trailiertales.block.impl.CoffinPart;
import net.frozenblock.trailiertales.config.TTBlockConfig;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.entity.ai.apparition.ApparitionAi;
import net.frozenblock.trailiertales.registry.TTBlocks;
import net.frozenblock.trailiertales.registry.TTEntityTypes;
import net.frozenblock.trailiertales.registry.TTParticleTypes;
import net.frozenblock.trailiertales.registry.TTResources;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.frozenblock.trailiertales.tag.TTBlockTags;
import net.frozenblock.trailiertales.worldgen.structure.datagen.CatacombsGenerator;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7058;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8942;
import net.minecraft.class_8962;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class CoffinSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PLAYER_TRACKING_DISTANCE = 48;
    private static final int MAX_MOB_TRACKING_DISTANCE = 64;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = class_3532.method_34954((int)64);
    private static final class_8962.class_9198 ENTITY_SELECTOR = class_8962.class_9198.field_48862;
    public static final class_8962 IN_CATACOMBS_NO_CREATIVE_PLAYERS = (world, entitySelector, pos, d, bl) -> entitySelector.method_56725(world, player -> player.method_24515().method_19771((class_2382)pos, d) && !player.method_68878() && !player.method_7325()).stream().filter(player -> !bl || CoffinSpawner.isInCatacombsBounds(player.method_24515(), world.method_27056())).map(class_1297::method_5667).toList();
    private final CoffinSpawnerConfig normalConfig;
    private final CoffinSpawnerConfig irritatedConfig;
    private final CoffinSpawnerConfig aggressiveConfig;
    private final CoffinSpawnerConfig ominousConfig;
    private final CoffinSpawnerData data;
    private final int requiredPlayerRange;
    private final int powerCooldownLength;
    private final StateAccessor stateAccessor;
    private final UUID uuid;
    private boolean attemptingToSpawnMob;

    @Contract(value=" -> new")
    @NotNull
    public MapCodec<CoffinSpawner> mapCodec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)CoffinSpawnerConfig.CODEC.optionalFieldOf("normal_config", (Object)CoffinSpawnerConfig.DEFAULT).forGetter(CoffinSpawner::getNormalConfig), (App)CoffinSpawnerConfig.CODEC.optionalFieldOf("irritated_config", (Object)CoffinSpawnerConfig.IRRITATED).forGetter(CoffinSpawner::getIrritatedConfig), (App)CoffinSpawnerConfig.CODEC.optionalFieldOf("aggressive_config", (Object)CoffinSpawnerConfig.AGGRESSIVE).forGetter(CoffinSpawner::getAggressiveConfig), (App)CoffinSpawnerConfig.CODEC.optionalFieldOf("ominous_config", (Object)CoffinSpawnerConfig.AGGRESSIVE).forGetter(CoffinSpawner::getOminousConfig), (App)CoffinSpawnerData.MAP_CODEC.forGetter(CoffinSpawner::getData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("power_cooldown_length", (Object)12000).forGetter(CoffinSpawner::getPowerCooldownLength), (App)Codec.intRange((int)1, (int)48).optionalFieldOf("required_player_range", (Object)48).forGetter(CoffinSpawner::getRequiredPlayerRange), (App)Codec.STRING.optionalFieldOf("uuid", (Object)UUID.randomUUID().toString()).forGetter(CoffinSpawner::getStringUUID), (App)Codec.BOOL.optionalFieldOf("attempting_to_spawn_mob", (Object)false).forGetter(CoffinSpawner::isAttemptingToSpawnMob)).apply((Applicative)instance, (config, config2, config3, config4, data, powerCooldownLength, integer, uuid, attemptingSpawn) -> new CoffinSpawner((CoffinSpawnerConfig)config, (CoffinSpawnerConfig)config2, (CoffinSpawnerConfig)config3, (CoffinSpawnerConfig)config4, (CoffinSpawnerData)data, (int)powerCooldownLength, (int)integer, (String)uuid, (boolean)attemptingSpawn, this.stateAccessor)));
    }

    public CoffinSpawner(StateAccessor coffin) {
        this(CoffinSpawnerConfig.DEFAULT, CoffinSpawnerConfig.IRRITATED, CoffinSpawnerConfig.AGGRESSIVE, CoffinSpawnerConfig.OMINOUS, new CoffinSpawnerData(), 12000, 48, UUID.randomUUID().toString(), false, coffin);
    }

    public CoffinSpawner(CoffinSpawnerConfig normalConfig, CoffinSpawnerConfig irritatedConfig, CoffinSpawnerConfig aggressiveConfig, CoffinSpawnerConfig ominousConfig, CoffinSpawnerData data, int powerCooldownLength, int requiredPlayerRange, String uuid, boolean attemptingToSpawnMob, StateAccessor coffin) {
        this.normalConfig = normalConfig;
        this.irritatedConfig = irritatedConfig;
        this.aggressiveConfig = aggressiveConfig;
        this.ominousConfig = ominousConfig;
        this.data = data;
        this.powerCooldownLength = powerCooldownLength;
        this.requiredPlayerRange = requiredPlayerRange;
        this.uuid = UUID.fromString(uuid);
        this.attemptingToSpawnMob = attemptingToSpawnMob;
        this.stateAccessor = coffin;
    }

    public CoffinSpawnerConfig getConfig() {
        return switch (this.getState()) {
            case CoffinSpawnerState.OMINOUS -> this.ominousConfig;
            case CoffinSpawnerState.AGGRESSIVE -> this.aggressiveConfig;
            case CoffinSpawnerState.IRRITATED -> this.irritatedConfig;
            default -> this.normalConfig;
        };
    }

    @VisibleForTesting
    public CoffinSpawnerConfig getNormalConfig() {
        return this.normalConfig;
    }

    @VisibleForTesting
    public CoffinSpawnerConfig getIrritatedConfig() {
        return this.irritatedConfig;
    }

    @VisibleForTesting
    public CoffinSpawnerConfig getAggressiveConfig() {
        return this.aggressiveConfig;
    }

    @VisibleForTesting
    public CoffinSpawnerConfig getOminousConfig() {
        return this.ominousConfig;
    }

    public void applyOminous(class_3218 world) {
        this.setState((class_1937)world, CoffinSpawnerState.OMINOUS);
    }

    public void removeOminous(class_3218 world) {
        this.setState((class_1937)world, CoffinSpawnerState.getStateForPower(world, this));
    }

    public boolean isOminous() {
        return this.getState() == CoffinSpawnerState.OMINOUS;
    }

    public CoffinSpawnerData getData() {
        return this.data;
    }

    public int getPowerCooldownLength() {
        return this.powerCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.uuid.toString();
    }

    public boolean isAttemptingToSpawnMob() {
        return this.attemptingToSpawnMob;
    }

    public void addPower(int i, @NotNull class_1937 level) {
        this.data.power += i;
        this.data.powerCooldownEndsAt = level.method_8510() + (long)this.powerCooldownLength;
    }

    public void addSoulParticle(int delayUntilSpawn) {
        this.data.soulsToSpawn.add(delayUntilSpawn);
    }

    public CoffinSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(class_1937 level, CoffinSpawnerState state) {
        this.stateAccessor.setState(level, state);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public class_8962 getPlayerDetector() {
        return this.data.withinCatacombs ? IN_CATACOMBS_NO_CREATIVE_PLAYERS : class_8962.field_48860;
    }

    public class_8962.class_9198 getEntitySelector() {
        return ENTITY_SELECTOR;
    }

    public boolean canSpawnInLevel(@NotNull class_3218 level) {
        return level.method_8407() != class_1267.field_5801 && (TTBlockConfig.COFFIN_IGNORE_DOMOBSPAWNING || level.method_64395().method_8355(class_1928.field_19390));
    }

    public Optional<UUID> spawnMob(@NotNull class_3218 level, class_2338 pos) {
        class_5819 randomSource = level.method_8409();
        class_1952 spawnData = this.data.getOrCreateNextSpawnData(level.method_8409());
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(() -> "spawner@" + String.valueOf(pos), LOGGER);){
            Object mob;
            class_1952.class_6542 customSpawnRules;
            class_11368 valueInput = class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)level.method_30349(), (class_2487)spawnData.comp_64());
            Optional optional = class_1299.method_17684((class_11368)valueInput);
            if (optional.isEmpty()) {
                Optional<UUID> optional2 = Optional.empty();
                return optional2;
            }
            class_243 vec3 = valueInput.method_71426("Pos", class_243.field_38277).orElseGet(() -> {
                CoffinSpawnerConfig config = this.getConfig();
                return new class_243((double)pos.method_10263() + (randomSource.method_43058() - randomSource.method_43058()) * (double)config.spawnRange() + 0.5, (double)(pos.method_10264() + randomSource.method_43048(3) - 1), (double)pos.method_10260() + (randomSource.method_43058() - randomSource.method_43058()) * (double)config.spawnRange() + 0.5);
            });
            if (!level.method_18026(((class_1299)optional.get()).method_58629(vec3.field_1352, vec3.field_1351, vec3.field_1350))) {
                Optional<UUID> optional3 = Optional.empty();
                return optional3;
            }
            if (!CoffinSpawner.inLineOfSight((class_1937)level, pos.method_46558(), vec3)) {
                Optional<UUID> optional4 = Optional.empty();
                return optional4;
            }
            class_2338 blockPos = class_2338.method_49638((class_2374)vec3);
            if (!class_1317.method_20638((class_1299)((class_1299)optional.get()), (class_5425)level, (class_3730)class_3730.field_47245, (class_2338)blockPos, (class_5819)level.method_8409())) {
                Optional<UUID> optional5 = Optional.empty();
                return optional5;
            }
            if (spawnData.method_38097().isPresent() && !(customSpawnRules = (class_1952.class_6542)spawnData.method_38097().get()).method_56563(blockPos, level)) {
                Optional<UUID> optional6 = Optional.empty();
                return optional6;
            }
            int lightAtPos = level.method_22335(blockPos, 0);
            int lightToleranceDifference = Math.max(this.data.maxActiveLightLevel, lightAtPos) - this.data.maxActiveLightLevel;
            if (lightToleranceDifference > 0 && randomSource.method_43048(lightToleranceDifference * 25) > 0) {
                Optional<UUID> optional7 = Optional.empty();
                return optional7;
            }
            if (level.method_8320(blockPos).method_26164(TTBlockTags.COFFIN_UNSPAWNABLE_ON)) {
                Optional<UUID> optional8 = Optional.empty();
                return optional8;
            }
            class_1297 entity = class_1299.method_17842((class_11368)valueInput, (class_1937)level, (class_3730)class_3730.field_47245, entityx -> {
                entityx.method_60949(vec3, randomSource.method_43057() * 360.0f, 0.0f);
                return entityx;
            });
            if (entity == null) {
                Optional<UUID> optional9 = Optional.empty();
                return optional9;
            }
            if (entity instanceof class_1308) {
                boolean bl;
                mob = (class_1308)entity;
                if (!mob.method_5957((class_4538)level)) {
                    Optional<UUID> optional10 = Optional.empty();
                    return optional10;
                }
                boolean bl2 = bl = spawnData.method_38093().method_10546() == 1 && spawnData.method_38093().method_10545("id");
                if (bl) {
                    mob.method_5943((class_5425)level, level.method_8404(mob.method_24515()), class_3730.field_47245, null);
                }
                spawnData.method_59717().ifPresent(arg_0 -> ((class_1308)mob).method_58634(arg_0));
            }
            if (!level.method_30736(entity)) {
                mob = Optional.empty();
                return mob;
            }
            level.method_43129(null, entity, TTSounds.COFFIN_SPAWN_MOB, class_3419.field_15245, 1.0f, (randomSource.method_43057() - randomSource.method_43057()) * 0.2f + 1.0f);
            if (entity instanceof class_1308) {
                mob = (class_1308)entity;
                mob.method_5990();
            }
            level.method_33596(entity, (class_6880)class_5712.field_28738, blockPos);
            this.appendCoffinSpawnAttributes(entity, (class_1937)level, pos, false);
            Optional<UUID> optional11 = Optional.of(entity.method_5667());
            return optional11;
        }
    }

    public boolean canSpawnApparition(class_1937 level, class_2338 pos, boolean ignoreChance) {
        CoffinSpawnerData data = this.getData();
        if (!data.isOnCooldown(level) && data.hasPotentialPlayers() && level.method_8510() >= data.nextApparitionSpawnsAt && data.currentApparitions.size() < this.getConfig().maxApparitions()) {
            class_243 vec3 = class_243.method_24953((class_2382)pos);
            Optional<class_1657> optionalPlayer = data.getClosestPotentialPlayer(level, vec3);
            if (ignoreChance) {
                return true;
            }
            if (optionalPlayer.isPresent()) {
                double distance = Math.sqrt(optionalPlayer.get().method_5707(vec3));
                double playerRange = this.getRequiredPlayerRange();
                double chance = playerRange - distance;
                chance = 4.25E-4 / playerRange * chance;
                return level.method_8409().method_43058() < chance;
            }
        }
        return false;
    }

    public void spawnApparition(@NotNull class_3218 level, @NotNull class_2338 pos) {
        Apparition apparition = (Apparition)TTEntityTypes.APPARITION.method_5888(level, null, pos, class_3730.field_47245, true, false);
        if (apparition != null && level.method_8649((class_1297)apparition)) {
            apparition.hiddenTicks = 100;
            this.appendCoffinSpawnAttributes((class_1297)apparition, (class_1937)level, pos, true);
            this.data.nextApparitionSpawnsAt = level.method_8510() + 1000L;
            this.data.currentApparitions.add(apparition.method_5667());
        }
    }

    public void appendCoffinSpawnAttributes(class_1297 entity, class_1937 level, class_2338 pos, boolean usePotentialPlayers) {
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_6127().method_45329(class_5134.field_23717).method_26837(new class_1322(CoffinBlock.ATTRIBUTE_COFFIN_FOLLOW_RANGE, 24.0, class_1322.class_1323.field_6328));
            Optional<class_1657> closestDetectedPlayer = usePotentialPlayers ? this.data.getClosestPotentialPlayer(level, entity.method_73189()) : this.data.getClosestDetectedPlayer(level, entity.method_73189());
            closestDetectedPlayer.ifPresent(arg_0 -> ((class_1308)mob).method_5980(arg_0));
        }
        if (entity instanceof EntityCoffinInterface) {
            EntityCoffinInterface entityInterface = (EntityCoffinInterface)entity;
            entityInterface.trailierTales$setCoffinData(new EntityCoffinData(pos, this.uuid, level.method_8510()));
        }
        if (entity instanceof Apparition) {
            Apparition apparition = (Apparition)entity;
            ApparitionAi.rememberHome(apparition, level, pos);
        }
    }

    public void updateAttemptingToSpawn(@NotNull class_3218 level) {
        boolean isAttempting = this.isAttemptingToSpawnMob(level);
        if (isAttempting != this.attemptingToSpawnMob) {
            this.attemptingToSpawnMob = isAttempting;
            this.markUpdated();
        }
    }

    public boolean isAttemptingToSpawnMob(@NotNull class_3218 level) {
        int additionalPlayers = this.data.countAdditionalPlayers();
        boolean isPreparing = this.data.isPreparingToSpawnNextMob(level, this.getConfig(), additionalPlayers, 45);
        boolean finishedSpawningMobs = this.data.hasFinishedSpawningAllMobs(this.getConfig(), additionalPlayers);
        boolean canSpawnInLevel = this.canSpawnInLevel(level) && this.getState().isCapableOfSpawning();
        return isPreparing && !finishedSpawningMobs && canSpawnInLevel;
    }

    public void tickServer(class_3218 level, class_2338 pos, class_2680 state, CoffinPart part, boolean ominous) {
        class_2338 connectedPos;
        class_2350 connectedDirection;
        if (part == CoffinPart.HEAD) {
            return;
        }
        class_2350 coffinOrientation = CoffinBlock.getCoffinOrientation((class_1922)level, pos);
        if (coffinOrientation != null) {
            this.getState().emitParticles(level, pos, coffinOrientation);
            if (!this.data.soulsToSpawn.isEmpty()) {
                IntArrayList newList = new IntArrayList();
                this.data.soulsToSpawn.forEach(spawnTime -> {
                    if (spawnTime <= 0) {
                        CoffinBlock.spawnParticlesFrom(level, (class_2394)TTParticleTypes.COFFIN_SOUL_ENTER, 4, 0.0, coffinOrientation, pos, 0.35);
                        this.addPower(1, (class_1937)level);
                    } else {
                        newList.add(spawnTime - 1);
                    }
                });
                this.data.soulsToSpawn.clear();
                this.data.soulsToSpawn.addAll((IntList)newList);
            }
        }
        if ((connectedDirection = CoffinBlock.getConnectedDirection(state)) != null && level.method_8477(connectedPos = pos.method_10093(connectedDirection)) && (coffinOrientation == null || !level.method_8320(connectedPos).method_27852((class_2248)TTBlocks.COFFIN))) {
            level.method_22352(pos, false);
            return;
        }
        this.data.currentMobs.removeIf(uiid -> {
            class_1297 entity = level.method_66347(uiid);
            boolean shouldUntrack = CoffinSpawner.shouldMobBeUntracked(level, pos, entity);
            if (shouldUntrack) {
                CoffinBlock.onCoffinUntrack(level, entity, this, false);
            }
            return shouldUntrack;
        });
        this.data.currentApparitions.removeIf(uiid -> {
            class_1297 entity = level.method_66347(uiid);
            boolean shouldUntrack = CoffinSpawner.shouldMobBeUntracked(level, pos, entity);
            if (shouldUntrack) {
                CoffinBlock.onCoffinUntrack(level, entity, this, true);
            }
            return shouldUntrack;
        });
        CoffinSpawnerState currentState = this.getState();
        if (!this.canSpawnInLevel(level)) {
            if (this.getState() != CoffinSpawnerState.COOLDOWN) {
                this.setState((class_1937)level, CoffinSpawnerState.COOLDOWN);
            }
        } else {
            CoffinSpawnerState nextState = currentState.tickAndGetNext(pos, this, state, level);
            if (nextState != currentState) {
                this.setState((class_1937)level, nextState);
            }
        }
        this.updateAttemptingToSpawn(level);
    }

    private static boolean shouldMobBeUntracked(@NotNull class_3218 level, class_2338 pos, UUID uuid) {
        return CoffinSpawner.shouldMobBeUntracked(level, pos, level.method_66347(uuid));
    }

    private static boolean shouldMobBeUntracked(@NotNull class_3218 level, class_2338 pos, class_1297 entity) {
        return entity == null || !entity.method_73183().method_27983().equals(level.method_27983()) || entity.method_24515().method_10262((class_2382)pos) > (double)MAX_MOB_TRACKING_DISTANCE_SQR || entity.method_31481();
    }

    private static boolean inLineOfSight(@NotNull class_1937 level, class_243 spawnerPos, class_243 mobPos) {
        class_3965 blockHitResult = level.method_17742(new class_3959(mobPos, spawnerPos, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, class_3726.method_16194()));
        return !blockHitResult.method_17777().equals((Object)class_2338.method_49638((class_2374)spawnerPos)) && blockHitResult.method_17783() != class_239.class_240.field_1333;
    }

    public static boolean isInCatacombsBounds(class_2338 pos, @NotNull class_5138 structureManager) {
        class_5321<class_3195> structureKey = TTResources.HAS_STRONGHOLD_OVERRIDE_PACK ? class_7058.field_37178 : CatacombsGenerator.CATACOMBS_KEY;
        class_3195 structure = (class_3195)structureManager.method_41036().method_30530(class_7924.field_41246).method_29107(structureKey);
        return structure != null && structureManager.method_41033(pos, structureManager.method_28388(pos, structure));
    }

    public void onApparitionRemovedOrKilled(@NotNull class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.data.nextApparitionSpawnsAt = serverLevel.method_8510() + (long)this.getConfig().ticksBetweenApparitionSpawn();
        }
    }

    public void immediatelyActivate(class_1937 level, class_2338 pos) {
        this.data.immediatelyActivate(level, pos, this);
    }

    public static interface StateAccessor {
        public void setState(class_1937 var1, CoffinSpawnerState var2);

        public CoffinSpawnerState getState();

        public void markUpdated();
    }
}

