/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.trailiertales.particle.options.GlowingDustColorTransitionOptions;
import net.minecraft.class_11944;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5736;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9679;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class GlowingColorTransitionParticle
extends class_5736<GlowingDustColorTransitionOptions> {
    private final Vector3f fromColor;
    private final Vector3f toColor;

    public GlowingColorTransitionParticle(@NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, GlowingDustColorTransitionOptions particleEffect, class_4002 spriteProvider) {
        super(level, x, y, z, xd, yd, zd, (class_9679)particleEffect, spriteProvider);
        float f = this.field_3840.method_43057() * 0.4f + 0.6f;
        this.fromColor = this.randomizeColor(particleEffect.getFromColor(), f);
        this.toColor = this.randomizeColor(particleEffect.getToColor(), f);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    private Vector3f randomizeColor(@NotNull Vector3f color, float factor) {
        return new Vector3f(this.method_33076(color.x(), factor), this.method_33076(color.y(), factor), this.method_33076(color.z(), factor));
    }

    private void lerpColors(float partialTick) {
        float lerp = ((float)this.field_3866 + partialTick) / ((float)this.field_3847 + 1.0f);
        Vector3f vector3f = new Vector3f((Vector3fc)this.fromColor).lerp((Vector3fc)this.toColor, lerp);
        this.field_62633 = vector3f.x();
        this.field_62634 = vector3f.y();
        this.field_62635 = vector3f.z();
    }

    public void method_3074(class_11944 renderState, class_4184 camera, float partialTick) {
        this.lerpColors(partialTick);
        super.method_3074(renderState, camera, partialTick);
    }

    protected int method_3068(float tint) {
        return 240;
    }

    public static class Provider
    implements class_707<GlowingDustColorTransitionOptions> {
        private final class_4002 spriteSet;

        public Provider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        public class_703 createParticle(GlowingDustColorTransitionOptions dustColorTransitionOptions, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new GlowingColorTransitionParticle(level, x, y, z, xd, yd, zd, dustColorTransitionOptions, this.spriteSet);
        }
    }
}

