/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.frozenblock.trailiertales.TTConstants;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinBlockEntity;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawner;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerState;
import net.frozenblock.trailiertales.block.entity.coffin.impl.EntityCoffinInterface;
import net.frozenblock.trailiertales.block.impl.CoffinPart;
import net.frozenblock.trailiertales.block.impl.TTBlockStateProperties;
import net.frozenblock.trailiertales.config.TTBlockConfig;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.networking.packet.CoffinRemoveDebugPacket;
import net.frozenblock.trailiertales.registry.TTBlockEntityTypes;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_5134;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_8959;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffinBlock
extends class_2383
implements class_2343 {
    public static final MapCodec<CoffinBlock> CODEC = RecordCodecBuilder.mapCodec(color -> color.group((App)CoffinBlock.method_54096()).apply((Applicative)color, CoffinBlock::new));
    public static final class_2754<CoffinPart> PART = TTBlockStateProperties.COFFIN_PART;
    public static final class_2754<CoffinSpawnerState> STATE = TTBlockStateProperties.COFFIN_STATE;
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final class_2960 ATTRIBUTE_COFFIN_FOLLOW_RANGE = TTConstants.id("coffin_follow_range");

    @NotNull
    public MapCodec<CoffinBlock> method_53969() {
        return CODEC;
    }

    public CoffinBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)CoffinPart.FOOT))).method_11657(STATE, (Comparable)((Object)CoffinSpawnerState.INACTIVE)));
    }

    @Nullable
    public static class_2350 getCoffinOrientation(@NotNull class_1922 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        return blockState.method_26204() instanceof CoffinBlock ? (class_2350)blockState.method_11654((class_2769)field_11177) : null;
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 state, class_4538 level, class_10225 tickAccess, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction == CoffinBlock.getConnectedDirection((CoffinPart)((Object)state.method_11654(PART)), (class_2350)state.method_11654((class_2769)field_11177))) {
            boolean isThisFoot;
            boolean bl = isThisFoot = state.method_11654(PART) == CoffinPart.FOOT;
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(PART) != state.method_11654(PART) ? (isThisFoot ? state : (class_2680)state.method_11657(STATE, (Comparable)((Object)((CoffinSpawnerState)((Object)neighborState.method_11654(STATE)))))) : class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, level, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    private static class_2350 getConnectedDirection(CoffinPart part, class_2350 direction) {
        return part == CoffinPart.FOOT ? direction : direction.method_10153();
    }

    public static class_2350 getConnectedDirection(@NotNull class_2680 state) {
        return CoffinBlock.getConnectedDirection((CoffinPart)((Object)state.method_11654(PART)), (class_2350)state.method_11654((class_2769)field_11177));
    }

    @NotNull
    public class_2680 method_9576(@NotNull class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        CoffinPart coffinPart;
        if (!level.field_9236 && player.method_7337() && (coffinPart = (CoffinPart)((Object)state.method_11654(PART))) == CoffinPart.FOOT && (blockState = level.method_8320(blockPos = pos.method_10093(CoffinBlock.getConnectedDirection(coffinPart, (class_2350)state.method_11654((class_2769)field_11177))))).method_27852((class_2248)this) && blockState.method_11654(PART) == CoffinPart.HEAD) {
            level.method_8652(blockPos, class_2246.field_10124.method_9564(), 35);
            level.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
        return super.method_9576(level, pos, state, player);
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 context) {
        class_2350 direction = context.method_8042();
        class_2338 blockPos = context.method_8037();
        class_2338 blockPos2 = blockPos.method_10093(direction);
        class_1937 level = context.method_8045();
        return level.method_8320(blockPos2).method_26166(context) && level.method_8621().method_11952(blockPos2) ? (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)direction) : null;
    }

    @NotNull
    protected class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_2350 direction = CoffinBlock.getConnectedDirection(state).method_10153();
        return switch (direction) {
            case class_2350.field_11043 -> SHAPE;
            case class_2350.field_11035 -> SHAPE;
            case class_2350.field_11039 -> SHAPE;
            default -> SHAPE;
        };
    }

    public static class_4732.class_4733 getBlockType(@NotNull class_2680 state) {
        CoffinPart coffinPart = (CoffinPart)((Object)state.method_11654(PART));
        return coffinPart == CoffinPart.HEAD ? class_4732.class_4733.field_21784 : class_4732.class_4733.field_21785;
    }

    @NotNull
    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11177, PART, STATE});
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        if (!level.field_9236) {
            class_2338 blockPos = pos.method_10093((class_2350)state.method_11654((class_2769)field_11177));
            level.method_8652(blockPos, (class_2680)state.method_11657(PART, (Comparable)((Object)CoffinPart.HEAD)), 3);
            level.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)level, pos, 3);
        }
    }

    @NotNull
    protected class_1269 method_55765(@NotNull class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 entity, class_1268 hand, class_3965 hitResult) {
        if (stack.method_7909() instanceof class_1826) {
            return class_1269.field_21466;
        }
        return class_1269.field_52423;
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, @NotNull class_1937 level, class_2338 pos, class_1657 entity, class_3965 hitResult) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CoffinBlockEntity) {
            CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)class_25862;
            if (level.method_8510() - coffinBlockEntity.wobbleStartedAtTick >= 10L && TTBlockConfig.get().coffin.wobble) {
                CoffinBlock.wobble(level, pos, state, entity);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static void wobble(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state, class_1657 player) {
        level.method_8427(pos, state.method_26204(), 1, 0);
        class_2338 neighborPos = pos.method_10093(CoffinBlock.getConnectedDirection(state));
        class_2680 neighborState = level.method_8320(neighborPos);
        if (neighborState.method_27852(state.method_26204())) {
            level.method_8427(neighborPos, state.method_26204(), 1, 0);
        }
        level.method_8396(null, pos, TTSounds.COFFIN_WOBBLE, class_3419.field_15245, 0.5f, 0.9f + level.field_9229.method_43057() * 0.2f);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
    }

    protected boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int type, int data) {
        super.method_9592(state, level, pos, type, data);
        class_2586 blockEntity = level.method_8321(pos);
        return blockEntity != null && blockEntity.method_11004(type, data);
    }

    public boolean isCoffinActive(@NotNull class_2680 state) {
        return ((CoffinSpawnerState)((Object)state.method_11654(STATE))).isCapableOfSpawning();
    }

    protected long method_9535(@NotNull class_2680 state, @NotNull class_2338 pos) {
        class_2338 blockPos = pos.method_10079((class_2350)state.method_11654((class_2769)field_11177), state.method_11654(PART) == CoffinPart.HEAD ? 0 : 1);
        return class_3532.method_15371((int)blockPos.method_10263(), (int)pos.method_10264(), (int)blockPos.method_10260());
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CoffinBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        class_5558 class_55582;
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_55582 = class_2237.method_31618(blockEntityType, TTBlockEntityTypes.COFFIN, (unusedWorld, pos, statex, coffin) -> coffin.tickServer(serverLevel, pos, statex, (CoffinPart)((Object)((Object)statex.method_11654(PART))), statex.method_28500((class_2769)class_2741.field_50193).orElse(false)));
        } else {
            class_55582 = class_2237.method_31618(blockEntityType, TTBlockEntityTypes.COFFIN, (world, pos, statex, coffin) -> coffin.tickClient(world, pos, (CoffinPart)((Object)((Object)statex.method_11654(PART))), statex.method_28500((class_2769)class_2741.field_50193).orElse(false)));
        }
        return class_55582;
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, tooltipContext, tooltip, options);
        class_8959.method_55121((class_1799)stack, tooltip, (String)"SpawnData");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void onCoffinUntrack(class_3218 level, @Nullable class_1297 entity, @Nullable CoffinSpawner coffinSpawner, boolean remove) {
        class_1309 livingEntity;
        class_1324 followRange;
        class_1937 class_19372;
        if (FrozenLibConfig.IS_DEBUG && entity != null && !entity.method_31481() && (class_19372 = entity.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            FrozenNetworking.sendPacketToAllPlayers((class_3218)serverLevel, (class_8710)new CoffinRemoveDebugPacket(entity.method_5628()));
        }
        if (entity != null) {
            entity.method_5783(TTSounds.COFFIN_VANISH_MOB, 0.8f, 0.9f + entity.method_59922().method_43057() * 0.2f);
        }
        if (entity instanceof class_1309 && (followRange = (livingEntity = (class_1309)entity).method_5996(class_5134.field_23717)) != null) {
            followRange.method_6200(ATTRIBUTE_COFFIN_FOLLOW_RANGE);
        }
        if (entity instanceof EntityCoffinInterface) {
            EntityCoffinInterface entityInterface = (EntityCoffinInterface)entity;
            entityInterface.trailierTales$setCoffinData(null);
        }
        if (entity instanceof Apparition) {
            Apparition apparition = (Apparition)entity;
            if (remove) {
                apparition.dropItem();
                apparition.method_37908().method_8421((class_1297)apparition, (byte)60);
                apparition.method_31472();
                apparition.method_60973(level);
                if (coffinSpawner == null) return;
                coffinSpawner.onApparitionRemovedOrKilled(entity.method_37908());
                return;
            }
        }
        if (!remove) return;
        if (!(entity instanceof class_1308)) return;
        class_1308 mob = (class_1308)entity;
        if (mob.method_5947()) return;
        if (mob.method_17326()) return;
        mob.method_37908().method_8421((class_1297)mob, (byte)60);
        mob.method_31472();
    }

    public static void spawnParticlesFrom(@NotNull class_3218 world, class_2394 particleOptions, int count, double speed, @NotNull class_2350 coffinOrientation, @NotNull class_2338 pos, double spread) {
        double relativeX;
        boolean isNegativeDirection = coffinOrientation.method_10171() == class_2350.class_2352.field_11060;
        boolean isOppositeX = isNegativeDirection && coffinOrientation.method_10166() == class_2350.class_2351.field_11048;
        boolean isOppositeZ = isNegativeDirection && coffinOrientation.method_10166() == class_2350.class_2351.field_11051;
        double stepX = coffinOrientation.method_10148();
        double stepZ = coffinOrientation.method_10165();
        double d = isOppositeX ? 0.0 : (relativeX = stepX == 0.0 ? 0.5 : stepX);
        double relativeZ = isOppositeZ ? 0.0 : (stepZ == 0.0 ? 0.5 : stepZ);
        double xOffset = Math.max(0.5, Math.abs(stepX)) * spread;
        double zOffset = Math.max(0.5, Math.abs(stepZ)) * spread;
        world.method_14199(particleOptions, (double)pos.method_10263() + relativeX, (double)pos.method_10264() + 0.95, (double)pos.method_10260() + relativeZ, count, xOffset, 0.0, zOffset, speed);
    }

    @NotNull
    public static class_243 getCenter(@NotNull class_2680 state, @NotNull class_2338 pos) {
        double relativeX;
        class_2350 coffinOrientation = (class_2350)state.method_11654((class_2769)field_11177);
        boolean isNegativeDirection = coffinOrientation.method_10171() == class_2350.class_2352.field_11060;
        boolean isOppositeX = isNegativeDirection && coffinOrientation.method_10166() == class_2350.class_2351.field_11048;
        boolean isOppositeZ = isNegativeDirection && coffinOrientation.method_10166() == class_2350.class_2351.field_11051;
        double stepX = coffinOrientation.method_10148();
        double stepZ = coffinOrientation.method_10165();
        double d = isOppositeX ? 0.0 : (relativeX = stepX == 0.0 ? 0.5 : stepX);
        double relativeZ = isOppositeZ ? 0.0 : (stepZ == 0.0 ? 0.5 : stepZ);
        return new class_243((double)pos.method_10263() + relativeX, (double)pos.method_10264() + 0.95, (double)pos.method_10260() + relativeZ);
    }
}

