/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block.entity.coffin;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawner;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerState;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinWobbleEvent;
import net.frozenblock.trailiertales.block.impl.CoffinPart;
import net.frozenblock.trailiertales.block.impl.TTBlockStateProperties;
import net.frozenblock.trailiertales.registry.TTBlockEntityTypes;
import net.frozenblock.trailiertales.registry.TTParticleTypes;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8959;
import net.minecraft.class_8962;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CoffinBlockEntity
extends class_2621
implements class_8959,
CoffinSpawner.StateAccessor {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float WOBBLE_DURATION = 15.0f;
    public static final int WOBBLE_COOLDOWN = 10;
    private class_2371<class_1799> items = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
    private CoffinSpawner coffinSpawner;
    private float previousOpenProgress;
    private float openProgress;
    public long wobbleStartedAtTick;
    public int coffinWobbleLidAnimTicks;

    public CoffinBlockEntity(class_2338 pos, class_2680 state) {
        super(TTBlockEntityTypes.COFFIN, pos, state);
        class_8962.class_9198 entitySelector = class_8962.class_9198.field_48862;
        this.coffinSpawner = new CoffinSpawner(this, entitySelector);
    }

    public float getOpenProgress(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.previousOpenProgress, (float)this.openProgress);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 lookupProvider) {
        super.method_11014(nbt, lookupProvider);
        if (nbt.method_10545("normal_config")) {
            class_2487 compoundTag = nbt.method_10562("normal_config").method_10553();
            nbt.method_10566("ominous_config", (class_2520)compoundTag.method_10543(nbt.method_10562("ominous_config")));
        }
        if (this.method_11010().method_11654(TTBlockStateProperties.COFFIN_PART) == CoffinPart.FOOT) {
            this.coffinSpawner.codec().parse((DynamicOps)class_2509.field_11560, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(coffinSpawner -> {
                this.coffinSpawner = coffinSpawner;
            });
            this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
            if (!this.method_54871(nbt)) {
                class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)lookupProvider);
            }
        }
        this.coffinWobbleLidAnimTicks = nbt.method_10550("coffin_wobble_lid_anim_ticks");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookupProvider) {
        super.method_11007(nbt, lookupProvider);
        if (this.method_11010().method_11654(TTBlockStateProperties.COFFIN_PART) == CoffinPart.FOOT) {
            this.coffinSpawner.codec().encodeStart((DynamicOps)class_2509.field_11560, (Object)this.coffinSpawner).ifSuccess(logicNbt -> nbt.method_10543((class_2487)logicNbt)).ifError(error -> LOGGER.warn("Failed to encode CoffinSpawner {}", (Object)error.message()));
            if (!this.method_54872(nbt)) {
                class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)lookupProvider);
            }
        }
        nbt.method_10569("coffin_wobble_lid_anim_ticks", this.coffinWobbleLidAnimTicks);
    }

    public boolean method_17489(@NotNull class_1657 player) {
        return false;
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.coffin");
    }

    @NotNull
    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> nonNullList) {
        this.items = nonNullList;
    }

    @NotNull
    protected class_1703 method_5465(int i, class_1661 inventory) {
        return class_1707.method_19245((int)i, (class_1661)inventory, (class_1263)this);
    }

    public int method_5439() {
        return 54;
    }

    public void method_54873(@Nullable class_1657 player) {
        if (this.method_11010().method_11654(TTBlockStateProperties.COFFIN_PART) == CoffinPart.HEAD) {
            this.method_11285(null);
            return;
        }
        super.method_54873(player);
    }

    public void tickServer(class_3218 world, class_2338 pos, class_2680 state, CoffinPart part, boolean ominous) {
        if (part == CoffinPart.HEAD || world.field_9236) {
            return;
        }
        this.coffinSpawner.tickServer(world, pos, state, (CoffinPart)((Object)state.method_11654(CoffinBlock.PART)), ominous);
        this.coffinWobbleLidAnimTicks = Math.max(0, this.coffinWobbleLidAnimTicks - 1);
    }

    public void tickClient(class_1937 world, class_2338 pos, CoffinPart part, boolean ominous) {
        class_2586 class_25862;
        class_2338 connectedPos;
        class_5819 randomSource;
        if (part == CoffinPart.HEAD || !world.field_9236) {
            return;
        }
        this.coffinWobbleLidAnimTicks = Math.max(0, this.coffinWobbleLidAnimTicks - 1);
        CoffinSpawnerState coffinSpawnerState = this.getState();
        if (coffinSpawnerState.isCapableOfSpawning() && (randomSource = world.method_8409()).method_43057() <= 0.0175f) {
            world.method_45446(pos, TTSounds.COFFIN_AMBIENT, class_3419.field_15245, randomSource.method_43057() * 0.15f + 0.05f, randomSource.method_43057() + 0.5f, false);
        }
        this.previousOpenProgress = this.openProgress;
        this.openProgress = class_3532.method_15363((float)(this.openProgress + this.getLidOpenIncrement()), (float)0.0f, (float)1.0f);
        class_2350 connectedDirection = CoffinBlock.getConnectedDirection(this.method_11010());
        if (connectedDirection != null && world.method_8477(connectedPos = pos.method_10093(connectedDirection)) && (class_25862 = world.method_8321(connectedPos)) instanceof CoffinBlockEntity) {
            CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)class_25862;
            coffinBlockEntity.previousOpenProgress = this.previousOpenProgress;
            coffinBlockEntity.openProgress = this.openProgress;
        }
    }

    private float getLidOpenIncrement() {
        if (this.coffinWobbleLidAnimTicks > 0) {
            return 0.03f;
        }
        return this.coffinSpawner.isAttemptingToSpawnMob() ? 0.0155f : -0.03f;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10556("attempting_to_spawn_mob", this.coffinSpawner.isAttemptingToSpawnMob());
        compoundTag.method_10569("coffin_wobble_lid_anim_ticks", this.coffinWobbleLidAnimTicks);
        return compoundTag;
    }

    public boolean method_11011() {
        return true;
    }

    public void method_46408(class_1299<?> entityType, class_5819 random) {
        class_1937 class_19372;
        class_2586 class_25862;
        class_2338 pos = this.method_11016();
        CoffinSpawner coffinSpawner = this.getCoffinSpawner();
        class_2680 state = this.method_11010();
        if (this.method_11010().method_11654(CoffinBlock.PART) == CoffinPart.HEAD && (class_25862 = this.field_11863.method_8321(pos = pos.method_10093(CoffinBlock.getConnectedDirection(state)))) instanceof CoffinBlockEntity) {
            CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)class_25862;
            coffinSpawner = coffinBlockEntity.getCoffinSpawner();
        }
        coffinSpawner.getData().setEntityId(entityType, random);
        class_2350 coffinOrientation = CoffinBlock.getCoffinOrientation((class_1922)this.field_11863, pos);
        if (coffinOrientation != null && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 finalPos = pos;
            CoffinSpawnerState.ACTIVE.getParticleOptionsForState().ifPresent(particleOptions -> CoffinBlock.spawnParticlesFrom(serverLevel, particleOptions, this.field_11863.field_9229.method_43051(1, 5), 0.5, coffinOrientation, finalPos, 0.5));
            CoffinBlock.spawnParticlesFrom(serverLevel, (class_2394)TTParticleTypes.COFFIN_SOUL_ENTER, this.field_11863.field_9229.method_43051(1, 2), 0.0, coffinOrientation, finalPos, 0.5);
        }
        this.method_5431();
    }

    public CoffinSpawner getCoffinSpawner() {
        return this.coffinSpawner;
    }

    @Override
    public CoffinSpawnerState getState() {
        return !this.method_11010().method_28498(TTBlockStateProperties.COFFIN_STATE) ? CoffinSpawnerState.COOLDOWN : (CoffinSpawnerState)((Object)this.method_11010().method_11654(TTBlockStateProperties.COFFIN_STATE));
    }

    @Override
    public void setState(@NotNull class_1937 level, CoffinSpawnerState state) {
        this.method_5431();
        level.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(TTBlockStateProperties.COFFIN_STATE, (Comparable)((Object)state)));
    }

    @Override
    public void markUpdated() {
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean method_11004(int type, int data) {
        if (this.field_11863 != null && type == 1) {
            this.wobbleStartedAtTick = this.field_11863.method_8510();
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                if (this.method_11010().method_11654(CoffinBlock.PART) == CoffinPart.FOOT && this.coffinSpawner.getData().hasMobToSpawnAndIsntOnCooldown(this.field_11863, this.field_11863.field_9229)) {
                    CoffinWobbleEvent.onWobble(serverLevel, this.field_11867, this.method_11010(), this, this.field_11863.field_9229);
                }
            }
            return true;
        }
        return super.method_11004(type, data);
    }
}

