/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block.entity.coffin;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinBlockEntity;
import net.frozenblock.trailiertales.config.TTBlockConfig;
import net.frozenblock.trailiertales.registry.TTMobEffects;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_9334;
import net.minecraft.class_9463;
import org.jetbrains.annotations.NotNull;

public enum CoffinWobbleEvent {
    EJECT_LOOT(1.0f, true, (coffinBlockEntity, blockState) -> !coffinBlockEntity.method_5442() && TTBlockConfig.get().coffin.wobble_loot),
    ACTIVATE(0.2f, false, (coffinBlockEntity, blockState) -> TTBlockConfig.get().coffin.wobble_activate),
    POTION(0.1f, true, (coffinBlockEntity, blockState) -> TTBlockConfig.get().coffin.wobble_potion),
    EXPERIENCE_BOTTLE(0.1f, true, (coffinBlockEntity, blockState) -> TTBlockConfig.get().coffin.wobble_experience_bottle);

    private static final class_6005<class_1293> MOB_EFFECTS;
    private static final class_243 DEFAULT_SHOOT_ANGLE;
    private static final float DEFAULT_SHOOT_SPEED = 0.45f;
    private static final float PLAYER_SHOOT_SPEED = 1.0f;
    private final float chance;
    private final boolean playsLidAnim;
    private final BiFunction<CoffinBlockEntity, class_2680, Boolean> extraConditions;

    private CoffinWobbleEvent(float chance, boolean playsLidAnim, BiFunction<CoffinBlockEntity, class_2680, Boolean> extraConditions) {
        this.chance = chance;
        this.playsLidAnim = playsLidAnim;
        this.extraConditions = extraConditions;
    }

    public float getChance() {
        return this.chance;
    }

    public boolean playsLidAnim() {
        return this.playsLidAnim;
    }

    public boolean checkExtraConditions(CoffinBlockEntity coffinBlockEntity, class_2680 blockState) {
        return this.extraConditions.apply(coffinBlockEntity, blockState);
    }

    public static void onWobble(class_3218 level, class_2338 pos, class_2680 state, CoffinBlockEntity coffinBlockEntity, class_5819 random) {
        CoffinWobbleEvent event = (CoffinWobbleEvent)((Object)class_156.method_27173((Object[])CoffinWobbleEvent.values(), (class_5819)random));
        if (random.method_43057() <= event.getChance() && event.checkExtraConditions(coffinBlockEntity, state)) {
            class_243 centerPos = CoffinBlock.getCenter(state, pos);
            switch (event.ordinal()) {
                case 0: {
                    CoffinWobbleEvent.ejectRandomItem(level, centerPos, coffinBlockEntity);
                    break;
                }
                case 1: {
                    coffinBlockEntity.getCoffinSpawner().immediatelyActivate((class_1937)level, pos);
                    break;
                }
                case 2: {
                    CoffinWobbleEvent.ejectProjectile(level, centerPos, CoffinWobbleEvent.createItemStackForMobEffect(class_1802.field_8150, (class_1293)MOB_EFFECTS.method_34973(random).orElseThrow()), coffinBlockEntity);
                    break;
                }
                case 3: {
                    CoffinWobbleEvent.ejectProjectile(level, centerPos, new class_1799((class_1935)class_1802.field_8287), coffinBlockEntity);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + event.name());
                }
            }
            if (event.playsLidAnim()) {
                coffinBlockEntity.coffinWobbleLidAnimTicks = 4;
                class_2350 coffinOrientation = CoffinBlock.getCoffinOrientation((class_1922)level, pos);
                if (coffinOrientation != null) {
                    CoffinBlock.spawnParticlesFrom(level, (class_2394)class_2398.field_46763, level.field_9229.method_43051(8, 14), 0.02, coffinOrientation, pos, 0.375);
                }
            }
            coffinBlockEntity.markUpdated();
        } else if (random.method_43056()) {
            CoffinWobbleEvent.onWobble(level, pos, state, coffinBlockEntity, random);
        }
    }

    private static void ejectRandomItem(@NotNull class_3218 serverLevel, class_243 centerPos, @NotNull CoffinBlockEntity coffinBlockEntity) {
        coffinBlockEntity.method_54873(null);
        for (class_1799 coffinStack : class_156.method_43253((Object[])((class_1799[])coffinBlockEntity.method_11282().toArray((Object[])new class_1799[0])), (class_5819)serverLevel.field_9229)) {
            if (coffinStack.method_7960()) continue;
            class_1799 splitStack = coffinStack.method_7971(1);
            class_1542 itemEntity = new class_1542((class_1937)serverLevel, centerPos.field_1352, centerPos.field_1351, centerPos.field_1350, splitStack);
            serverLevel.method_8649((class_1297)itemEntity);
            return;
        }
    }

    @NotNull
    public static class_1799 createItemStackForMobEffect(class_1792 item, class_1293 effect) {
        class_1799 itemStack = new class_1799((class_1935)item);
        itemStack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), List.of(effect), Optional.empty()));
        return itemStack;
    }

    private static void ejectProjectile(@NotNull class_3218 serverLevel, class_243 centerPos, @NotNull class_1799 stack, CoffinBlockEntity coffinBlockEntity) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_9463) {
            class_9463 projectileItem = (class_9463)class_17922;
            class_1676 projectile = projectileItem.method_58648((class_1937)serverLevel, (class_2374)centerPos, stack, class_2350.field_11036);
            class_243 shootAngle = DEFAULT_SHOOT_ANGLE;
            float shootSpeed = 0.45f;
            Optional<class_1657> closestPlayer = coffinBlockEntity.getCoffinSpawner().getData().getClosestPotentialPlayer((class_1937)serverLevel, centerPos);
            if (closestPlayer.isPresent()) {
                shootAngle = closestPlayer.get().method_33571().method_1031(0.0, 0.1, 0.0).method_1020(centerPos);
                shootSpeed = 1.0f;
            }
            projectileItem.method_58654(projectile, shootAngle.field_1352, Math.max((double)0.1f, shootAngle.field_1351), shootAngle.field_1350, shootSpeed, 0.0f);
            serverLevel.method_8649((class_1297)projectile);
            return;
        }
        if (FrozenLibConstants.UNSTABLE_LOGGING) {
            throw new IllegalStateException("Projectile item stack is not an instance of ProjectileItem!");
        }
    }

    static {
        MOB_EFFECTS = class_6005.method_34971().method_34975((Object)new class_1293(class_1294.field_5901, 2400), 2).method_34975((Object)new class_1293(class_1294.field_5899, 600), 1).method_34975((Object)new class_1293(TTMobEffects.TRANSFIGURING, 1200), 2).method_34974();
        DEFAULT_SHOOT_ANGLE = new class_243(0.0, 1.0, 0.0);
    }
}

