/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.client.renderer.blockentity;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinBlockEntity;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerState;
import net.frozenblock.trailiertales.block.impl.CoffinPart;
import net.frozenblock.trailiertales.client.TTModelLayers;
import net.frozenblock.trailiertales.registry.TTBlockEntityTypes;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CoffinRenderer
implements class_827<CoffinBlockEntity> {
    private static final String BASE = "base";
    private static final String LID = "lid";
    private final class_630 headRoot;
    private final class_630 headBase;
    private final class_630 headLid;
    private final class_630 footRoot;
    private final class_630 footBase;
    private final class_630 footLid;

    public CoffinRenderer(@NotNull class_5614.class_5615 context) {
        this.headRoot = context.method_32140(TTModelLayers.COFFIN_HEAD);
        this.headBase = this.headRoot.method_32086(BASE);
        this.headLid = this.headRoot.method_32086(LID);
        this.footRoot = context.method_32140(TTModelLayers.COFFIN_FOOT);
        this.footBase = this.footRoot.method_32086(BASE);
        this.footLid = this.footRoot.method_32086(LID);
    }

    @NotNull
    public static class_5607 createHeadLayer() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117(BASE, class_5606.method_32108().method_32101(0, 18).method_32097(0.0f, 0.0f, 0.0f, 16.0f, 12.0f, 16.0f), class_5603.field_27701);
        modelPartData.method_32117(LID, class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 16.0f, 2.0f, 16.0f), class_5603.method_32090((float)0.0f, (float)12.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }

    @NotNull
    public static class_5607 createFootLayer() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117(BASE, class_5606.method_32108().method_32101(0, 18).method_32097(0.0f, 0.0f, 0.0f, 16.0f, 12.0f, 16.0f), class_5603.field_27701);
        modelPartData.method_32117(LID, class_5606.method_32108().method_32101(0, 0).method_32097(0.0f, 0.0f, 0.0f, 16.0f, 2.0f, 16.0f), class_5603.method_32090((float)0.0f, (float)12.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }

    @NotNull
    public static class_2960 getCoffinTexture(@NotNull CoffinPart part, CoffinSpawnerState state, boolean ominous) {
        return part == CoffinPart.HEAD ? state.getHeadTexture() : state.getFootTexture();
    }

    public void render(@NotNull CoffinBlockEntity blockEntity, float partialTick, @NotNull class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        class_1937 level = blockEntity.method_10997();
        poseStack.method_22903();
        if (level != null) {
            float openProg = blockEntity.getOpenProgress(partialTick);
            openProg = 1.0f - openProg;
            openProg = 1.0f - openProg * openProg * openProg;
            class_2680 blockState = blockEntity.method_11010();
            class_4732.class_4734 neighborCombineResult = class_4732.method_24173(TTBlockEntityTypes.COFFIN, CoffinBlock::getBlockType, CoffinBlock::getConnectedDirection, (class_2769)CoffinBlock.field_11177, (class_2680)blockState, (class_1936)level, (class_2338)blockEntity.method_11016(), (world, pos) -> false);
            int i = ((Int2IntFunction)neighborCombineResult.apply((class_4732.class_3923)new class_4737())).get(packedLight);
            CoffinPart part = (CoffinPart)((Object)blockState.method_11654(CoffinBlock.PART));
            CoffinSpawnerState coffinSpawnerState = (CoffinSpawnerState)((Object)blockState.method_11654(CoffinBlock.STATE));
            float f = ((class_2350)blockState.method_11654((class_2769)CoffinBlock.field_11177)).method_10144();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-f));
            poseStack.method_22904(-0.5, -0.5, -0.5);
            float wobbleProgress = ((float)(level.method_8510() - blockEntity.wobbleStartedAtTick) + partialTick) / 15.0f;
            if (wobbleProgress >= 0.0f && wobbleProgress <= 1.0f) {
                float coffinWobble = wobbleProgress * (float)Math.PI * 2.5f;
                float wobbleDampen = 1.0f - wobbleProgress;
                float wobble = -3.0f * class_3532.method_15362((float)coffinWobble) * class_3532.method_15374((float)coffinWobble) * wobbleDampen;
                poseStack.method_49278(class_7833.field_40718.rotation(wobble * 0.015625f), 0.5f, 0.0f, 0.5f);
                float lidWobble = (wobbleProgress + 0.16666667f) * (float)Math.PI * 2.5f;
                openProg += Math.max(0.0f, class_3532.method_15362((float)lidWobble) * -0.25f * (class_3532.method_15374((float)lidWobble) * -0.25f)) * wobbleDampen;
            }
            this.renderPiece(poseStack, buffer, part == CoffinPart.HEAD ? this.headRoot : this.footRoot, part == CoffinPart.HEAD ? this.headLid : this.footLid, CoffinRenderer.getCoffinTexture(part, coffinSpawnerState, false), null, openProg, i, packedOverlay, false);
        } else {
            float f = class_2350.field_11035.method_10144();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-f));
            poseStack.method_22904(-0.5, -0.5, -0.5);
            this.renderPiece(poseStack, buffer, this.headRoot, this.headLid, CoffinSpawnerState.ACTIVE.getHeadTexture(), null, 0.0f, packedLight, packedOverlay, false);
            this.renderPiece(poseStack, buffer, this.footRoot, this.footLid, CoffinSpawnerState.ACTIVE.getFootTexture(), null, 0.0f, packedLight, packedOverlay, true);
        }
        poseStack.method_22909();
    }

    private void renderPiece(@NotNull class_4587 poseStack, class_4597 bufferSource, @NotNull class_630 modelPart, @NotNull class_630 lid, @NotNull class_2960 texture, @Nullable class_2960 glowingTexture, float openProgress, int packedLight, int packedOverlay, boolean foot) {
        if (foot) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, -1.0f);
        }
        lid.field_3674 = openProgress * 1.5707964f;
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23576((class_2960)texture));
        modelPart.method_22698(poseStack, vertexConsumer, packedLight, packedOverlay);
        if (glowingTexture != null) {
            class_4588 glowingConsumer = bufferSource.getBuffer(class_1921.method_23026((class_2960)glowingTexture));
            modelPart.method_22698(poseStack, glowingConsumer, packedLight, packedOverlay);
        }
        if (foot) {
            poseStack.method_22909();
        }
    }
}

