/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.client.renderer.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.trailiertales.TTConstants;
import net.frozenblock.trailiertales.client.TTModelLayers;
import net.frozenblock.trailiertales.client.model.ApparitionModel;
import net.frozenblock.trailiertales.client.renderer.entity.layers.ApparitionOverlayLayer;
import net.frozenblock.trailiertales.client.renderer.entity.state.ApparitionRenderState;
import net.frozenblock.trailiertales.entity.Apparition;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ApparitionRenderer
extends class_927<Apparition, ApparitionRenderState, ApparitionModel> {
    private final class_918 itemRenderer;
    private float itemYaw;
    private static final class_2960 TEXTURE = TTConstants.id("textures/entity/apparition/apparition.png");
    private static final class_2960 HYPNOTIZING_TEXTURE = TTConstants.id("textures/entity/apparition/apparition_hypnotizing.png");
    private static final class_2960 SHOOTING_TEXTURE = TTConstants.id("textures/entity/apparition/apparition_shooting.png");

    public ApparitionRenderer(class_5617.class_5618 context) {
        super(context, (class_583)new ApparitionModel(context.method_32167(TTModelLayers.APPARITION)), 0.5f);
        this.method_4046(new ApparitionOverlayLayer(context, (class_3883<ApparitionRenderState, ApparitionModel>)this, renderState -> renderState.innerTransparency, renderState -> renderState.outerTransparency, ApparitionModel::getInnerParts, TEXTURE, false));
        this.addLayers(context, renderState -> renderState.aidAnimProgress * 0.8f, HYPNOTIZING_TEXTURE);
        this.addLayers(context, renderState -> renderState.poltergeistAnimProgress * 0.8f, SHOOTING_TEXTURE);
        this.itemRenderer = context.method_32168();
    }

    private void addLayers(class_5617.class_5618 context, ApparitionModel.AlphaFunction<ApparitionRenderState> innerFunction, ApparitionModel.AlphaFunction<ApparitionRenderState> outerFunction, class_2960 textureLocation) {
        this.method_4046(new ApparitionOverlayLayer(context, (class_3883<ApparitionRenderState, ApparitionModel>)this, innerFunction, outerFunction, ApparitionModel::getOuterParts, textureLocation, true));
        this.method_4046(new ApparitionOverlayLayer(context, (class_3883<ApparitionRenderState, ApparitionModel>)this, innerFunction, outerFunction, ApparitionModel::getInnerParts, textureLocation, false));
    }

    private void addLayers(class_5617.class_5618 context, ApparitionModel.AlphaFunction<ApparitionRenderState> alphaFunction, class_2960 textureLocation) {
        this.addLayers(context, alphaFunction, alphaFunction, textureLocation);
    }

    public void render(@NotNull ApparitionRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int packedLight) {
        super.method_4054((class_10042)renderState, poseStack, buffer, packedLight);
        class_1799 stack = renderState.visibleItem;
        if (!stack.method_7960()) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.425f, 0.0f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - this.itemYaw));
            poseStack.method_22907(class_7833.field_40715.rotation(renderState.itemYRot));
            poseStack.method_22907(class_7833.field_40717.rotation(renderState.itemZRot));
            this.itemRenderer.method_23178(stack, class_811.field_4318, packedLight, class_4608.field_21444, poseStack, buffer, null, 1);
            poseStack.method_22909();
        }
    }

    protected void setupRotations(ApparitionRenderState renderState, class_4587 matrices, float bodyYaw, float scale) {
        super.method_4058((class_10042)renderState, matrices, bodyYaw, scale);
        this.itemYaw = bodyYaw;
        this.field_4672 = renderState.totalTransparency;
    }

    @NotNull
    public class_2960 getTextureLocation(ApparitionRenderState renderState) {
        return TEXTURE;
    }

    protected int getBlockLightLevel(Apparition entity, class_2338 pos) {
        return 15;
    }

    @NotNull
    public ApparitionRenderState createRenderState() {
        return new ApparitionRenderState();
    }

    public void extractRenderState(Apparition apparition, ApparitionRenderState renderState, float partialTick) {
        super.method_62355((class_1309)apparition, (class_10042)renderState, partialTick);
        renderState.itemYRot = apparition.getItemYRot(partialTick);
        renderState.itemZRot = apparition.getItemZRot(partialTick);
        renderState.totalTransparency = apparition.totalTransparency(partialTick);
        renderState.innerTransparency = apparition.getInnerTransparency(partialTick);
        renderState.outerTransparency = apparition.getOuterTransparency(partialTick);
        renderState.flicker = apparition.getFlicker(partialTick);
        renderState.visibleItem = apparition.getVisibleItem();
        renderState.aidAnimProgress = apparition.getAidAnimProgress(partialTick);
        renderState.poltergeistAnimProgress = apparition.getPoltergeistAnimProgress(partialTick);
    }
}

