/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.datagen.model;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.frozenblock.trailiertales.TTConstants;
import net.frozenblock.trailiertales.block.DawntrailBlock;
import net.frozenblock.trailiertales.block.DawntrailCropBlock;
import net.frozenblock.trailiertales.block.EctoplasmBlock;
import net.frozenblock.trailiertales.block.ManedropCropBlock;
import net.frozenblock.trailiertales.datagen.TTDataGenerator;
import net.frozenblock.trailiertales.registry.TTBlocks;
import net.frozenblock.trailiertales.registry.TTItems;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2756;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5793;
import org.jetbrains.annotations.NotNull;

public final class TTModelProvider
extends FabricModelProvider {
    public static final List<Pair<class_2746, Function<class_2960, class_4935>>> MULTIFACE_GENERATOR_NO_UV_LOCK = List.of(Pair.of((Object)class_2741.field_12489, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model)), Pair.of((Object)class_2741.field_12487, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)), Pair.of((Object)class_2741.field_12540, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)), Pair.of((Object)class_2741.field_12527, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)), Pair.of((Object)class_2741.field_12519, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893)), Pair.of((Object)class_2741.field_12546, resourceLocation -> class_4935.method_25824().method_25828(class_4936.field_22887, resourceLocation).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)));

    public TTModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(@NotNull class_4910 generator) {
        generator.method_25545(TTBlocks.CYAN_ROSE, TTBlocks.POTTED_CYAN_ROSE, class_4910.class_4913.field_22840);
        TTModelProvider.createManedropCrop(generator);
        generator.method_25621(TTBlocks.MANEDROP, class_4910.class_4913.field_22840);
        TTModelProvider.createDawntrailCrop(generator);
        TTModelProvider.createDawntrail(generator);
        generator.method_49377(TTBlocks.SUSPICIOUS_RED_SAND);
        generator.method_49377(TTBlocks.SUSPICIOUS_DIRT);
        generator.method_49377(TTBlocks.SUSPICIOUS_CLAY);
        TTModelProvider.createEctoplasmBlock(generator);
        generator.method_25650(class_2246.field_10289).method_33522(class_5793.field_28482);
        generator.method_25650(TTBlocks.GRANITE_BRICKS).method_33522(TTBlocks.FAMILY_GRANITE_BRICK);
        generator.method_25650(TTBlocks.MOSSY_GRANITE_BRICKS).method_33522(TTBlocks.FAMILY_MOSSY_GRANITE_BRICK);
        generator.method_25650(class_2246.field_10346).method_33522(class_5793.field_28480);
        generator.method_25650(TTBlocks.DIORITE_BRICKS).method_33522(TTBlocks.FAMILY_DIORITE_BRICK);
        generator.method_25650(TTBlocks.MOSSY_DIORITE_BRICKS).method_33522(TTBlocks.FAMILY_MOSSY_DIORITE_BRICK);
        generator.method_25650(class_2246.field_10093).method_33522(class_5793.field_28509);
        generator.method_25650(TTBlocks.ANDESITE_BRICKS).method_33522(TTBlocks.FAMILY_ANDESITE_BRICK);
        generator.method_25650(TTBlocks.MOSSY_ANDESITE_BRICKS).method_33522(TTBlocks.FAMILY_MOSSY_ANDESITE_BRICK);
        class_4910.class_4912 calciteFamily = generator.method_25650(class_2246.field_27114);
        calciteFamily.field_47134.add(class_2246.field_27114);
        calciteFamily.method_33522(TTDataGenerator.FAMILY_CALCITE);
        generator.method_25650(TTBlocks.POLISHED_CALCITE).method_33522(TTBlocks.FAMILY_POLISHED_CALCITE);
        class_4910.class_4912 calciteBricksFamily = generator.method_25650(TTBlocks.CALCITE_BRICKS);
        calciteBricksFamily.field_47134.add(TTBlocks.CHISELED_CALCITE_BRICKS);
        calciteBricksFamily.method_33522(TTBlocks.FAMILY_CALCITE_BRICK);
        generator.method_25650(TTBlocks.MOSSY_CALCITE_BRICKS).method_33522(TTBlocks.FAMILY_MOSSY_CALCITE_BRICK);
        generator.method_25622(TTBlocks.CHISELED_CALCITE_BRICKS, class_4946.field_23959);
        generator.method_25641(TTBlocks.CRACKED_TUFF_BRICKS);
        generator.method_25650(TTBlocks.MOSSY_TUFF_BRICKS).method_33522(TTBlocks.FAMILY_MOSSY_TUFF_BRICKS);
        generator.method_25641(TTBlocks.CRACKED_BRICKS);
        generator.method_25650(TTBlocks.MOSSY_BRICKS).method_33522(TTBlocks.FAMILY_MOSSY_BRICKS);
        generator.method_25650(TTBlocks.MOSSY_COBBLED_DEEPSLATE).method_33522(TTBlocks.FAMILY_MOSSY_COBBLED_DEEPSLATE);
        generator.method_25650(TTBlocks.MOSSY_DEEPSLATE_BRICKS).method_33522(TTBlocks.FAMILY_MOSSY_DEEPSLATE_BRICKS);
        generator.method_25650(TTBlocks.MOSSY_DEEPSLATE_TILES).method_33522(TTBlocks.FAMILY_MOSSY_DEEPSLATE_TILES);
        this.wallSmooth(generator, TTBlocks.SMOOTH_SANDSTONE_WALL, class_2246.field_9979);
        this.stairsCut(generator, TTBlocks.CUT_SANDSTONE_STAIRS, class_2246.field_10361, class_2246.field_9979);
        this.wall(generator, TTBlocks.CUT_SANDSTONE_WALL, class_2246.field_10361);
        this.wallSmooth(generator, TTBlocks.SMOOTH_RED_SANDSTONE_WALL, class_2246.field_10344);
        this.stairsCut(generator, TTBlocks.CUT_RED_SANDSTONE_STAIRS, class_2246.field_10518, class_2246.field_10344);
        this.wall(generator, TTBlocks.CUT_RED_SANDSTONE_WALL, class_2246.field_10518);
        this.wall(generator, TTBlocks.PRISMARINE_BRICK_WALL, class_2246.field_10006);
        this.wall(generator, TTBlocks.DARK_PRISMARINE_WALL, class_2246.field_10297);
        class_4910.class_4912 endStoneFamily = generator.method_25650(class_2246.field_10471);
        endStoneFamily.field_47134.add(class_2246.field_10471);
        endStoneFamily.method_33522(TTDataGenerator.FAMILY_END_STONE);
        generator.method_25650(TTBlocks.CHORAL_END_STONE).method_33522(TTBlocks.FAMILY_CHORAL_END_STONE);
        generator.method_25641(TTBlocks.CRACKED_END_STONE_BRICKS);
        generator.method_25641(TTBlocks.CHISELED_END_STONE_BRICKS);
        generator.method_25650(TTBlocks.CHORAL_END_STONE_BRICKS).method_33522(TTBlocks.FAMILY_CHORAL_END_STONE_BRICKS);
        generator.method_25641(TTBlocks.CRACKED_PURPUR_BLOCK);
        generator.method_25641(TTBlocks.CHISELED_PURPUR_BLOCK);
        this.wall(generator, TTBlocks.PURPUR_WALL, class_2246.field_10286);
        generator.method_25585(TTConstants.id("block/coffin"), class_2246.field_28900).method_25715(new class_2248[]{TTBlocks.COFFIN});
    }

    public void wallSmooth(@NotNull class_4910 generator, class_2248 wallBlock, class_2248 originalBlock) {
        class_4944 mapping = class_4946.method_25920((class_2960)class_4944.method_25866((class_2248)originalBlock, (String)"_top")).method_25921();
        class_2960 resourceLocation = class_4943.field_22991.method_25846(wallBlock, mapping, generator.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22992.method_25846(wallBlock, mapping, generator.field_22831);
        class_2960 resourceLocation3 = class_4943.field_22993.method_25846(wallBlock, mapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25636((class_2248)wallBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2, (class_2960)resourceLocation3));
        class_2960 resourceLocation4 = class_4943.field_22994.method_25846(wallBlock, mapping, generator.field_22831);
        generator.method_25623(wallBlock, resourceLocation4);
    }

    public void wall(@NotNull class_4910 generator, class_2248 wallBlock, class_2248 originalBlock) {
        class_4944 mapping = class_4946.field_23036.get(originalBlock).method_25921();
        class_2960 resourceLocation = class_4943.field_22991.method_25846(wallBlock, mapping, generator.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22992.method_25846(wallBlock, mapping, generator.field_22831);
        class_2960 resourceLocation3 = class_4943.field_22993.method_25846(wallBlock, mapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25636((class_2248)wallBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2, (class_2960)resourceLocation3));
        class_2960 resourceLocation4 = class_4943.field_22994.method_25846(wallBlock, mapping, generator.field_22831);
        generator.method_25623(wallBlock, resourceLocation4);
    }

    public void stairsCut(@NotNull class_4910 generator, class_2248 stairsBlock, class_2248 cutBlock, class_2248 smoothBlock) {
        class_4944 textureMapping = new class_4944();
        textureMapping.method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)cutBlock));
        textureMapping.method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)smoothBlock, (String)"_top"));
        textureMapping.method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)smoothBlock, (String)"_top"));
        class_2960 resourceLocation = class_4943.field_22913.method_25846(stairsBlock, textureMapping, generator.field_22831);
        class_2960 resourceLocation2 = class_4943.field_22912.method_25846(stairsBlock, textureMapping, generator.field_22831);
        class_2960 resourceLocation3 = class_4943.field_22914.method_25846(stairsBlock, textureMapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25646((class_2248)stairsBlock, (class_2960)resourceLocation, (class_2960)resourceLocation2, (class_2960)resourceLocation3));
        generator.method_25623(stairsBlock, resourceLocation2);
    }

    public void generateItemModels(@NotNull class_4915 generator) {
        generator.method_25733(TTItems.AURORA_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.BAIT_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.BLOOM_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.BOLT_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.BULLSEYE_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.CARRIER_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.CLUCK_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.CRAWL_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.CRESCENT_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.CULTIVATOR_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.DROUGHT_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.ENCLOSURE_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.ESSENCE_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.EYE_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.FOCUS_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.FROST_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.HARE_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.HEIGHT_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.HUMP_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.ILLUMINATOR_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.INCIDENCE_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.LUMBER_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.NAVIGATOR_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.NEEDLES_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.OMEN_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.PLUME_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.PROTECTION_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.SHED_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.SHINE_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.SHOWER_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.SPADE_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.SPROUT_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.VESSEL_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.WITHER_POTTERY_SHERD, class_4943.field_22938);
        generator.method_25733(TTItems.UNDEAD_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_25733(TTItems.MATRIX_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_25733(TTItems.MARTYR_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_25733(TTItems.ZEPHYR_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_25733(TTItems.OVERGROWTH_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_25733(TTItems.COT_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_25733(TTItems.GEODE_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_25733(TTItems.EMBRACE_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_25733(TTItems.ECTOPLASM, class_4943.field_22938);
        generator.method_25733(TTItems.CYAN_ROSE_SEEDS, class_4943.field_22938);
        generator.method_25733(TTItems.DAWNTRAIL_SEEDS, class_4943.field_22938);
        generator.method_25733(TTItems.MUSIC_DISC_STASIS, class_4943.field_22938);
        generator.method_25733(TTItems.MUSIC_DISC_FAUSSE_VIE, class_4943.field_22938);
        generator.method_25733(TTItems.MUSIC_DISC_OSSUAIRE, class_4943.field_22938);
    }

    private static void createManedropCrop(@NotNull class_4910 generator) {
        class_2248 block = TTBlocks.MANEDROP_CROP;
        generator.method_25537(block.method_8389());
        class_4926 propertyDispatch = class_4926.method_25784((class_2769)ManedropCropBlock.AGE, (class_2769)class_2741.field_12533).method_25800((age, half) -> switch (half) {
            default -> throw new MatchException(null, null);
            case class_2756.field_12609 -> {
                if (age < 2) {
                    yield class_4935.method_25824().method_25828(class_4936.field_22887, (Object)TTConstants.id("block/manedrop_crop_top_empty"));
                }
                if (age == 3) {
                    yield class_4935.method_25824().method_25828(class_4936.field_22887, (Object)TTConstants.id("block/manedrop_top"));
                }
                yield class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4910.class_4913.field_22840.method_25726().method_25852(TTConstants.id("block/manedrop_crop_top_stage_" + age), class_4944.method_25883((class_4945)class_4945.field_23025, (class_2960)TTConstants.id("block/manedrop_crop_top_stage_" + age)), generator.field_22831));
            }
            case class_2756.field_12607 -> age == 3 ? class_4935.method_25824().method_25828(class_4936.field_22887, (Object)TTConstants.id("block/manedrop_bottom")) : class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4910.class_4913.field_22840.method_25726().method_25852(TTConstants.id("block/manedrop_crop_bottom_stage_" + age), class_4944.method_25883((class_4945)class_4945.field_23025, (class_2960)TTConstants.id("block/manedrop_crop_bottom_stage_" + age)), generator.field_22831));
        });
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(propertyDispatch));
    }

    private static void createDawntrail(@NotNull class_4910 generator) {
        class_2248 block = TTBlocks.DAWNTRAIL;
        generator.method_25600(block);
        class_4922 multiPartGenerator = class_4922.method_25758((class_2248)block);
        class_2960 firstModel = TTConstants.id("block/dawntrail_stage_0");
        class_2960 secondModel = TTConstants.id("block/dawntrail_stage_1");
        class_2960 thirdModel = TTConstants.id("block/dawntrail_stage_2");
        class_4918.class_4921 terminalCondition = (class_4918.class_4921)class_156.method_654((Object)class_4918.method_25744(), terminalConditionx -> MULTIFACE_GENERATOR_NO_UV_LOCK.stream().map(Pair::getFirst).forEach(booleanPropertyx -> terminalConditionx.method_25751((class_2769)booleanPropertyx, (Comparable)Boolean.valueOf(false))));
        for (Pair<class_2746, Function<class_2960, class_4935>> pair : MULTIFACE_GENERATOR_NO_UV_LOCK) {
            class_2746 booleanProperty = (class_2746)pair.getFirst();
            Function function = (Function)pair.getSecond();
            if (!block.method_9564().method_28498((class_2769)booleanProperty)) continue;
            multiPartGenerator.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)booleanProperty, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)DawntrailBlock.AGE, (Comparable)Integer.valueOf(0)), (class_4935)function.apply(firstModel));
            multiPartGenerator.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)booleanProperty, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)DawntrailBlock.AGE, (Comparable)Integer.valueOf(1)), (class_4935)function.apply(secondModel));
            multiPartGenerator.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)booleanProperty, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)DawntrailBlock.AGE, (Comparable)Integer.valueOf(2)), (class_4935)function.apply(thirdModel));
            multiPartGenerator.method_25760((class_4918)terminalCondition, (class_4935)function.apply(firstModel));
        }
        generator.field_22830.accept(multiPartGenerator);
    }

    private static void createDawntrailCrop(@NotNull class_4910 generator) {
        class_2248 crop = TTBlocks.DAWNTRAIL_CROP;
        class_2758 ageProperty = DawntrailCropBlock.AGE;
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        class_4926 propertyDispatch = class_4926.method_25783((class_2769)ageProperty).method_25795(arg_0 -> TTModelProvider.lambda$createDawntrailCrop$10((Int2ObjectMap)int2ObjectMap, arg_0));
        generator.field_22830.accept(class_4925.method_25769((class_2248)crop).method_25775(propertyDispatch));
    }

    private static void createEctoplasmBlock(@NotNull class_4910 generator) {
        EctoplasmBlock block = TTBlocks.ECTOPLASM_BLOCK;
        class_2960 model = TTConstants.id("block/ectoplasm_block");
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)model));
        generator.method_25623((class_2248)block, model);
    }

    private static /* synthetic */ class_4935 lambda$createDawntrailCrop$10(Int2ObjectMap int2ObjectMap, Integer age) {
        class_2960 resourceLocation = (class_2960)int2ObjectMap.computeIfAbsent((Object)age, (Function)((Int2ObjectFunction)key -> TTConstants.id("block/dawntrail_crop_stage_" + Math.min(age, 3))));
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891);
    }
}

