/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.effect;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.entity.ai.apparition.ApparitionAi;
import net.frozenblock.trailiertales.registry.TTEntityTypes;
import net.frozenblock.trailiertales.registry.TTParticleTypes;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4081;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TransfiguringMobEffect
extends class_1291 {
    public static final class_1299<Apparition> SPAWNED_ENTITY_TYPE = TTEntityTypes.APPARITION;

    public TransfiguringMobEffect(class_4081 type, int color) {
        super(type, color, (class_2394)TTParticleTypes.TRANSFIGURING);
    }

    @VisibleForTesting
    protected static int numberOfApparitionsToSpawn(int maxEntityCramming, NearbyApparitions counter) {
        return maxEntityCramming < 1 ? 1 : class_3532.method_15340((int)0, (int)(maxEntityCramming - counter.count(maxEntityCramming)), (int)1);
    }

    public void method_58620(class_1309 entity, int amplifier) {
        super.method_58620(entity, amplifier);
        if (entity instanceof Apparition) {
            Apparition apparition = (Apparition)entity;
            entity.method_37908().method_8421((class_1297)entity, (byte)60);
            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23320(), entity.method_23321(), TTSounds.APPARITION_VANISH, class_3419.field_15251, 0.6f, 0.9f + entity.method_37908().field_9229.method_43057() * 0.2f);
            apparition.dropItem();
            entity.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public void method_58617(class_3218 level, class_1309 entity, int amplifier, class_1297.class_5529 reason) {
        if (reason == class_1297.class_5529.field_26998 && entity.method_5864() != SPAWNED_ENTITY_TYPE) {
            int j = level.method_64395().method_8356(class_1928.field_19405);
            int k = TransfiguringMobEffect.numberOfApparitionsToSpawn(j, NearbyApparitions.closeTo(entity));
            for (int l = 0; l < k; ++l) {
                this.spawnApparitionOffspring(level, entity.method_23317(), entity.method_23318() + 0.5, entity.method_23321());
            }
        }
    }

    private void spawnApparitionOffspring(class_3218 level, double x, double y, double z) {
        Apparition apparition = (Apparition)SPAWNED_ENTITY_TYPE.method_5883((class_1937)level, class_3730.field_47245);
        if (apparition != null) {
            apparition.method_5808(x, y, z, level.method_8409().method_43057() * 360.0f, 0.0f);
            ApparitionAi.rememberHome(apparition, (class_1937)level, class_2338.method_49637((double)x, (double)y, (double)z));
            level.method_8649((class_1297)apparition);
        }
    }

    @FunctionalInterface
    protected static interface NearbyApparitions {
        public int count(int var1);

        @Contract(pure=true)
        @NotNull
        public static NearbyApparitions closeTo(class_1309 entity) {
            return i -> {
                ArrayList list = new ArrayList();
                entity.method_37908().method_47575(TTEntityTypes.APPARITION, entity.method_5829().method_1014(3.0), apparition -> apparition != entity, list, i);
                return list.size();
            };
        }
    }
}

