/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.entity.ai.apparition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.registry.TTMemoryModuleTypes;
import net.frozenblock.trailiertales.registry.TTParticleTypes;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_9381;
import org.jetbrains.annotations.NotNull;

public class ApparitionAid
extends class_4097<Apparition> {
    public static final class_2394 BUBBLE_PARTICLE = class_9381.method_58255(TTParticleTypes.GLOWING_BUBBLE, (float)0.63529414f, (float)0.70980394f, (float)0.8509804f);
    public static final class_2394 EFFECT_PARTICLE = class_9381.method_58255(TTParticleTypes.GLOWING_ENTITY_EFFECT, (float)0.63529414f, (float)0.70980394f, (float)0.8509804f);

    @VisibleForTesting
    public ApparitionAid() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, TTMemoryModuleTypes.AID_COOLDOWN, (Object)class_4141.field_18457, TTMemoryModuleTypes.AIDING_TIME, (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18458, TTMemoryModuleTypes.AIDING_ENTITIES, (Object)class_4141.field_18458), 80);
    }

    protected boolean checkExtraStartConditions(class_3218 world, @NotNull Apparition apparition) {
        return apparition.method_18868().method_18896(TTMemoryModuleTypes.NEAREST_AIDABLE) && !apparition.isHiding();
    }

    protected boolean canStillUse(class_3218 world, @NotNull Apparition apparition, long l) {
        class_4095<Apparition> brain = apparition.method_18868();
        return brain.method_18896(class_4140.field_22355) && brain.method_18896(TTMemoryModuleTypes.NEAREST_AIDABLE) && brain.method_18896(TTMemoryModuleTypes.AIDING_TIME);
    }

    protected void start(class_3218 world, @NotNull Apparition apparition, long l) {
        class_4095<Apparition> brain = apparition.method_18868();
        apparition.method_5783(TTSounds.APPARITION_AID, apparition.method_6107(), apparition.method_6017());
        brain.method_18878(TTMemoryModuleTypes.AIDING_TIME, (Object)61);
        ArrayList trackingUUIDs = new ArrayList();
        brain.method_18904(TTMemoryModuleTypes.NEARBY_AIDABLES).ifPresent(nearbyAidables -> nearbyAidables.forEach(aidable -> trackingUUIDs.add(aidable.method_5667())));
        if (!trackingUUIDs.isEmpty()) {
            brain.method_18878(TTMemoryModuleTypes.AIDING_ENTITIES, trackingUUIDs);
        }
    }

    protected void stop(class_3218 world, @NotNull Apparition apparition, long l) {
        class_4095<Apparition> brain = apparition.method_18868();
        brain.method_24525(TTMemoryModuleTypes.AID_COOLDOWN, (Object)class_3902.field_17274, 200L);
        brain.method_18875(TTMemoryModuleTypes.AIDING_ENTITIES);
        apparition.setAidAnimProgress(0.0f);
    }

    protected void tick(class_3218 world, @NotNull Apparition apparition, long l) {
        class_4095<Apparition> brain = apparition.method_18868();
        List entities = (List)brain.method_18904(TTMemoryModuleTypes.NEARBY_AIDABLES).orElse(ImmutableList.of());
        ArrayList trackingUUIDs = new ArrayList();
        entities.forEach(aidable -> trackingUUIDs.add(aidable.method_5667()));
        if (trackingUUIDs.isEmpty()) {
            this.method_18925(world, (class_1309)apparition, l);
            return;
        }
        brain.method_18878(TTMemoryModuleTypes.AIDING_ENTITIES, trackingUUIDs);
        int aidingTime = brain.method_18904(TTMemoryModuleTypes.AIDING_TIME).orElse(0);
        if (aidingTime > 1) {
            entities.forEach(livingEntity -> ApparitionAid.spawnParticles(world, livingEntity, apparition.method_59922().method_43051(1, 2), BUBBLE_PARTICLE));
            apparition.setAidAnimProgress(1.0f);
            class_1309 nearestAidable = brain.method_18904(TTMemoryModuleTypes.NEAREST_AIDABLE).orElse(null);
            if (nearestAidable != null) {
                brain.method_18875(class_4140.field_18445);
                brain.method_18875(class_4140.field_18446);
                apparition.method_5942().method_58160(nearestAidable.method_23317(), nearestAidable.method_23320() + 0.5, nearestAidable.method_23321(), 0, 1.25);
            }
        } else if (aidingTime == 1) {
            brain.method_18904(class_4140.field_22355).ifPresent(attackTarget -> entities.forEach(livingEntity -> {
                if (livingEntity instanceof class_1308) {
                    class_1308 mob = (class_1308)livingEntity;
                    mob.method_5980(attackTarget);
                    ApparitionAid.spawnParticles(world, livingEntity, apparition.method_59922().method_43051(9, 18), EFFECT_PARTICLE);
                }
            }));
            this.method_18925(world, (class_1309)apparition, l);
        } else {
            this.method_18925(world, (class_1309)apparition, l);
        }
    }

    private static void spawnParticles(@NotNull class_3218 level, @NotNull class_1309 entity, int count, class_2394 particleOptions) {
        level.method_14199(particleOptions, entity.method_23317(), entity.method_23323(0.6666666666666666), entity.method_23321(), count, (double)(entity.method_17681() / 4.0f), (double)(entity.method_17682() / 4.0f), (double)(entity.method_17681() / 4.0f), 0.05);
    }
}

