/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.entity.ai.apparition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.registry.TTMemoryModuleTypes;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import org.jetbrains.annotations.NotNull;

public class ApparitionShoot
extends class_4097<Apparition> {
    @VisibleForTesting
    public ApparitionShoot() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, TTMemoryModuleTypes.SEE_TIME, (Object)class_4141.field_18458, TTMemoryModuleTypes.STRAFING_CLOCKWISE, (Object)class_4141.field_18458, TTMemoryModuleTypes.STRAFING_BACKWARDS, (Object)class_4141.field_18458, TTMemoryModuleTypes.STRAFING_TIME, (Object)class_4141.field_18458, TTMemoryModuleTypes.CHARGING_TICKS, (Object)class_4141.field_18458), 240);
    }

    protected boolean checkExtraStartConditions(class_3218 world, @NotNull Apparition apparition) {
        return !((class_1799)apparition.method_35199().method_54454().getFirst()).method_7960() && !apparition.isHiding() && apparition.method_18868().method_18904(class_4140.field_22355).map(livingEntity -> ApparitionShoot.isTargetWithinRange(apparition, livingEntity)).orElse(false) != false;
    }

    protected boolean canStillUse(class_3218 world, @NotNull Apparition apparition, long l) {
        return apparition.method_18868().method_18896(class_4140.field_22355) && !((class_1799)apparition.method_35199().method_54454().getFirst()).method_7960();
    }

    protected void start(class_3218 world, @NotNull Apparition apparition, long l) {
        apparition.method_5783(TTSounds.APPARITION_HOLDING_ITEM, apparition.method_6107(), apparition.method_6017());
        apparition.method_19540(true);
        apparition.setPoltergeistAnimProgress(1.0f);
    }

    protected void stop(class_3218 world, @NotNull Apparition apparition, long l) {
        class_4095<Apparition> brain = apparition.method_18868();
        apparition.method_19540(false);
        brain.method_18875(TTMemoryModuleTypes.SEE_TIME);
        brain.method_18875(TTMemoryModuleTypes.STRAFING_CLOCKWISE);
        brain.method_18875(TTMemoryModuleTypes.STRAFING_BACKWARDS);
        brain.method_18875(TTMemoryModuleTypes.STRAFING_TIME);
        brain.method_18875(TTMemoryModuleTypes.CHARGING_TICKS);
        apparition.setPoltergeistAnimProgress(0.0f);
        apparition.method_18868().method_18878(class_4140.field_38397, (Object)300);
    }

    protected void tick(class_3218 world, @NotNull Apparition apparition, long l) {
        class_4095<Apparition> brain = apparition.method_18868();
        class_1309 livingEntity = brain.method_18904(class_4140.field_22355).orElse(null);
        if (livingEntity != null) {
            boolean hasSeen;
            double distance = apparition.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
            boolean lineOfSight = apparition.method_5985().method_6369((class_1297)livingEntity);
            if (lineOfSight != (hasSeen = brain.method_18896(TTMemoryModuleTypes.SEE_TIME))) {
                brain.method_18875(TTMemoryModuleTypes.SEE_TIME);
            }
            int seeTime = brain.method_18904(TTMemoryModuleTypes.SEE_TIME).orElse(0);
            seeTime = lineOfSight ? ++seeTime : --seeTime;
            brain.method_18878(TTMemoryModuleTypes.SEE_TIME, (Object)seeTime);
            int strafeTime = brain.method_18904(TTMemoryModuleTypes.STRAFING_TIME).orElse(-1);
            if (!(distance > 256.0) && seeTime >= 20) {
                brain.method_18875(class_4140.field_18445);
                brain.method_18875(class_4140.field_18446);
                apparition.method_5942().method_6340();
                brain.method_18878(TTMemoryModuleTypes.STRAFING_TIME, (Object)(++strafeTime));
            } else {
                apparition.method_5942().method_6337(livingEntity.method_23317(), livingEntity.method_23320(), livingEntity.method_23321(), 1.0);
                brain.method_18875(class_4140.field_18445);
                brain.method_18875(class_4140.field_18446);
                brain.method_18875(TTMemoryModuleTypes.STRAFING_TIME);
            }
            if (brain.method_18904(TTMemoryModuleTypes.STRAFING_TIME).orElse(0) >= 20) {
                if (apparition.method_59922().method_43057() < 0.3f) {
                    brain.method_18904(TTMemoryModuleTypes.STRAFING_CLOCKWISE).ifPresentOrElse(unit -> brain.method_18875(TTMemoryModuleTypes.STRAFING_CLOCKWISE), () -> brain.method_18878(TTMemoryModuleTypes.STRAFING_CLOCKWISE, (Object)class_3902.field_17274));
                    brain.method_18875(TTMemoryModuleTypes.CHARGING_TICKS);
                }
                if (apparition.method_59922().method_43057() < 0.3f) {
                    brain.method_18904(TTMemoryModuleTypes.STRAFING_BACKWARDS).ifPresentOrElse(unit -> brain.method_18875(TTMemoryModuleTypes.STRAFING_BACKWARDS), () -> brain.method_18878(TTMemoryModuleTypes.STRAFING_BACKWARDS, (Object)class_3902.field_17274));
                }
                strafeTime = 0;
                brain.method_18878(TTMemoryModuleTypes.STRAFING_TIME, (Object)strafeTime);
            }
            if (strafeTime > -1) {
                if (distance > 192.0) {
                    brain.method_18875(TTMemoryModuleTypes.STRAFING_BACKWARDS);
                } else if (distance < 64.0) {
                    brain.method_18878(TTMemoryModuleTypes.STRAFING_BACKWARDS, (Object)class_3902.field_17274);
                }
                apparition.method_5962().method_6243(brain.method_18896(TTMemoryModuleTypes.STRAFING_BACKWARDS) ? -0.5f : 0.5f, brain.method_18896(TTMemoryModuleTypes.STRAFING_CLOCKWISE) ? 0.5f : -0.5f);
                class_1297 class_12972 = apparition.method_49694();
                if (class_12972 instanceof class_1308) {
                    class_1308 mob = (class_1308)class_12972;
                    brain.method_18875(class_4140.field_18446);
                    mob.method_5951((class_1297)livingEntity, 30.0f, 30.0f);
                }
                brain.method_18875(class_4140.field_18446);
                apparition.method_5951((class_1297)livingEntity, 30.0f, 30.0f);
            } else {
                brain.method_18875(class_4140.field_18446);
                apparition.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
            }
            int chargingTicks = brain.method_18904(TTMemoryModuleTypes.CHARGING_TICKS).orElse(0);
            if (chargingTicks > 0) {
                if (!lineOfSight && seeTime < -60) {
                    chargingTicks = 0;
                } else if (lineOfSight && chargingTicks++ >= 20) {
                    chargingTicks = 0;
                    apparition.method_7105(livingEntity, 0.3f + apparition.method_59922().method_43057() * 1.4f);
                    this.method_18925(world, (class_1309)apparition, l);
                }
            } else if (seeTime >= -60) {
                ++chargingTicks;
            }
            brain.method_18878(TTMemoryModuleTypes.CHARGING_TICKS, (Object)chargingTicks);
        }
    }

    private static boolean isTargetWithinRange(@NotNull Apparition apparition, @NotNull class_1309 target) {
        double d = apparition.method_19538().method_1025(target.method_19538());
        return d > 4.0 && d < 256.0;
    }
}

