/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.worldgen.structure;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import net.frozenblock.trailiertales.TTConstants;
import net.frozenblock.trailiertales.worldgen.structure.RuinsStructure;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class RuinsPieceHandler {
    private static final boolean LOG_RUINS_PIECE_LOADING = false;
    private static final Map<String, Integer> DIRECTORY_TO_PIECE_OFFSET_MAP = ImmutableMap.builder().put((Object)"buried", (Object)0).put((Object)"one_from_top", (Object)1).put((Object)"two_from_top", (Object)2).put((Object)"three_from_top", (Object)3).put((Object)"four_from_top", (Object)4).put((Object)"five_from_top", (Object)5).put((Object)"six_from_top", (Object)6).put((Object)"seven_from_top", (Object)7).put((Object)"eight_from_top", (Object)8).put((Object)"nine_from_top", (Object)9).put((Object)"ten_from_top", (Object)10).build();
    private final List<class_2960> ruinsPieces = new ArrayList<class_2960>();
    private final RuinsStructure.Type type;

    public RuinsPieceHandler(RuinsStructure.Type type) {
        this.type = type;
    }

    public class_2960 getRandomPiece(@NotNull class_5819 randomSource) {
        return (class_2960)class_156.method_32309(this.ruinsPieces, (class_5819)randomSource);
    }

    public void onDataReload(@NotNull class_3300 resourceManager) {
        this.ruinsPieces.clear();
        this.ruinsPieces.addAll(this.getLoadedPieces(resourceManager));
    }

    @NotNull
    private List<class_2960> getLoadedPieces(@NotNull class_3300 resourceManager) {
        Set foundPieces = resourceManager.method_14488("structure/ruins/" + this.type.getName(), resourceLocation -> resourceLocation.method_12832().endsWith(".nbt") && resourceLocation.method_12836().equals("trailiertales")).keySet();
        ArrayList<class_2960> convertedLocations = new ArrayList<class_2960>();
        foundPieces.forEach(resourceLocation -> {
            String newPath = resourceLocation.method_12832();
            newPath = newPath.replace(".nbt", "");
            newPath = newPath.replace("structure/", "");
            convertedLocations.add(class_2960.method_43902((String)resourceLocation.method_12836(), (String)newPath));
        });
        return convertedLocations;
    }

    public static OptionalInt getPieceOffset( @NotNull RuinsPieces.RuinPiece piece) {
        class_2960 pieceLocation = piece.method_35470();
        String piecePath = pieceLocation.method_12832();
        for (Map.Entry<String, Integer> offsetMapEntry : DIRECTORY_TO_PIECE_OFFSET_MAP.entrySet()) {
            String pieceDirectory = offsetMapEntry.getKey();
            if (!piecePath.contains(pieceDirectory + "/")) continue;
            return OptionalInt.of(offsetMapEntry.getValue());
        }
        return OptionalInt.empty();
    }

    private static /* synthetic */ void lambda$getLoadedPieces$2(class_2960 convertedLocation) {
        TTConstants.log(convertedLocation.toString(), true);
    }
}

