/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.worldgen.structure;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.frozenblock.trailiertales.registry.TTStructurePieceTypes;
import net.frozenblock.trailiertales.worldgen.structure.RuinsPieceHandler;
import net.frozenblock.trailiertales.worldgen.structure.RuinsStructure;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3470;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3486;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3610;
import net.minecraft.class_3793;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuinsPieces {
    public static void addPieces(class_3485 structureTemplateManager, class_5539 heightAccessor, class_2338 pos, class_2470 rotation, @NotNull class_5819 random, @NotNull RuinsStructure feature, List<RuinPiece> pieces, class_3341 box) {
        RuinPiece ruinPiece = RuinsPieces.addStarterPiece(structureTemplateManager, pos, rotation, pieces, random, feature);
        if (random.method_43057() <= feature.clusterProbability) {
            RuinsPieces.addClusterRuins(structureTemplateManager, ruinPiece.method_14935(), random, pos, feature, pieces, box);
        }
    }

    private static void addClusterRuins(class_3485 structureTemplateManager, class_3341 boundingBox, class_5819 random, @NotNull class_2338 pos, @NotNull RuinsStructure feature, @NotNull List<RuinPiece> pieces, class_3341 box) {
        ObjectArrayList boundingBoxes = new ObjectArrayList();
        boundingBoxes.add((Object)boundingBox);
        int totalPieces = feature.clusterPieces.method_35008(random);
        for (int pieceNumber = 0; pieceNumber < totalPieces; ++pieceNumber) {
            class_2470 newRotation = class_2470.method_16548((class_5819)random);
            RuinsPieces.addPiece(structureTemplateManager, (ObjectArrayList<class_3341>)boundingBoxes, pos, newRotation, pieces, random, feature, box, 7);
        }
    }

    @Nullable
    private static RuinPiece addPiece(class_3485 structureTemplateManager, ObjectArrayList<class_3341> boundingBoxes, @NotNull class_2338 pos, class_2470 rotation, @NotNull List<RuinPiece> pieces, class_5819 random, @NotNull RuinsStructure structure, class_3341 box, int maxAttempts) {
        RuinPiece ruinPiece = null;
        ++maxAttempts;
        class_2960 pieceId = structure.ruinsType.getPieceHandler().getRandomPiece(random);
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        for (int i = 0; i < maxAttempts; ++i) {
            RuinPiece potentialPiece = new RuinPiece(structureTemplateManager, pieceId, (class_2338)mutableBlockPos, rotation, structure.ruinsType, structure.heightmap, structure.providedHeight);
            class_3341 currentBox = potentialPiece.method_14935();
            AtomicReference<class_3341> inflatedBox = new AtomicReference<class_3341>(currentBox.method_35410(2));
            List shuffledBoxes = class_156.method_43027(boundingBoxes, (class_5819)random);
            AtomicBoolean intersected = new AtomicBoolean(false);
            shuffledBoxes.forEach(boundingBox -> {
                AtomicBoolean withinBox = new AtomicBoolean(true);
                ((class_3341)inflatedBox.get()).method_35410(-2).method_34391(cornerPos -> {
                    if (!box.method_14662((class_2382)cornerPos)) {
                        withinBox.set(false);
                    }
                });
                if (boundingBox.method_14657((class_3341)inflatedBox.get()) || !withinBox.get()) {
                    intersected.set(true);
                    class_2338 center = boundingBox.method_22874();
                    boolean useXSpan = random.method_43056();
                    boolean useZSpan = !useXSpan || random.method_43056();
                    int xDirection = random.method_43056() ? 1 : -1;
                    int zDirection = random.method_43056() ? 1 : -1;
                    double xSpanScale = useXSpan ? 0.5 : 0.1;
                    double zSpanScale = useZSpan ? 0.5 : 0.1;
                    int xStep = (int)((double)boundingBox.method_35414() * xSpanScale + (double)currentBox.method_35414() * xSpanScale + (double)random.method_43051(0, 6));
                    int zStep = (int)((double)boundingBox.method_14663() * zSpanScale + (double)currentBox.method_14663() * zSpanScale + (double)random.method_43051(0, 6));
                    mutableBlockPos.method_10101((class_2382)center).method_10100(xStep * xDirection, 0, zStep * zDirection);
                    inflatedBox.set(((class_3341)inflatedBox.get()).method_19311(xStep * xDirection, 0, zStep * zDirection));
                }
            });
            if (intersected.get()) continue;
            ruinPiece = potentialPiece;
            pieces.add(ruinPiece);
            boundingBoxes.add((Object)ruinPiece.method_14935());
            break;
        }
        return ruinPiece;
    }

    @NotNull
    private static RuinPiece addStarterPiece(class_3485 structureTemplateManager, @NotNull class_2338 pos, class_2470 rotation, @NotNull List<RuinPiece> pieces, class_5819 random, @NotNull RuinsStructure structure) {
        class_2960 structureId = structure.ruinsType.getPieceHandler().getRandomPiece(random);
        RuinPiece piece = new RuinPiece(structureTemplateManager, structureId, pos, rotation, structure.ruinsType, structure.heightmap, structure.providedHeight);
        pieces.add(piece);
        return piece;
    }

    public static class RuinPiece
    extends class_3470 {
        private final RuinsStructure.Type ruinsType;
        public final Optional<class_2902.class_2903> heightmap;
        private Optional<Integer> providedHeight;
        private boolean adjustedHeight;

        public RuinPiece(class_3485 structureTemplateManager, class_2960 structureId, class_2338 pos, class_2470 rotation, RuinsStructure.Type biomeType, Optional<class_2902.class_2903> heightmap, Optional<Integer> providedHeight) {
            super(TTStructurePieceTypes.RUIN, 0, structureTemplateManager, structureId, structureId.toString(), RuinPiece.makeSettings(rotation, biomeType), pos);
            this.ruinsType = biomeType;
            this.heightmap = heightmap;
            this.providedHeight = providedHeight;
        }

        public RuinPiece(class_3485 structureTemplateManager, class_2960 structureId, class_2338 pos, class_2470 rotation, RuinsStructure.Type ruinsType, Optional<class_2902.class_2903> heightmap, Optional<Integer> providedHeight, boolean adjustedHeight) {
            super(TTStructurePieceTypes.RUIN, 0, structureTemplateManager, structureId, structureId.toString(), RuinPiece.makeSettings(rotation, ruinsType), pos);
            this.ruinsType = ruinsType;
            this.heightmap = heightmap;
            this.providedHeight = providedHeight;
            this.adjustedHeight = adjustedHeight;
        }

        private RuinPiece(class_3485 templateManager, class_2487 nbt, class_2470 rotation, RuinsStructure.Type ruinsType, Optional<class_2902.class_2903> heightmap, Optional<Integer> providedHeight) {
            super(TTStructurePieceTypes.RUIN, nbt, templateManager, id -> RuinPiece.makeSettings(rotation, ruinsType));
            this.ruinsType = ruinsType;
            this.heightmap = heightmap;
            this.providedHeight = providedHeight;
        }

        private RuinPiece(class_3485 templateManager, class_2487 nbt, class_2470 rotation, RuinsStructure.Type ruinsType, Optional<class_2902.class_2903> heightmap, Optional<Integer> providedHeight, boolean adjustedHeight) {
            super(TTStructurePieceTypes.RUIN, nbt, templateManager, id -> RuinPiece.makeSettings(rotation, ruinsType));
            this.ruinsType = ruinsType;
            this.heightmap = heightmap;
            this.providedHeight = providedHeight;
            this.adjustedHeight = adjustedHeight;
        }

        @NotNull
        private static class_3492 makeSettings(class_2470 rotation, @NotNull RuinsStructure.Type ruinsType) {
            class_3492 placeSettings = new class_3492().method_15123(rotation).method_15125(class_2415.field_11302).method_16184((class_3491)class_3793.field_16718);
            ruinsType.getProcessors().method_31027().forEach(arg_0 -> ((class_3492)placeSettings).method_16184(arg_0));
            return placeSettings;
        }

        @NotNull
        public static RuinPiece create(class_3485 templateManager, @NotNull class_2487 nbt) {
            class_2470 rotation = class_2470.valueOf((String)nbt.method_10558("Rot"));
            RuinsStructure.Type type = RuinsStructure.Type.GENERIC;
            if (nbt.method_10545("RuinsType")) {
                type = RuinsStructure.Type.valueOf(nbt.method_10558("RuinsType"));
            } else if (nbt.method_10545("BiomeType")) {
                type = RuinsStructure.Type.valueOf(nbt.method_10558("BiomeType"));
            }
            class_2902.class_2903 heightmap = null;
            if (nbt.method_10545("HeightmapType")) {
                heightmap = class_2902.class_2903.valueOf((String)nbt.method_10558("HeightmapType"));
            }
            Integer providedHeight = null;
            if (nbt.method_10545("ProvidedHeight")) {
                providedHeight = nbt.method_10550("ProvidedHeight");
            }
            boolean adjustedHeight = false;
            if (nbt.method_10545("AdjustedHeight")) {
                adjustedHeight = nbt.method_10577("AdjustedHeight");
            }
            return new RuinPiece(templateManager, nbt, rotation, type, Optional.ofNullable(heightmap), Optional.ofNullable(providedHeight), adjustedHeight);
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_10582("Rot", this.field_15434.method_15113().name());
            nbt.method_10582("RuinsType", this.ruinsType.toString());
            this.heightmap.ifPresent(types -> nbt.method_10582("HeightmapType", types.toString()));
            this.providedHeight.ifPresent(height -> nbt.method_10569("ProvidedHeight", height.intValue()));
            nbt.method_10556("AdjustedHeight", this.adjustedHeight);
        }

        protected void method_15026(String metadata, class_2338 pos, class_5425 world, class_5819 random, class_3341 boundingBox) {
        }

        public void method_14931(@NotNull class_5281 world, class_5138 structureManager, class_2794 chunkGenerator, class_5819 random, class_3341 boundingBox, class_1923 chunkPos, class_2338 pos) {
            if (!this.adjustedHeight) {
                this.adjustedHeight = true;
                int startHeight = this.field_15432.method_10264();
                int offset = -2;
                OptionalInt optionalOffset = RuinsPieceHandler.getPieceOffset(this);
                if (optionalOffset.isPresent()) {
                    offset = -this.method_14935().method_14660() + optionalOffset.getAsInt();
                }
                if (!this.ruinsType.isUnderground()) {
                    int i = this.getGenHeight(world, this.field_15432, random, 5);
                    this.field_15432 = new class_2338(this.field_15432.method_10263(), i, this.field_15432.method_10260());
                    class_2338 endPos = class_3499.method_15168((class_2338)new class_2338(this.field_15433.method_15160().method_10263() - 1, 0, this.field_15433.method_15160().method_10260() - 1), (class_2415)class_2415.field_11302, (class_2470)this.field_15434.method_15113(), (class_2338)class_2338.field_10980).method_10081((class_2382)this.field_15432);
                    this.field_15432 = new class_2338(this.field_15432.method_10263(), this.getFinalHeight(this.field_15432, (class_1922)world, endPos), this.field_15432.method_10260());
                }
                this.field_15432 = this.field_15432.method_30513(class_2350.class_2351.field_11052, offset);
                int yDifference = startHeight - this.field_15432.method_10264();
                this.field_15315.method_14661(0, yDifference, 0);
            }
            if (this.field_15315.method_35416() <= world.method_31607()) {
                return;
            }
            super.method_14931(world, structureManager, chunkGenerator, random, boundingBox, chunkPos, pos);
        }

        public int getGenHeight(@NotNull class_5281 world, class_2338 pos, class_5819 random, int providerOffset) {
            class_2902.class_2903 heightmapType = this.heightmap.orElseGet(() -> this.providedHeight.isEmpty() ? class_2902.class_2903.field_13195 : null);
            if (heightmapType != null) {
                return world.method_8624(heightmapType, pos.method_10263(), pos.method_10260());
            }
            return this.providedHeight.get() + random.method_43048(providerOffset) * (random.method_43056() ? 1 : -1);
        }

        private int getFinalHeight(@NotNull class_2338 start, class_1922 world, class_2338 end) {
            int i = start.method_10264();
            int j = 512;
            int k = i - 1;
            int l = 0;
            for (class_2338 blockPos : class_2338.method_10097((class_2338)start, (class_2338)end)) {
                int m = blockPos.method_10263();
                int n = blockPos.method_10260();
                int o = start.method_10264() - 1;
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(m, o, n);
                class_2680 blockState = world.method_8320((class_2338)mutableBlockPos);
                class_3610 fluidState = world.method_8316((class_2338)mutableBlockPos);
                while ((blockState.method_26215() || fluidState.method_15767(class_3486.field_15517) || blockState.method_26164(class_3481.field_15467)) && o > world.method_31607() + 1) {
                    mutableBlockPos.method_10103(m, --o, n);
                    blockState = world.method_8320((class_2338)mutableBlockPos);
                    fluidState = world.method_8316((class_2338)mutableBlockPos);
                }
                j = Math.min(j, o);
                if (o >= k - 2) continue;
                ++l;
            }
            int p = Math.abs(start.method_10263() - end.method_10263());
            if (k - j > 2 && l > p - 2) {
                i = j + 1;
            }
            return i;
        }
    }
}

