/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.entity.ai.apparition;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.entity.ai.apparition.ApparitionAid;
import net.frozenblock.trailiertales.entity.ai.apparition.ApparitionHaunt;
import net.frozenblock.trailiertales.entity.ai.apparition.ApparitionShoot;
import net.frozenblock.trailiertales.registry.TTMemoryModuleTypes;
import net.frozenblock.trailiertales.registry.TTSensorTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4099;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4115;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4215;
import net.minecraft.class_4815;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5321;
import net.minecraft.class_5753;
import net.minecraft.class_7297;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApparitionAi {
    public static final List<class_4149<? extends class_4148<? super Apparition>>> SENSOR_TYPES = List.of(class_4149.field_18466, class_4149.field_18469, TTSensorTypes.APPARITION_PLAYER_SENSOR, TTSensorTypes.APPARITION_ATTACKABLES_SENSOR, TTSensorTypes.APPARITION_SPECIFIC_SENSOR, TTSensorTypes.APPARITION_NEAREST_ITEM_SENSOR, TTSensorTypes.APPARITION_AIDABLES_SENSOR);
    public static final List<class_4140<?>> MEMORY_TYPES = List.of(class_4140.field_18446, class_4140.field_18441, class_4140.field_18442, class_4140.field_30243, class_4140.field_19293, class_4140.field_22355, class_4140.field_18445, class_4140.field_18451, class_4140.field_18452, class_4140.field_18449, class_4140.field_18443, class_4140.field_18444, class_4140.field_22354, TTMemoryModuleTypes.NEARBY_APPARITIONS, class_4140.field_38397, class_4140.field_22332, TTMemoryModuleTypes.AID_COOLDOWN, TTMemoryModuleTypes.AIDING_TIME, TTMemoryModuleTypes.NEARBY_AIDABLES, TTMemoryModuleTypes.NEAREST_AIDABLE, TTMemoryModuleTypes.SEE_TIME, TTMemoryModuleTypes.STRAFING_CLOCKWISE, TTMemoryModuleTypes.STRAFING_BACKWARDS, TTMemoryModuleTypes.STRAFING_TIME, TTMemoryModuleTypes.CHARGING_TICKS, class_4140.field_18438, TTMemoryModuleTypes.HAUNTING_TICKS, TTMemoryModuleTypes.AIDING_ENTITIES);

    @Contract(value="_, _ -> param2")
    @NotNull
    public static class_4095<Apparition> makeBrain(Apparition apparition, class_4095<Apparition> brain) {
        ApparitionAi.initCoreActivity(brain);
        ApparitionAi.initIdleActivity(brain);
        ApparitionAi.initFightActivity(apparition, brain);
        brain.method_18890(Set.of(class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(@NotNull class_4095<Apparition> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(class_4140.field_38397), (Object)new class_5753(TTMemoryModuleTypes.AIDING_TIME), (Object)((Object)new ApparitionHaunt())));
    }

    private static void initIdleActivity(@NotNull class_4095<Apparition> brain) {
        brain.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4824.method_47120((level, apparition) -> true, ApparitionAi::findNearestValidAttackTarget), (Object)class_7297.method_47130(ApparitionAi::getLookTarget, entity -> true, (int)7, (int)16, (float)1.0f), (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)8.0f), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))), (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47025((float)0.6f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)))));
    }

    private static void initFightActivity(Apparition apparition, @NotNull class_4095<Apparition> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4828.method_47139((level, entity) -> !apparition.canTargetEntity((class_1297)entity, level), ApparitionAi::onTargetInvalid, (boolean)true), (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4822.method_47094((float)1.0f), (Object)1), (Object)Pair.of((Object)((Object)new ApparitionAid()), (Object)1), (Object)Pair.of((Object)((Object)new ApparitionShoot()), (Object)1), (Object)Pair.of((Object)class_4815.method_46947(apparition1 -> ((class_1799)apparition1.method_35199().method_54454().getFirst()).method_7960(), (float)1.25f, (boolean)true, (int)28), (Object)1)))), class_4140.field_22355);
    }

    private static boolean shouldGoTowardsHome(@NotNull class_1309 apparition, @NotNull class_4208 pos) {
        return ((Apparition)apparition).shouldReturnToHome(pos);
    }

    @Nullable
    public static class_2338 getHome(@NotNull Apparition apparition) {
        Optional optional = apparition.method_18868().method_18904(class_4140.field_18438);
        return optional.map(class_4208::comp_2208).orElse(null);
    }

    public static boolean isInHomeDimension(@NotNull Apparition apparition) {
        Optional optional = apparition.method_18868().method_18904(class_4140.field_18438);
        return optional.filter(globalPos -> globalPos.comp_2207() == apparition.method_73183().method_27983()).isPresent();
    }

    public static void rememberHome(@NotNull Apparition apparition, @NotNull class_2338 pos) {
        ApparitionAi.rememberHome(apparition, apparition.method_73183(), pos);
    }

    public static void rememberHome(@NotNull Apparition apparition, @NotNull class_1937 level, @NotNull class_2338 pos) {
        class_4095<Apparition> brain = apparition.method_18868();
        class_4208 globalPos = class_4208.method_19443((class_5321)level.method_27983(), (class_2338)pos);
        brain.method_18878(class_4140.field_18438, (Object)globalPos);
    }

    @NotNull
    private static Optional<class_4115> getLookTarget(@NotNull class_1309 apparition) {
        class_4208 globalPos;
        class_4095 brain = apparition.method_18868();
        Optional home = brain.method_18904(class_4140.field_18438);
        if (home.isPresent() && ApparitionAi.shouldGoTowardsHome(apparition, globalPos = (class_4208)home.get())) {
            return Optional.of(new class_4099(ApparitionAi.randomPosAround(globalPos.comp_2208(), apparition.method_73183())));
        }
        return Optional.empty();
    }

    @NotNull
    private static class_2338 randomPosAround(@NotNull class_2338 pos, @NotNull class_1937 level) {
        return pos.method_10069(level.field_9229.method_39332(-7, 7), level.field_9229.method_39332(-7, 7), level.field_9229.method_39332(-7, 7));
    }

    private static void onTargetInvalid(class_3218 level, @NotNull Apparition apparition, @NotNull class_1309 target) {
        if (apparition.method_5968() == target) {
            apparition.method_18868().method_18875(class_4140.field_22355);
        }
    }

    public static void updateActivity(@NotNull Apparition apparition) {
        apparition.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
    }

    @NotNull
    private static Optional<? extends class_1309> findNearestValidAttackTarget(class_3218 level, @NotNull Apparition apparition) {
        class_4095<Apparition> brain = apparition.method_18868();
        if (brain.method_18896(class_4140.field_22354)) {
            return brain.method_18904(class_4140.field_22354);
        }
        return brain.method_18904(class_4140.field_30243);
    }

    public static void wasHurtBy(class_3218 level, @NotNull Apparition apparition, class_1309 target) {
        if (apparition.canTargetEntity((class_1297)target, level)) {
            if (!class_4148.method_37456((class_3218)level, (class_1309)apparition, (class_1309)target)) {
                return;
            }
            if (class_4215.method_24558((class_1309)apparition, (class_1309)target, (double)4.0)) {
                return;
            }
            ApparitionAi.setAngerTarget(level, apparition, target);
        }
    }

    public static void setAngerTarget(class_3218 level, @NotNull Apparition apparition, class_1309 target) {
        if (!class_4148.method_37456((class_3218)level, (class_1309)apparition, (class_1309)target)) {
            return;
        }
        apparition.method_18868().method_18875(class_4140.field_19293);
        apparition.method_18868().method_18878(class_4140.field_22355, (Object)target);
    }
}

