/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import net.frozenblock.trailiertales.registry.TTStructureTypes;
import net.frozenblock.trailiertales.worldgen.structure.RuinsPieceHandler;
import net.frozenblock.trailiertales.worldgen.structure.RuinsPieces;
import net.frozenblock.trailiertales.worldgen.structure.datagen.BadlandsRuinsGenerator;
import net.frozenblock.trailiertales.worldgen.structure.datagen.DeepslateRuinsGenerator;
import net.frozenblock.trailiertales.worldgen.structure.datagen.DesertRuinsGenerator;
import net.frozenblock.trailiertales.worldgen.structure.datagen.GenericRuinsGenerator;
import net.frozenblock.trailiertales.worldgen.structure.datagen.JungleRuinsGenerator;
import net.frozenblock.trailiertales.worldgen.structure.datagen.SavannaRuinsGenerator;
import net.frozenblock.trailiertales.worldgen.structure.datagen.SnowyRuinsGenerator;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3300;
import net.minecraft.class_3341;
import net.minecraft.class_3542;
import net.minecraft.class_5497;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6019;
import net.minecraft.class_6122;
import net.minecraft.class_6626;
import net.minecraft.class_7151;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RuinsStructure
extends class_3195 {
    public static final MapCodec<RuinsStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RuinsStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)Type.CODEC.optionalFieldOf("ruins_type", (Object)Type.GENERIC).forGetter(feature -> feature.ruinsType), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("cluster_probability").forGetter(feature -> Float.valueOf(feature.clusterProbability)), (App)class_6019.field_29949.fieldOf("cluster_pieces").forGetter(feature -> feature.clusterPieces), (App)class_2902.class_2903.field_24772.lenientOptionalFieldOf("heightmap").forGetter(feature -> feature.heightmap), (App)class_6122.field_31540.lenientOptionalFieldOf("height_provider").forGetter(feature -> feature.heightProvider)).apply((Applicative)instance, RuinsStructure::new));
    public final Type ruinsType;
    public final float clusterProbability;
    public final class_6019 clusterPieces;
    public final Optional<class_2902.class_2903> heightmap;
    public final Optional<class_6122> heightProvider;
    public Optional<Integer> providedHeight = Optional.empty();

    private RuinsStructure(class_3195.class_7302 settings, Type ruinsType, float clusterProbability, class_6019 clusterPieces, Optional<class_2902.class_2903> heightmap, Optional<class_6122> heightProvider) {
        super(settings);
        this.ruinsType = ruinsType;
        this.clusterProbability = clusterProbability;
        this.clusterPieces = clusterPieces;
        this.heightmap = heightmap;
        this.heightProvider = heightProvider;
    }

    public RuinsStructure(class_3195.class_7302 settings, Type ruinsType, float clusterProbability, class_6019 clusterPieces, class_2902.class_2903 heightmap) {
        this(settings, ruinsType, clusterProbability, clusterPieces, Optional.of(heightmap), Optional.empty());
    }

    public RuinsStructure(class_3195.class_7302 settings, Type ruinsType, float clusterProbability, class_6019 clusterPieces, class_6122 heightProvider) {
        this(settings, ruinsType, clusterProbability, clusterPieces, Optional.empty(), Optional.of(heightProvider));
    }

    public int getHeight(class_2338 pos, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_3195.class_7149 context) {
        class_5539 heightAccessor = context.comp_569();
        class_2794 chunkGenerator = context.comp_562();
        class_2902.class_2903 heightmapType = this.heightmap.orElseGet(() -> this.heightProvider.isEmpty() ? class_2902.class_2903.field_13195 : null);
        if (heightmapType != null) {
            return chunkGenerator.method_18028(pos.method_10263(), pos.method_10260(), heightmapType, heightAccessor, context.comp_564());
        }
        class_5868 worldGenerationContext = new class_5868(chunkGenerator, heightAccessor);
        int y = this.heightProvider.get().method_35391(context.comp_566().method_38421().method_38419(pos), worldGenerationContext);
        this.providedHeight = Optional.of(y);
        return y;
    }

    @NotNull
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        int y = this.getHeight(new class_2338(x, 0, z), context);
        class_2338 startPos = new class_2338(x, y, z);
        return Optional.of(new class_3195.class_7150(startPos, this.generatePieces(startPos, context)));
    }

    @Contract(pure=true)
    @NotNull
    private Consumer<class_6626> generatePieces(class_2338 startPos, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_3195.class_7149 context) {
        return structurePiecesBuilder -> {
            ArrayList list = Lists.newArrayList();
            int x = startPos.method_10263();
            int y = startPos.method_10264();
            int z = startPos.method_10260();
            class_5539 heightAccessor = context.comp_569();
            class_3341 box = new class_3341(x - 128, Math.max(y - 128, heightAccessor.method_31607() + 7), z - 128, x + 128 + 1, Math.min(y + 128 + 1, heightAccessor.method_31600()), z + 128 + 1);
            RuinsPieces.addPieces(context.comp_565(), heightAccessor, startPos, class_2470.method_16548((class_5819)context.comp_566()), (class_5819)context.comp_566(), this, list, box);
            list.forEach(arg_0 -> ((class_6626)structurePiecesBuilder).method_35462(arg_0));
        };
    }

    @NotNull
    public class_7151<?> method_41618() {
        return TTStructureTypes.RUINS;
    }

    public static void onServerDataReload(@NotNull class_3300 resourceManager) {
        Arrays.stream(Type.values()).toList().forEach(type -> type.getPieceHandler().onDataReload(resourceManager));
    }

    public static enum Type implements class_3542
    {
        GENERIC("generic", GenericRuinsGenerator.PROCESSORS, false),
        SNOWY("snowy", SnowyRuinsGenerator.PROCESSORS, false),
        BADLANDS("badlands", BadlandsRuinsGenerator.PROCESSORS, false),
        DESERT("desert", DesertRuinsGenerator.PROCESSORS, false),
        JUNGLE("jungle", JungleRuinsGenerator.PROCESSORS, false),
        SAVANNA("savanna", SavannaRuinsGenerator.PROCESSORS, false),
        DEEPSLATE("deepslate", DeepslateRuinsGenerator.PROCESSORS, true);

        public static final Codec<Type> CODEC;
        private final String name;
        private final class_5497 processors;
        private final boolean underground;
        private final RuinsPieceHandler pieceHandler;

        private Type(String name, class_5497 processors, boolean underground) {
            this.name = name;
            this.processors = processors;
            this.underground = underground;
            this.pieceHandler = new RuinsPieceHandler(this);
        }

        public String getName() {
            return this.name;
        }

        public class_5497 getProcessors() {
            return this.processors;
        }

        public boolean isUnderground() {
            return this.underground;
        }

        public RuinsPieceHandler getPieceHandler() {
            return this.pieceHandler;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }
}

