/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_3620;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.casperix.map_improvements.types.ABGRColor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u001c\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R2\u0010#\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00060 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\"\u00a8\u0006$"}, d2={"Lru/casperix/map_improvements/VanillaColorConverter;", "", "<init>", "()V", "", "factor", "Lkotlin/Pair;", "", "Lru/casperix/map_improvements/types/ABGRColor;", "", "createMap", "(F)Lkotlin/Pair;", "Ljava/nio/IntBuffer;", "targetRGBA", "", "sourceVanillaPackedColorArray", "", "vanillaPackedColorToRgba", "(Ljava/nio/IntBuffer;[B)V", "Lnet/minecraft/class_3620;", "color", "mapColorToRgba", "(Lnet/minecraft/class_3620;)Lru/casperix/map_improvements/types/ABGRColor;", "sourceColor", "rgbaToVanillaPackedColor", "(Lru/casperix/map_improvements/types/ABGRColor;)B", "vanillaPackedColor", "(B)Lru/casperix/map_improvements/types/ABGRColor;", "", "alphaMask", "I", "unknownColor", "", "rgbaByMapColor", "Ljava/util/List;", "sampleMap", "map_improvements-mc1.20.1"})
@SourceDebugExtension(value={"SMAP\nVanillaColorConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VanillaColorConverter.kt\nru/casperix/map_improvements/VanillaColorConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,67:1\n1374#2:68\n1460#2,2:69\n1563#2:71\n1634#2,3:72\n1462#2,3:75\n1869#2,2:78\n1869#2,2:80\n11561#3:82\n11896#3,3:83\n*S KotlinDebug\n*F\n+ 1 VanillaColorConverter.kt\nru/casperix/map_improvements/VanillaColorConverter\n*L\n26#1:68\n26#1:69,2\n27#1:71\n27#1:72,3\n26#1:75,3\n37#1:78,2\n48#1:80,2\n12#1:82\n12#1:83,3\n*E\n"})
public final class VanillaColorConverter {
    @NotNull
    public static final VanillaColorConverter INSTANCE;
    private static final int alphaMask;
    private static final int unknownColor;
    @NotNull
    private static final List<ABGRColor> rgbaByMapColor;
    @NotNull
    private static final List<Pair<Float, Map<ABGRColor, Byte>>> sampleMap;

    private VanillaColorConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Float, Map<ABGRColor, Byte>> createMap(float factor) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = (Iterable)EntriesMappings.entries$0;
        Float f = Float.valueOf(factor);
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            class_3620.class_6594 brightness = (class_3620.class_6594)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)class_3620.field_16006, (String)"COLORS");
            Iterable $this$map$iv = ArraysKt.filterNotNull((Object[])class_3620.field_16006);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void mapColor;
                class_3620 class_36202 = (class_3620)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                ABGRColor original = new ABGRColor(mapColor.method_15820(brightness));
                ABGRColor key = ABGRColor.Companion.withAlpha(ABGRColor.Companion.mulRGBA(original, factor), 1.0f);
                byte packedColor = mapColor.method_38481(brightness);
                collection.add(TuplesKt.to((Object)key, (Object)packedColor));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return TuplesKt.to((Object)f, (Object)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
    }

    public final void vanillaPackedColorToRgba(@NotNull IntBuffer targetRGBA, @NotNull byte[] sourceVanillaPackedColorArray) {
        Intrinsics.checkNotNullParameter((Object)targetRGBA, (String)"targetRGBA");
        Intrinsics.checkNotNullParameter((Object)sourceVanillaPackedColorArray, (String)"sourceVanillaPackedColorArray");
        Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((byte[])sourceVanillaPackedColorArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            byte vanillaColor = sourceVanillaPackedColorArray[index];
            ABGRColor rgbaColor = INSTANCE.vanillaPackedColorToRgba(vanillaColor);
            targetRGBA.put(index, rgbaColor.getValue());
        }
    }

    @Nullable
    public final ABGRColor mapColorToRgba(@NotNull class_3620 color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return (ABGRColor)CollectionsKt.getOrNull(rgbaByMapColor, (int)color.field_16021);
    }

    @JvmName(name="rgbaToVanillaPackedColor")
    public final byte rgbaToVanillaPackedColor(@NotNull ABGRColor sourceColor) {
        Intrinsics.checkNotNullParameter((Object)sourceColor, (String)"sourceColor");
        Iterable $this$forEach$iv = sampleMap;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Byte packedColor;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            float factor = ((Number)pair.component1()).floatValue();
            Map subMap = (Map)pair.component2();
            ABGRColor colorKey = ABGRColor.Companion.withAlpha(ABGRColor.Companion.mulRGBA(sourceColor, factor), 1.0f);
            Byte by = packedColor = (Byte)subMap.get(colorKey);
            if (by == null) continue;
            return by;
        }
        return 0;
    }

    @NotNull
    public final ABGRColor vanillaPackedColorToRgba(byte vanillaPackedColor) {
        int data = vanillaPackedColor & 0xFF;
        int colorId = data >> 2;
        int brightnessId = data & 3;
        class_3620 mapColor = class_3620.method_38479((int)colorId);
        class_3620.class_6594 brightness = class_3620.class_6594.method_38484((int)brightnessId);
        return new ABGRColor(mapColor.method_15820(brightness));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new VanillaColorConverter();
        alphaMask = -16777216;
        unknownColor = 0xFF0000 | alphaMask;
        Intrinsics.checkNotNullExpressionValue((Object)class_3620.field_16006, (String)"COLORS");
        Object[] $this$map$iv = class_3620.field_16006;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void mapColor;
            class_3620 class_36202 = (class_3620)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mapColor != null ? new ABGRColor(mapColor.method_15820(class_3620.class_6594.field_34760)) : null);
        }
        rgbaByMapColor = (List)var3_3;
        Object[] objectArray2 = new Pair[]{INSTANCE.createMap(0.125f), INSTANCE.createMap(0.0625f), INSTANCE.createMap(0.03125f), INSTANCE.createMap(0.015625f)};
        sampleMap = CollectionsKt.listOf((Object[])objectArray2);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<class_3620.class_6594> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])class_3620.class_6594.values()));
        }
    }
}

