/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.codec;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.casperix.map_improvements.codec.ByteBufferBuilder;
import ru.casperix.map_improvements.codec.SimpleTypesCodec;
import ru.casperix.map_improvements.types.ColorFormat;
import ru.casperix.map_improvements.types.MapDTO;
import ru.casperix.map_improvements.types.MapLayerDTO;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u000f\u001a\u00020\t*\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lru/casperix/map_improvements/codec/MapDTOCodec;", "", "<init>", "()V", "Lru/casperix/map_improvements/types/MapDTO;", "map", "", "encode", "(Lru/casperix/map_improvements/types/MapDTO;)[B", "Ljava/nio/ByteBuffer;", "target", "", "(Ljava/nio/ByteBuffer;Lru/casperix/map_improvements/types/MapDTO;)V", "decode", "(Ljava/nio/ByteBuffer;)Lru/casperix/map_improvements/types/MapDTO;", "getByteBufferWithIntLength", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "", "MAP_FORMAT_VERSION", "I", "map_improvements-mc1.20.1"})
public final class MapDTOCodec {
    @NotNull
    public static final MapDTOCodec INSTANCE = new MapDTOCodec();
    private static final int MAP_FORMAT_VERSION = 3;

    private MapDTOCodec() {
    }

    @NotNull
    public final byte[] encode(@NotNull MapDTO map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        return ByteBufferBuilder.INSTANCE.create(100000, (Function1<? super ByteBuffer, Unit>)((Function1)arg_0 -> MapDTOCodec.encode$lambda$0(map, arg_0)));
    }

    public final void encode(@NotNull ByteBuffer target, @NotNull MapDTO map) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        ByteBuffer primaryColors = map.getPrimaryLayer().getColors();
        primaryColors.rewind();
        if (!(primaryColors.remaining() == map.getPrimaryLayer().getRegion().getDimension().volume() * 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        target.putInt(3);
        SimpleTypesCodec.INSTANCE.putVector2i(target, map.getSize());
        SimpleTypesCodec.INSTANCE.putVector2i(target, map.getCenter());
        target.putInt(map.getScale());
        SimpleTypesCodec.INSTANCE.putString(target, map.getPrimaryLayer().getFormat().name());
        SimpleTypesCodec.INSTANCE.putBox2i(target, map.getPrimaryLayer().getRegion());
        SimpleTypesCodec.INSTANCE.putByteBuffer(target, primaryColors);
    }

    @NotNull
    public final MapDTO decode(@NotNull ByteBuffer target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ByteBuffer $this$decode_u24lambda_u240 = target;
        boolean bl = false;
        int formatVersion = $this$decode_u24lambda_u240.getInt();
        MapDTO map = switch (formatVersion) {
            case 1 -> new MapDTO(SimpleTypesCodec.INSTANCE.getVector2i($this$decode_u24lambda_u240), SimpleTypesCodec.INSTANCE.getVector2i($this$decode_u24lambda_u240), $this$decode_u24lambda_u240.getInt(), new MapLayerDTO(ColorFormat.valueOf(SimpleTypesCodec.INSTANCE.getString($this$decode_u24lambda_u240)), SimpleTypesCodec.INSTANCE.getBox2i($this$decode_u24lambda_u240), INSTANCE.getByteBufferWithIntLength($this$decode_u24lambda_u240)));
            case 3 -> new MapDTO(SimpleTypesCodec.INSTANCE.getVector2i($this$decode_u24lambda_u240), SimpleTypesCodec.INSTANCE.getVector2i($this$decode_u24lambda_u240), $this$decode_u24lambda_u240.getInt(), new MapLayerDTO(ColorFormat.valueOf(SimpleTypesCodec.INSTANCE.getString($this$decode_u24lambda_u240)), SimpleTypesCodec.INSTANCE.getBox2i($this$decode_u24lambda_u240), SimpleTypesCodec.INSTANCE.getByteBuffer($this$decode_u24lambda_u240)));
            default -> throw new Exception("Expected MapDTO version $1, 3 but actual " + formatVersion);
        };
        map.validate();
        return map;
    }

    @NotNull
    public final ByteBuffer getByteBufferWithIntLength(@NotNull ByteBuffer $this$getByteBufferWithIntLength) {
        Intrinsics.checkNotNullParameter((Object)$this$getByteBufferWithIntLength, (String)"<this>");
        int size = $this$getByteBufferWithIntLength.getInt() * 4;
        int start = $this$getByteBufferWithIntLength.position();
        int finish = start + size;
        ByteBuffer output = $this$getByteBufferWithIntLength.slice(start, size);
        $this$getByteBufferWithIntLength.position(finish);
        Intrinsics.checkNotNull((Object)output);
        return output;
    }

    private static final Unit encode$lambda$0(MapDTO $map, ByteBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.encode(it, $map);
        return Unit.INSTANCE;
    }
}

