/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import ru.casperix.math.vector.int32.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lru/casperix/map_improvements/composite/LightShadingFactory;", "", "<init>", "()V", "Lru/casperix/math/vector/int32/Vector2i;", "position", "", "sampleRange", "", "maxHeightDiff", "", "heightMap", "getDirectionalShading", "(Lru/casperix/math/vector/int32/Vector2i;IFLjava/util/Map;)F", "map_improvements-mc1.20.1"})
public final class LightShadingFactory {
    @NotNull
    public static final LightShadingFactory INSTANCE = new LightShadingFactory();

    private LightShadingFactory() {
    }

    public final float getDirectionalShading(@NotNull Vector2i position, int sampleRange, float maxHeightDiff, @NotNull Map<Vector2i, Integer> heightMap) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(heightMap, (String)"heightMap");
        Integer n = heightMap.get(position);
        float centerY = n != null ? (float)n.intValue() : 0.0f;
        float lightFactor = 0.0f;
        float totalWeight = 0.0f;
        int dx = -sampleRange;
        if (dx <= sampleRange) {
            while (true) {
                int dz;
                if ((dz = -sampleRange) <= sampleRange) {
                    while (true) {
                        if (dx != 0 || dz != 0) {
                            Vector2i sidePos = position.plus(new Vector2i(dx, dz));
                            Integer n2 = heightMap.get(sidePos);
                            float neighborY = n2 != null ? (float)n2.intValue() : centerY;
                            float heightDiff = neighborY - centerY;
                            float directionalWeight = Math.max(0.0f, (float)dz * 0.7f - (float)dx * 0.7f);
                            float distanceWeight = 1.0f / (1.0f + (float)Math.sqrt((float)(dx * dx) + (float)dz * (float)dz));
                            float normalizedHeightDiff = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(heightDiff / maxHeightDiff), (ClosedFloatingPointRange)RangesKt.rangeTo((float)-1.0f, (float)1.0f)))).floatValue();
                            float weight = directionalWeight * distanceWeight;
                            lightFactor += normalizedHeightDiff * weight;
                            totalWeight += weight;
                        }
                        if (dz == sampleRange) break;
                        ++dz;
                    }
                }
                if (dx == sampleRange) break;
                ++dx;
            }
        }
        return Math.abs(totalWeight) > 0.001f ? lightFactor / totalWeight : 0.0f;
    }
}

