/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import ru.casperix.RGBAMapFeature;
import ru.casperix.map_improvements.LoggerKt;
import ru.casperix.map_improvements.composite.MapCompositor;
import ru.casperix.map_improvements.composite.MapContext;
import ru.casperix.map_improvements.composite.VanillaMapDrawer;
import ru.casperix.map_improvements.composite.VisibilityCalculator;
import ru.casperix.map_improvements.composite.WorldColumn;
import ru.casperix.map_improvements.composite.collector.ColumnCollector;
import ru.casperix.map_improvements.composite.collector.RaytracingColumnCollector;
import ru.casperix.map_improvements.composite.collector.SimpleColumnCollector;
import ru.casperix.map_improvements.composite.drawer.DebugDrawMode;
import ru.casperix.map_improvements.composite.drawer.DebugMapDrawer;
import ru.casperix.map_improvements.composite.drawer.MapDrawer;
import ru.casperix.map_improvements.composite.drawer.RGBAMapDrawer;
import ru.casperix.map_improvements.composite.effect.AddTransparentColor;
import ru.casperix.map_improvements.composite.effect.MapColorEffect;
import ru.casperix.map_improvements.composite.effect.MapDistanceEffect;
import ru.casperix.map_improvements.composite.effect.MixWithBackground;
import ru.casperix.map_improvements.composite.effect.SetSolidColor;
import ru.casperix.map_improvements.config.ModConfig;
import ru.casperix.map_improvements.config.ModConfigProvider;
import ru.casperix.map_improvements.misc.BlockAccessor;
import ru.casperix.map_improvements.misc.CachedBlockAccessor;
import ru.casperix.map_improvements.types.MathExtKt;
import ru.casperix.map_improvements.types.TypeExtensionsKt;
import ru.casperix.math.axis_aligned.int32.Box2i;
import ru.casperix.math.axis_aligned.int32.Box3i;
import ru.casperix.math.vector.int32.Vector2i;
import ru.casperix.math.vector.int32.Vector3i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J=\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010\"\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\"\u0010#J)\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b%\u0010&J-\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010'\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b(\u0010)J'\u0010+\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010.\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b.\u0010/R\u0011\u00103\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R \u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001a048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106\u00a8\u00067"}, d2={"Lru/casperix/map_improvements/composite/MapCompositorCaller;", "", "<init>", "()V", "", "n", "modifyScaleMultiplier", "(I)I", "", "bl2", "modifyCheckmateBorder", "(Z)Z", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_1297;", "entity", "Lnet/minecraft/class_22;", "mapData", "", "update", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1297;Lnet/minecraft/class_22;)V", "Lru/casperix/map_improvements/misc/BlockAccessor;", "blockAccessor", "Lru/casperix/map_improvements/composite/MapContext;", "mapContext", "", "Lru/casperix/math/vector/int32/Vector2i;", "tiles", "Lru/casperix/math/vector/int32/Vector3i;", "viewPosition", "viewRange", "composite", "(Lru/casperix/map_improvements/misc/BlockAccessor;Lru/casperix/map_improvements/composite/MapContext;Ljava/util/List;Lru/casperix/math/vector/int32/Vector3i;I)V", "Lru/casperix/map_improvements/composite/drawer/RGBAMapDrawer;", "createRgbaMapDrawer", "(Lru/casperix/math/vector/int32/Vector3i;I)Lru/casperix/map_improvements/composite/drawer/RGBAMapDrawer;", "Lru/casperix/math/axis_aligned/int32/Box2i;", "getAffectedBox", "(Lru/casperix/map_improvements/composite/MapContext;Lru/casperix/math/vector/int32/Vector2i;I)Lru/casperix/math/axis_aligned/int32/Box2i;", "checkArea", "getAffectedTiles", "(Lru/casperix/math/axis_aligned/int32/Box2i;Lru/casperix/math/vector/int32/Vector2i;I)Ljava/util/List;", "worldPos", "rangeFilter", "(Lru/casperix/math/vector/int32/Vector2i;Lru/casperix/math/vector/int32/Vector2i;I)Z", "key", "checkDistance", "(Lru/casperix/math/vector/int32/Vector2i;Lnet/minecraft/class_22;)Z", "Lru/casperix/map_improvements/config/ModConfig;", "getConfig", "()Lru/casperix/map_improvements/config/ModConfig;", "config", "", "lastViewPositionMap", "Ljava/util/Map;", "map_improvements-mc1.20.1"})
@SourceDebugExtension(value={"SMAP\nMapCompositorCaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapCompositorCaller.kt\nru/casperix/map_improvements/composite/MapCompositorCaller\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n95#2:150\n135#2,3:151\n95#2:154\n135#2,3:155\n1#3:158\n774#4:159\n865#4,2:160\n*S KotlinDebug\n*F\n+ 1 MapCompositorCaller.kt\nru/casperix/map_improvements/composite/MapCompositorCaller\n*L\n55#1:150\n55#1:151,3\n85#1:154\n85#1:155,3\n132#1:159\n132#1:160,2\n*E\n"})
public final class MapCompositorCaller {
    @NotNull
    public static final MapCompositorCaller INSTANCE = new MapCompositorCaller();
    @NotNull
    private static final Map<class_22, Vector2i> lastViewPositionMap = new LinkedHashMap();

    private MapCompositorCaller() {
    }

    @NotNull
    public final ModConfig getConfig() {
        return ModConfigProvider.INSTANCE.getConfig();
    }

    public final int modifyScaleMultiplier(int n) {
        int originalBaseRadius = 128;
        int scaleLevel = originalBaseRadius / n;
        return this.getConfig().getMaxRenderDistance() / scaleLevel;
    }

    public final boolean modifyCheckmateBorder(boolean bl2) {
        if (!this.getConfig().getEnableBorderDithering()) {
            return false;
        }
        return bl2;
    }

    public final void update(@NotNull class_1937 level, @NotNull class_1297 entity, @NotNull class_22 mapData) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)mapData, (String)"mapData");
        if (!(entity instanceof class_1657)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)level.method_27983(), (Object)mapData.field_118)) {
            return;
        }
        int maxViewRange = this.modifyScaleMultiplier(128);
        class_243 class_2432 = ((class_1657)entity).method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getPos(...)");
        Vector3i viewPosition = TypeExtensionsKt.toVector3d(class_2432).roundToVector3i().plus(Vector3i.Companion.getZ());
        if (!this.checkDistance(viewPosition.getXZ(), mapData)) {
            return;
        }
        MapContext mapContext = new MapContext(mapData, level);
        Box2i viewBounds = null;
        Box2i box2i = this.getAffectedBox(mapContext, viewPosition.getXZ(), maxViewRange);
        if (box2i == null) {
            return;
        }
        viewBounds = box2i;
        int viewRange = 0;
        viewRange = maxViewRange;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        CachedBlockAccessor blockAccessor = new CachedBlockAccessor(level);
        if (INSTANCE.getConfig().getRenderOnSurfaceOnly()) {
            viewRange = VisibilityCalculator.INSTANCE.calculateVisibilityRange(blockAccessor, viewPosition, viewRange);
            Box2i box2i2 = INSTANCE.getAffectedBox(mapContext, viewPosition.getXZ(), viewRange);
            if (box2i2 == null) {
                return;
            }
            viewBounds = box2i2;
        }
        if (viewRange > 0) {
            blockAccessor.preloadArea(Box3i.Companion.byRadius(viewPosition, new Vector3i(viewRange)));
        }
        CachedBlockAccessor result$iv$iv = blockAccessor;
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        CachedBlockAccessor blockAccessor2 = (CachedBlockAccessor)timedValue.component1();
        long blockAccessorTime = timedValue.component2-UwyO8pc();
        LoggerKt.getLogger().debug("Prepare: " + Duration.getInWholeMilliseconds-impl((long)blockAccessorTime) + "ms; Map: " + mapData.field_116 + "x" + mapData.field_115 + "; ViewRange: " + viewRange + " / " + maxViewRange + ";");
        List<Vector2i> tiles = this.getAffectedTiles(viewBounds, viewPosition.getXZ(), viewRange);
        this.composite(blockAccessor2, new MapContext(mapData, level), tiles, viewPosition, viewRange);
    }

    private final void composite(BlockAccessor blockAccessor, MapContext mapContext, List<Vector2i> tiles, Vector3i viewPosition, int viewRange) {
        if (viewRange == 0) {
            return;
        }
        if (tiles.isEmpty()) {
            return;
        }
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        ColumnCollector columnCollector = INSTANCE.getConfig().getEnableRayTracing() ? (ColumnCollector)new RaytracingColumnCollector(blockAccessor, mapContext, viewPosition, viewRange) : (ColumnCollector)new SimpleColumnCollector(blockAccessor, mapContext, INSTANCE.getConfig().getBlockRender());
        DebugDrawMode debugDrawMode = INSTANCE.getConfig().getDebugDrawMode();
        MapDrawer mapDrawer = debugDrawMode != null ? (MapDrawer)new DebugMapDrawer(debugDrawMode) : (mapContext.getMapData() instanceof RGBAMapFeature ? (MapDrawer)INSTANCE.createRgbaMapDrawer(viewPosition, viewRange) : (MapDrawer)new VanillaMapDrawer());
        MapCompositor compositor = new MapCompositor(tiles, mapContext, columnCollector, mapDrawer);
        compositor.updateVisibleArea(viewPosition, viewRange);
        compositor.updateBanners();
        Map<Vector2i, WorldColumn> result$iv$iv = compositor.getColumnMap();
        TimedValue timedValue = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        Map columnMap = (Map)timedValue.component1();
        long compositeTime = timedValue.component2-UwyO8pc();
        LoggerKt.getLogger().debug("Composite: " + Duration.getInWholeMilliseconds-impl((long)compositeTime) + "ms; Map: " + mapContext.getMapData().field_116 + "x" + mapContext.getMapData().field_115 + "; Tiles: " + tiles.size() + "; Columns: " + columnMap.size());
    }

    private final RGBAMapDrawer createRgbaMapDrawer(Vector3i viewPosition, int viewRange) {
        Object[] objectArray = new MapColorEffect[]{new SetSolidColor(this.getConfig().getTerrainShading()), new AddTransparentColor(this.getConfig().getTerrainShading(), this.getConfig().getBlockRender())};
        List effectList = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.getConfig().getFadeOutPercent() > 0.0f) {
            int fadeStart = RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)viewRange * (1.0f - this.getConfig().getFadeOutPercent()))), (ClosedRange)((ClosedRange)new IntRange(0, viewRange)));
            int fadeFinish = viewRange;
            ((Collection)effectList).add(new MapDistanceEffect(viewPosition.getXZ(), fadeStart, fadeFinish));
            ((Collection)effectList).add(new MixWithBackground());
        }
        return new RGBAMapDrawer(effectList);
    }

    private final Box2i getAffectedBox(MapContext mapContext, Vector2i viewPosition, int viewRange) {
        Box2i box2i;
        Box2i viewArea = Box2i.Companion.byRadius(viewPosition, new Vector2i(viewRange));
        Box2i box2i2 = MathExtKt.intersection(mapContext.getMapArea(), viewArea);
        if (box2i2 != null) {
            Box2i $this$getAffectedBox_u24lambda_u240 = box2i2;
            boolean bl = false;
            box2i = new Box2i($this$getAffectedBox_u24lambda_u240.getMin().minus(Vector2i.Companion.getONE()), $this$getAffectedBox_u24lambda_u240.getMax().plus(Vector2i.Companion.getONE()));
        } else {
            box2i = null;
        }
        return box2i;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Vector2i> getAffectedTiles(Box2i checkArea, Vector2i viewPosition, int viewRange) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)checkArea.iterator()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Vector2i worldPos = (Vector2i)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.rangeFilter(worldPos, viewPosition, viewRange + 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean rangeFilter(Vector2i worldPos, Vector2i viewPosition, int viewRange) {
        return worldPos.distTo(viewPosition) <= viewRange;
    }

    private final boolean checkDistance(Vector2i viewPosition, class_22 key) {
        Vector2i lastViewPosition = lastViewPositionMap.get(key);
        if (lastViewPosition != null && viewPosition.distTo(lastViewPosition) < this.getConfig().getMinMovementForUpdate()) {
            return false;
        }
        lastViewPositionMap.put(key, viewPosition);
        return true;
    }
}

